/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;

public class ApplicationInfoImpl
extends ApplicationInfoEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.application.impl.ApplicationInfoImpl");
    private String myCodeName = null;
    private String myMajorVersion = null;
    private String myMinorVersion = null;
    private String myMicroVersion = null;
    private String myPatchVersion = null;
    private String myFullVersion = null;
    private String myBuildNumber = null;
    private String myApiVersion = null;
    private String myCompanyName = "JetBrains s.r.o.";
    private String myCompanyUrl = "https://www.jetbrains.com/";
    private Color myProgressColor = null;
    private Color myCopyrightForeground = JBColor.BLACK;
    private Color myAboutForeground = JBColor.BLACK;
    private Color myAboutLinkColor = null;
    private String myProgressTailIconName = null;
    private Icon myProgressTailIcon = null;
    private int myProgressY = 350;
    private String mySplashImageUrl = null;
    private String myAboutImageUrl = null;
    private Color mySplashTextColor = new Color(0, 35, 135);
    private String myIconUrl = "/icon.png";
    private String mySmallIconUrl = "/icon_small.png";
    private String myBigIconUrl = null;
    private String myOpaqueIconUrl = "/icon.png";
    private String myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
    private String myWelcomeScreenLogoUrl = null;
    private String myEditorBackgroundImageUrl = null;
    private Calendar myBuildDate = null;
    private Calendar myMajorReleaseBuildDate = null;
    private String myPackageCode = null;
    private boolean myShowLicensee = true;
    private String myWelcomeScreenCaptionUrl;
    private String myWelcomeScreenDeveloperSloganUrl;
    private String myCustomizeIDEWizardStepsProvider;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myEAPFeedbackUrl;
    private String myReleaseFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp = true;
    private boolean myHasContextHelp = true;
    private String myHelpFileName = "ideahelp.jar";
    private String myHelpRootName = "idea";
    private String myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
    private List<Object> myPluginChooserPages = new ArrayList<Object>();
    private String myStatisticsSettingsUrl;
    private String myStatisticsServiceUrl;
    private String myStatisticsServiceKey;
    private String myThirdPartySoftwareUrl;
    private String myJetbrainsTvUrl;
    private Rectangle myAboutLogoRect;
    private static ApplicationInfoImpl ourShadowInstance;
    private static volatile boolean myInPerformanceTest;

    public BuildNumber getBuild() {
        return BuildNumber.fromString(this.myBuildNumber, ApplicationInfoImpl.getProductPrefix());
    }

    private static String getProductPrefix() {
        String prefix = null;
        if (PlatformUtils.isIdeaCommunity()) {
            prefix = "IC";
        } else if (PlatformUtils.isIdeaUltimate()) {
            prefix = "IU";
        }
        return prefix;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    public static ApplicationInfoEx getShadowInstance() {
        if (ourShadowInstance == null) {
            ourShadowInstance = new ApplicationInfoImpl();
            try {
                Document doc = JDOMUtil.loadDocument(ApplicationInfoImpl.class, "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml");
                ourShadowInstance.readExternal(doc.getRootElement());
            }
            catch (FileNotFoundException e) {
                LOG.error("Resource is not in classpath or wrong platform prefix: " + System.getProperty("idea.platform.prefix"), e);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return ourShadowInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(Element parentNode) throws InvalidDataException {
        Element tvElement;
        Element keymapElement;
        Element pluginsElement;
        Element whatsnewElement;
        Element feedbackElement;
        Element supportElement;
        Element helpElement;
        Element editor;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconElement;
        Element aboutLogoElement;
        Element buildElement;
        Element companyElement;
        Element versionElement = parentNode.getChild("version");
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue("major");
            this.myMinorVersion = versionElement.getAttributeValue("minor");
            this.myMicroVersion = versionElement.getAttributeValue("micro");
            this.myPatchVersion = versionElement.getAttributeValue("patch");
            this.myFullVersion = versionElement.getAttributeValue("full");
            this.myCodeName = versionElement.getAttributeValue("codename");
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue("eap"));
        }
        if ((companyElement = parentNode.getChild("company")) != null) {
            this.myCompanyName = companyElement.getAttributeValue("name", this.myCompanyName);
            this.myCompanyUrl = companyElement.getAttributeValue("url", this.myCompanyUrl);
        }
        if ((buildElement = parentNode.getChild("build")) != null) {
            String majorReleaseDateString;
            this.myBuildNumber = buildElement.getAttributeValue("number");
            this.myApiVersion = buildElement.getAttributeValue("apiVersion");
            PluginManagerCore.BUILD_NUMBER = this.myApiVersion != null ? this.myApiVersion : this.myBuildNumber;
            String dateString = buildElement.getAttributeValue("date");
            if (dateString.equals("__BUILD_DATE__")) {
                this.myBuildDate = new GregorianCalendar();
                try {
                    JarFile bootJar = new JarFile(PathManager.getHomePath() + File.separator + "lib" + File.separator + "boot.jar");
                    try {
                        JarEntry jarEntry = bootJar.entries().nextElement();
                        this.myBuildDate.setTime(new Date(jarEntry.getTime()));
                    }
                    finally {
                        bootJar.close();
                    }
                }
                catch (Exception bootJar) {}
            } else {
                this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
            }
            if ((majorReleaseDateString = buildElement.getAttributeValue("majorReleaseDate")) != null) {
                this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
            }
        }
        Thread currentThread = Thread.currentThread();
        currentThread.setName(currentThread.getName() + " " + this.myMajorVersion + "." + this.myMinorVersion + "#" + this.myBuildNumber + ", eap:" + this.myEAP);
        Element logoElement = parentNode.getChild("logo");
        if (logoElement != null) {
            this.mySplashImageUrl = logoElement.getAttributeValue("url");
            this.mySplashTextColor = ApplicationInfoImpl.parseColor(logoElement.getAttributeValue("textcolor"));
            String v = logoElement.getAttributeValue("progressColor");
            if (v != null) {
                this.myProgressColor = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = logoElement.getAttributeValue("progressTailIcon")) != null) {
                this.myProgressTailIconName = v;
            }
            if ((v = logoElement.getAttributeValue("progressY")) != null) {
                this.myProgressY = Integer.parseInt(v);
            }
        }
        if ((aboutLogoElement = parentNode.getChild("about")) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue("url");
            String v = aboutLogoElement.getAttributeValue("foreground");
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue("copyrightForeground")) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue("linkColor")) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new Rectangle(Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = parentNode.getChild("icon")) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue("size16");
            this.myOpaqueIconUrl = iconElement.getAttributeValue("size32opaque");
            this.myBigIconUrl = iconElement.getAttributeValue("size128", (String)null);
            String toolWindowIcon = iconElement.getAttributeValue("size12");
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
        }
        if ((packageElement = parentNode.getChild("package")) != null) {
            this.myPackageCode = packageElement.getAttributeValue("code");
        }
        if ((showLicensee = parentNode.getChild("licensee")) != null) {
            this.myShowLicensee = Boolean.valueOf(showLicensee.getAttributeValue("show"));
        }
        if ((welcomeScreen = parentNode.getChild("welcome-screen")) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue("logo-url");
            this.myWelcomeScreenCaptionUrl = welcomeScreen.getAttributeValue("caption-url");
            this.myWelcomeScreenDeveloperSloganUrl = welcomeScreen.getAttributeValue("slogan-url");
        }
        if ((wizardSteps = parentNode.getChild("customize-ide-wizard")) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue("provider");
        }
        if ((editor = parentNode.getChild("editor")) != null) {
            this.myEditorBackgroundImageUrl = editor.getAttributeValue("background-url");
        }
        if ((helpElement = parentNode.getChild("help")) != null) {
            String attValue;
            this.myHelpFileName = helpElement.getAttributeValue("file");
            this.myHelpRootName = helpElement.getAttributeValue("root");
            String webHelpUrl = helpElement.getAttributeValue("webhelp-url");
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue("has-context-help");
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        Element updateUrls = parentNode.getChild("update-urls");
        this.myUpdateUrls = new UpdateUrlsImpl(updateUrls);
        Element documentationElement = parentNode.getChild("documentation");
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue("url");
        }
        if ((supportElement = parentNode.getChild("support")) != null) {
            this.mySupportUrl = supportElement.getAttributeValue("url");
        }
        if ((feedbackElement = parentNode.getChild("feedback")) != null) {
            this.myEAPFeedbackUrl = feedbackElement.getAttributeValue("eap-url");
            this.myReleaseFeedbackUrl = feedbackElement.getAttributeValue("release-url");
        }
        if ((whatsnewElement = parentNode.getChild("whatsnew")) != null) {
            this.myWhatsNewUrl = whatsnewElement.getAttributeValue("url");
        }
        if ((pluginsElement = parentNode.getChild("plugins")) != null) {
            String url = pluginsElement.getAttributeValue("url");
            this.myPluginManagerUrl = url != null ? url : "http://plugins.jetbrains.com";
            boolean closed = StringUtil.endsWith(this.myPluginManagerUrl, "/");
            String listUrl = pluginsElement.getAttributeValue("list-url");
            this.myPluginsListUrl = listUrl != null ? listUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "plugins/list/";
            String downloadUrl = pluginsElement.getAttributeValue("download-url");
            String string = downloadUrl != null ? downloadUrl : (this.myPluginsDownloadUrl = this.myPluginManagerUrl + (closed ? "" : "/") + "pluginManager/");
            if (!this.getBuild().isSnapshot()) {
                this.myBuiltinPluginsUrl = pluginsElement.getAttributeValue("builtin-url");
            }
        } else {
            this.myPluginManagerUrl = "http://plugins.jetbrains.com";
            this.myPluginsListUrl = "http://plugins.jetbrains.com/plugins/list/";
            this.myPluginsDownloadUrl = "http://plugins.jetbrains.com/pluginManager/";
        }
        String pluginsHost = System.getProperty("idea.plugins.host");
        if (pluginsHost != null) {
            this.myPluginsListUrl = this.myPluginsListUrl.replace("http://plugins.jetbrains.com", pluginsHost);
            this.myPluginsDownloadUrl = this.myPluginsDownloadUrl.replace("http://plugins.jetbrains.com", pluginsHost);
        }
        if ((keymapElement = parentNode.getChild("keymap")) != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue("win");
            this.myMacKeymapUrl = keymapElement.getAttributeValue("mac");
        }
        this.myPluginChooserPages = new ArrayList<Object>();
        List<Element> children = parentNode.getChildren("plugins-page");
        for (Element child : children) {
            this.myPluginChooserPages.add(new PluginChooserPageImpl(child));
        }
        Element statisticsElement = parentNode.getChild("statistics");
        if (statisticsElement != null) {
            this.myStatisticsSettingsUrl = statisticsElement.getAttributeValue("settings");
            this.myStatisticsServiceUrl = statisticsElement.getAttributeValue("service");
            this.myStatisticsServiceKey = statisticsElement.getAttributeValue("service-key");
        } else {
            this.myStatisticsSettingsUrl = "https://www.jetbrains.com/idea/statistics/stat-assistant.xml";
            this.myStatisticsServiceUrl = "https://www.jetbrains.com/idea/statistics/index.jsp";
            this.myStatisticsServiceKey = null;
        }
        Element thirdPartyElement = parentNode.getChild("third-party");
        if (thirdPartyElement != null) {
            this.myThirdPartySoftwareUrl = thirdPartyElement.getAttributeValue("url");
        }
        if ((tvElement = parentNode.getChild("jetbrains-tv")) != null) {
            this.myJetbrainsTvUrl = tvElement.getAttributeValue("url");
        }
    }

    private static GregorianCalendar parseDate(String dateString) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        try {
            year = Integer.parseInt(dateString.substring(0, 4));
            month = Integer.parseInt(dateString.substring(4, 6));
            day = Integer.parseInt(dateString.substring(6, 8));
            if (dateString.length() > 8) {
                hour = Integer.parseInt(dateString.substring(8, 10));
                minute = Integer.parseInt(dateString.substring(10, 12));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (month > 0) {
            --month;
        }
        return new GregorianCalendar(year, month, day, hour, minute);
    }

    private static Color parseColor(String colorString) {
        long rgb = Long.parseLong(colorString, 16);
        return new Color((int)rgb, rgb > 0xFFFFFFL);
    }

    public static boolean isInPerformanceTest() {
        return myInPerformanceTest;
    }

    private static class PluginChooserPageImpl {
        private final String myTitle;
        private final String myCategory;
        private final String myDependentPlugin;

        private PluginChooserPageImpl(Element e) {
            this.myTitle = e.getAttributeValue("title");
            this.myCategory = e.getAttributeValue("category");
            this.myDependentPlugin = e.getAttributeValue("depends");
        }
    }

    private static class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private String myCheckingUrl;
        private String myPatchesUrl;

        private UpdateUrlsImpl(Element element) {
            if (element != null) {
                this.myCheckingUrl = element.getAttributeValue("check");
                this.myPatchesUrl = element.getAttributeValue("patches");
            }
        }
    }
}

