/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.WalkingState;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import gnu.trove.TLongHashSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class IntervalTreeImpl<T extends MutableInterval>
extends RedBlackTree<T> {
    private int keySize;
    protected final ReadWriteLock l = new ReentrantReadWriteLock();
    private final ReferenceQueue<T> myReferenceQueue = new ReferenceQueue();
    private int deadReferenceCount;
    private static final IntervalTreeGuide INTERVAL_TREE_GUIDE_INSTANCE = new IntervalTreeGuide();

    IntervalTreeImpl() {
    }

    protected abstract int compareEqualStartIntervals(@NotNull IntervalNode<T> var1, @NotNull IntervalNode<T> var2);

    private void assertUnderWriteLock() {
        assert (IntervalTreeImpl.isAcquired(this.l.writeLock())) : this.l.writeLock();
    }

    private static boolean isAcquired(Lock l) {
        String s = l.toString();
        return s.contains("Locked by thread");
    }

    private void pushDeltaFromRoot(IntervalNode<T> node2) {
        if (node2 != null) {
            long packedOffsets = ((IntervalNode)node2).cachedDeltaUpToRoot;
            if (IntervalNode.allDeltasUpAreNull(packedOffsets) && node2.isValid() && IntervalNode.modCount(packedOffsets) == this.modCount) {
                return;
            }
            this.pushDeltaFromRoot((IntervalNode<T>)node2.getParent());
            this.pushDelta(node2);
        }
    }

    @NotNull
    protected abstract IntervalNode<T> createNewNode(@NotNull T var1, int var2, int var3, boolean var4, boolean var5, int var6);

    protected abstract IntervalNode<T> lookupNode(@NotNull T var1);

    protected abstract void setNode(@NotNull T var1, IntervalNode<T> var2);

    private int compareNodes(@NotNull IntervalNode<T> i1, int delta1, @NotNull IntervalNode<T> i2, int delta2, @NotNull List<IntervalNode<T>> invalid) {
        int start2;
        int start1;
        if (i1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i1", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "compareNodes"));
        }
        if (i2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i2", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "compareNodes"));
        }
        if (invalid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalid", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "compareNodes"));
        }
        if (!i2.hasAliveKey(false)) {
            invalid.add(i2);
        }
        if ((start1 = i1.intervalStart() + delta1) != (start2 = i2.intervalStart() + delta2)) {
            return start1 - start2;
        }
        return this.compareEqualStartIntervals(i1, i2);
    }

    protected IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    IntervalNode<T> findOrInsert(@NotNull IntervalNode<T> node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "findOrInsert"));
        }
        this.assertUnderWriteLock();
        node2.setRed();
        node2.setParent(null);
        node2.setValid(true);
        node2.maxEnd = 0;
        node2.clearDelta();
        node2.setLeft(null);
        node2.setRight(null);
        SmartList<IntervalNode<T>> gced = new SmartList<IntervalNode<T>>();
        if (this.root == null) {
            this.root = node2;
        } else {
            RedBlackTree.Node current = this.getRoot();
            while (true) {
                this.pushDelta((IntervalNode<T>)current);
                int compResult = this.compareNodes(node2, 0, (IntervalNode<T>)current, 0, (List<IntervalNode<T>>)gced);
                if (compResult == 0) {
                    return current;
                }
                if (compResult < 0) {
                    if (current.getLeft() == null) {
                        current.setLeft(node2);
                        break;
                    }
                    current = current.getLeft();
                    continue;
                }
                if (current.getRight() == null) {
                    current.setRight(node2);
                    break;
                }
                current = current.getRight();
            }
            node2.setParent(current);
        }
        ((IntervalNode)node2).setCachedValues(0, true, this.modCount);
        this.correctMaxUp(node2);
        this.onInsertNode();
        this.keySize += node2.intervals.size();
        this.insertCase1(node2);
        ((IntervalNode)node2).setAttachedToTree(true);
        this.verifyProperties();
        this.deleteNodes(gced);
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodes(@NotNull List<IntervalNode<T>> collectedAway) {
        if (collectedAway == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedAway", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "deleteNodes"));
        }
        if (collectedAway.isEmpty()) {
            return;
        }
        try {
            this.l.writeLock().lock();
            for (IntervalNode<T> node2 : collectedAway) {
                this.removeNode(node2);
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntervalNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "addInterval"));
        }
        try {
            this.l.writeLock().lock();
            this.checkMax(true);
            this.processReferenceQueue();
            ++this.modCount;
            IntervalNode<T> newNode = this.createNewNode(interval, start, end, greedyToLeft, greedyToRight, layer);
            IntervalNode<T> insertedNode = this.findOrInsert(newNode);
            if (insertedNode == newNode) {
                this.setNode(interval, insertedNode);
            } else {
                insertedNode.addInterval(interval);
            }
            this.checkMax(true);
            this.checkBelongsToTheTree(interval, true);
            IntervalNode<T> intervalNode = insertedNode;
            return intervalNode;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    boolean checkMax(boolean assertInvalid) {
        return VERIFY && this.doCheckMax(assertInvalid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckMax(boolean assertInvalid) {
        try {
            this.l.readLock().lock();
            AtomicBoolean allValid = new AtomicBoolean(true);
            int[] keyCounter = new int[1];
            int[] nodeCounter = new int[1];
            TLongHashSet ids = new TLongHashSet(this.keySize);
            this.checkMax(this.getRoot(), 0, assertInvalid, allValid, keyCounter, nodeCounter, ids, true);
            if (assertInvalid) {
                assert (this.nodeSize() == nodeCounter[0]) : "node size: " + this.nodeSize() + "; actual: " + nodeCounter[0];
                assert (this.keySize == keyCounter[0]) : "key size: " + this.keySize + "; actual: " + keyCounter[0];
                assert (this.keySize >= this.nodeSize()) : this.keySize + "; " + this.nodeSize();
            }
            boolean bl = allValid.get();
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private IntTrinity checkMax(IntervalNode<T> root, int deltaUpToRootExclusive, boolean assertInvalid, AtomicBoolean allValid, int[] keyCounter, int[] nodeCounter, TLongHashSet ids, boolean allDeltasUpAreNull) {
        if (root == null) {
            return new IntTrinity(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        long packedOffsets = ((IntervalNode)root).cachedDeltaUpToRoot;
        if (IntervalNode.modCount(packedOffsets) == this.modCount) {
            assert (IntervalNode.allDeltasUpAreNull(packedOffsets) == (root.delta == 0 && allDeltasUpAreNull));
            assert (IntervalNode.deltaUpToRoot(packedOffsets) == root.delta + deltaUpToRootExclusive);
        }
        MutableInterval liveInterval = null;
        for (int i = root.intervals.size() - 1; i >= 0; --i) {
            MutableInterval t = (MutableInterval)root.intervals.get(i).get();
            if (t == null) continue;
            liveInterval = t;
            this.checkBelongsToTheTree(t, false);
            boolean added = ids.add(((RangeMarkerImpl)t).getId());
            assert (added) : t;
        }
        if (assertInvalid && liveInterval != null) {
            this.checkBelongsToTheTree(liveInterval, true);
        }
        keyCounter[0] = keyCounter[0] + root.intervals.size();
        nodeCounter[0] = nodeCounter[0] + 1;
        int delta = deltaUpToRootExclusive + (root.isValid() ? root.delta : 0);
        IntTrinity l = this.checkMax((IntervalNode<T>)root.getLeft(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int minLeftStart = l.first;
        int maxLeftStart = l.second;
        int maxLeftEnd = l.third;
        IntTrinity r = this.checkMax((IntervalNode<T>)root.getRight(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int maxRightEnd = r.third;
        int minRightStart = r.first;
        int maxRightStart = r.second;
        if (!root.isValid()) {
            allValid.set(false);
            if (assertInvalid) assert (false) : root;
            return new IntTrinity(Math.min(minLeftStart, minRightStart), Math.max(maxLeftStart, maxRightStart), Math.max(maxRightEnd, maxLeftEnd));
        }
        RedBlackTree.Node parent = root.getParent();
        if (parent != null && assertInvalid && root.hasAliveKey(false)) {
            int c = this.compareNodes(root, delta, (IntervalNode<T>)parent, delta - root.delta, (List<IntervalNode<T>>)new SmartList<IntervalNode<T>>());
            assert (c != 0);
            assert (c < 0 && ((IntervalNode)parent).getLeft() == root || c > 0 && ((IntervalNode)parent).getRight() == root);
        }
        assert (delta + root.maxEnd == Math.max(maxLeftEnd, Math.max(maxRightEnd, delta + root.intervalEnd())));
        int myStartOffset = delta + root.intervalStart();
        assert (maxLeftStart <= myStartOffset);
        assert (minRightStart >= myStartOffset);
        assert (myStartOffset >= 0);
        assert (minLeftStart == Integer.MAX_VALUE || minLeftStart <= myStartOffset);
        assert (maxRightStart == Integer.MIN_VALUE || maxRightStart >= myStartOffset);
        int minStart = Math.min(minLeftStart, myStartOffset);
        int maxStart = Math.max(myStartOffset, Math.max(maxLeftStart, maxRightStart));
        assert (minStart <= maxStart);
        return new IntTrinity(minStart, maxStart, root.maxEnd + delta);
    }

    @Override
    protected RedBlackTree.Node<T> maximumNode(RedBlackTree.Node<T> n) {
        RedBlackTree.Node root = (IntervalNode)n;
        this.pushDelta((IntervalNode<T>)root.getParent());
        this.pushDelta((IntervalNode<T>)root);
        while (root.getRight() != null) {
            root = root.getRight();
            this.pushDelta((IntervalNode<T>)root);
        }
        return root;
    }

    protected void checkBelongsToTheTree(T interval, boolean assertInvalid) {
        IntervalNode<T> root = this.lookupNode(interval);
        if (root == null) {
            return;
        }
        assert (root.getTree() == this) : root.getTree() + "; this: " + this;
        if (!VERIFY) {
            return;
        }
        if (assertInvalid) {
            assert (!root.intervals.isEmpty());
            boolean contains = false;
            for (int i = root.intervals.size() - 1; i >= 0; --i) {
                MutableInterval key = (MutableInterval)root.intervals.get(i).get();
                if (key == null) continue;
                contains |= key == interval;
                IntervalNode<MutableInterval> node2 = this.lookupNode(key);
                assert (node2 == root) : node2;
                assert (node2.getTree() == this) : node2;
            }
            assert (contains) : root.intervals + "; " + interval;
        }
        RedBlackTree.Node e = root;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInterval(@NotNull T interval) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "removeInterval"));
        }
        if (!interval.isValid()) {
            return false;
        }
        try {
            this.l.writeLock().lock();
            ++this.modCount;
            if (!interval.isValid()) {
                boolean bl = false;
                return bl;
            }
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
            this.processReferenceQueue();
            IntervalNode<T> node2 = this.lookupNode(interval);
            if (node2 == null) {
                boolean bl = false;
                return bl;
            }
            this.reportInvalidation(interval, "Explicit Dispose");
            ((IntervalNode)node2).removeInterval(interval);
            this.setNode(interval, null);
            this.checkMax(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    void removeNode(@NotNull IntervalNode<T> node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "removeNode"));
        }
        this.deleteNode((RedBlackTree.Node<T>)node2);
        RedBlackTree.Node parent = node2.getParent();
        this.correctMaxUp((IntervalNode<T>)parent);
    }

    @Override
    protected void deleteNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "deleteNode"));
        }
        this.assertUnderWriteLock();
        IntervalNode node2 = (IntervalNode)n;
        this.pushDeltaFromRoot(node2);
        this.assertAllDeltasAreNull(node2);
        super.deleteNode(n);
        this.keySize -= node2.intervals.size();
        assert (this.keySize >= 0) : this.keySize;
        node2.setAttachedToTree(false);
    }

    @Override
    public int size() {
        return this.keySize;
    }

    boolean pushDelta(IntervalNode<T> root) {
        if (root == null || !root.isValid()) {
            return true;
        }
        RedBlackTree.Node parent = root.getParent();
        this.assertAllDeltasAreNull((IntervalNode<T>)parent);
        int delta = root.delta;
        ((IntervalNode)root).setCachedValues(0, true, 0);
        if (delta != 0) {
            root.setIntervalStart(root.intervalStart() + delta);
            root.setIntervalEnd(root.intervalEnd() + delta);
            root.maxEnd += delta;
            root.delta = 0;
            return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
        }
        ((IntervalNode)root).setCachedValues(0, true, this.modCount);
        return true;
    }

    private boolean incDelta(IntervalNode<T> root, int delta) {
        if (root == null) {
            return true;
        }
        if (root.isValid()) {
            int newDelta = root.changeDelta(delta);
            return newDelta == 0;
        }
        return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
    }

    @Override
    protected IntervalNode<T> swapWithMaxPred(RedBlackTree.Node<T> root, RedBlackTree.Node<T> maxPred) {
        this.checkMax(false);
        IntervalNode a = (IntervalNode)root;
        IntervalNode d = (IntervalNode)maxPred;
        boolean acolor = a.isBlack();
        boolean dcolor = d.isBlack();
        assert (!a.isValid() || a.delta == 0) : a.delta;
        for (RedBlackTree.Node n = a.getLeft(); n != null; n = ((IntervalNode)n).getRight()) {
            assert (!((IntervalNode)n).isValid() || ((IntervalNode)n).delta == 0) : ((IntervalNode)n).delta;
        }
        this.swapNodes(a, d);
        a.setValid(false);
        a.setColor(dcolor);
        d.setColor(acolor);
        this.correctMaxUp(a);
        this.checkMax(false);
        assert (a.delta == 0) : a.delta;
        assert (d.delta == 0) : d.delta;
        return a;
    }

    private void swapNodes(IntervalNode<T> n1, IntervalNode<T> n2) {
        RedBlackTree.Node l1 = n1.getLeft();
        RedBlackTree.Node r1 = n1.getRight();
        IntervalNode<T> p1 = n1.getParent();
        IntervalNode<T> l2 = n2.getLeft();
        IntervalNode<T> r2 = n2.getRight();
        RedBlackTree.Node p2 = n2.getParent();
        if (p1 != null) {
            if (p1.getLeft() == n1) {
                p1.setLeft(n2);
            } else {
                p1.setRight(n2);
            }
        } else {
            this.root = n2;
        }
        if (p2 != null) {
            if (((IntervalNode)p2).getLeft() == n2) {
                p2.setLeft(p2 == n1 ? l2 : n1);
            } else {
                p2.setRight(p2 == n1 ? r2 : n1);
            }
        } else {
            this.root = n1;
        }
        n1.setParent(p2 == n1 ? n2 : p2);
        n2.setParent(p1);
        n1.setLeft(l2);
        n2.setLeft(l1 == n2 ? n1 : l1);
        if (l1 != null) {
            l1.setParent(n2 == l1 ? p1 : n2);
        }
        if (r1 != null) {
            r1.setParent(n2);
        }
        n1.setRight(r2);
        n2.setRight(r1);
        if (l2 != null) {
            l2.setParent(n1);
        }
        if (r2 != null) {
            r2.setParent(n1);
        }
    }

    private int maxEndOf(IntervalNode<T> node2, int deltaUpToRootExclusive) {
        if (node2 == null) {
            return 0;
        }
        if (node2.isValid()) {
            return node2.maxEnd + node2.delta + deltaUpToRootExclusive;
        }
        return Math.max(this.maxEndOf((IntervalNode<T>)node2.getLeft(), deltaUpToRootExclusive), this.maxEndOf((IntervalNode<T>)node2.getRight(), deltaUpToRootExclusive));
    }

    void correctMax(@NotNull IntervalNode<T> node2, int deltaUpToRoot) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "correctMax"));
        }
        if (!node2.isValid()) {
            return;
        }
        int realMax = Math.max(Math.max(this.maxEndOf((IntervalNode<T>)node2.getLeft(), deltaUpToRoot), this.maxEndOf((IntervalNode<T>)node2.getRight(), deltaUpToRoot)), deltaUpToRoot + node2.intervalEnd());
        node2.maxEnd = realMax - deltaUpToRoot;
    }

    private void correctMaxUp(IntervalNode<T> node2) {
        int delta;
        int n = delta = node2 == null ? 0 : node2.computeDeltaUpToRoot();
        assert (delta == 0) : delta;
        while (node2 != null) {
            if (node2.isValid()) {
                int d = node2.delta;
                this.correctMax((IntervalNode<T>)node2, delta);
                delta -= d;
            }
            node2 = node2.getParent();
        }
        assert (delta == 0) : delta;
    }

    @Override
    protected void rotateRight(RedBlackTree.Node<T> n) {
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        super.rotateRight(node1);
        if (node3 != null) {
            this.correctMax((IntervalNode<T>)node3, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node2, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void rotateLeft(RedBlackTree.Node<T> n) {
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        this.checkMax(false);
        super.rotateLeft(node1);
        if (node2 != null) {
            this.correctMax((IntervalNode<T>)node2, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node3, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void replaceNode(@NotNull RedBlackTree.Node<T> node2, RedBlackTree.Node<T> child) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/editor/impl/IntervalTreeImpl", "replaceNode"));
        }
        IntervalNode myNode = (IntervalNode)node2;
        this.pushDelta(myNode);
        this.pushDelta((IntervalNode)child);
        super.replaceNode(node2, child);
        if (child != null && myNode.isValid()) {
            ((IntervalNode)child).changeDelta(myNode.delta);
        }
    }

    private void assertAllDeltasAreNull(IntervalNode<T> node2) {
        if (node2 == null) {
            return;
        }
        if (!node2.isValid()) {
            return;
        }
        assert (node2.delta == 0);
        long packedOffsets = ((IntervalNode)node2).cachedDeltaUpToRoot;
        assert (IntervalNode.modCount(packedOffsets) != this.modCount || IntervalNode.allDeltasUpAreNull(packedOffsets));
    }

    private void processReferenceQueue() {
        int dead = 0;
        while (this.myReferenceQueue.poll() != null) {
            ++dead;
        }
        this.deadReferenceCount += dead;
        if (this.deadReferenceCount > Math.max(1, this.size() / 3)) {
            this.purgeDeadNodes();
            this.deadReferenceCount = 0;
        }
    }

    private void purgeDeadNodes() {
        this.assertUnderWriteLock();
        SmartList<IntervalNode<T>> gced = new SmartList<IntervalNode<T>>();
        this.collectGced(this.getRoot(), gced);
        this.deleteNodes(gced);
        this.checkMax(true);
    }

    private void collectGced(IntervalNode<T> root, List<IntervalNode<T>> gced) {
        if (root == null) {
            return;
        }
        if (!root.hasAliveKey(true)) {
            gced.add(root);
        }
        this.collectGced((IntervalNode<T>)root.getLeft(), gced);
        this.collectGced((IntervalNode<T>)root.getRight(), gced);
    }

    void reportInvalidation(T markerEx, @NonNls Object reason) {
    }

    private static class IntervalTreeGuide<T extends MutableInterval>
    implements WalkingState.TreeGuide<IntervalNode<T>> {
        private IntervalTreeGuide() {
        }

        @Override
        public IntervalNode<T> getNextSibling(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide", "getNextSibling"));
            }
            RedBlackTree.Node parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return ((IntervalNode)parent).getLeft() == element ? ((IntervalNode)parent).getRight() : null;
        }

        @Override
        public IntervalNode<T> getPrevSibling(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide", "getPrevSibling"));
            }
            RedBlackTree.Node parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return ((IntervalNode)parent).getRight() == element ? ((IntervalNode)parent).getLeft() : null;
        }

        @Override
        public IntervalNode<T> getFirstChild(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide", "getFirstChild"));
            }
            RedBlackTree.Node left = element.getLeft();
            return left == null ? element.getRight() : left;
        }

        @Override
        public IntervalNode<T> getParent(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide", "getParent"));
            }
            return element.getParent();
        }
    }

    private static class IntTrinity {
        private final int first;
        private final int second;
        private final int third;

        private IntTrinity(int first, int second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }
    }

    static class IntervalNode<E extends MutableInterval>
    extends RedBlackTree.Node<E>
    implements MutableInterval {
        private volatile int myStart;
        private volatile int myEnd;
        protected final List<Getter<E>> intervals;
        int maxEnd;
        protected int delta;
        private volatile long cachedDeltaUpToRoot;
        private final IntervalTreeImpl<E> myIntervalTree;
        private static final AtomicFieldUpdater<IntervalNode, Long> cachedDeltaUpdater = AtomicFieldUpdater.forLongFieldIn(IntervalNode.class);

        public IntervalNode(@NotNull IntervalTreeImpl<E> intervalTree, @NotNull E key, int start, int end) {
            if (intervalTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intervalTree", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode", "<init>"));
            }
            this.myIntervalTree = intervalTree;
            this.myStart = start;
            this.myEnd = end;
            this.intervals = new SmartList<Getter<Getter<E>>>(this.createGetter(key));
            this.setValid(true);
        }

        @Override
        public IntervalNode<E> getLeft() {
            return (IntervalNode)this.left;
        }

        @Override
        public IntervalNode<E> getRight() {
            return (IntervalNode)this.right;
        }

        @Override
        public IntervalNode<E> getParent() {
            return (IntervalNode)this.parent;
        }

        public boolean processAliveKeys(@NotNull Processor<? super E> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode", "processAliveKeys"));
            }
            for (int i = 0; i < this.intervals.size(); ++i) {
                Getter<E> interval = this.intervals.get(i);
                MutableInterval key = (MutableInterval)interval.get();
                if (key == null || processor.process(key)) continue;
                return false;
            }
            return true;
        }

        public boolean hasAliveKey(boolean purgeDead) {
            boolean hasAliveInterval = false;
            for (int i = this.intervals.size() - 1; i >= 0; --i) {
                Getter<E> interval = this.intervals.get(i);
                if (interval.get() != null) {
                    hasAliveInterval = true;
                    if (!purgeDead) break;
                    continue;
                }
                if (!purgeDead) continue;
                ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
                this.removeIntervalInternal(i);
            }
            return hasAliveInterval;
        }

        private boolean removeInterval(@NotNull E key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode", "removeInterval"));
            }
            this.myIntervalTree.checkBelongsToTheTree(key, true);
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            for (int i = this.intervals.size() - 1; i >= 0; --i) {
                Getter<E> interval = this.intervals.get(i);
                MutableInterval t = (MutableInterval)interval.get();
                if (t != key) continue;
                this.removeIntervalInternal(i);
                if (this.intervals.isEmpty()) {
                    this.myIntervalTree.removeNode(this);
                    return true;
                }
                return false;
            }
            assert (false) : "interval not found: " + key + "; " + this.intervals + "; isValid=" + key.isValid();
            return false;
        }

        private boolean isAttachedToTree() {
            return this.isFlagSet((byte)2);
        }

        private void setAttachedToTree(boolean attached) {
            this.setFlag((byte)2, attached);
        }

        void removeIntervalInternal(int i) {
            this.intervals.remove(i);
            if (this.isAttachedToTree()) {
                assert (((IntervalTreeImpl)this.myIntervalTree).keySize > 0) : IntervalTreeImpl.access$100(this.myIntervalTree);
                ((IntervalTreeImpl)this.myIntervalTree).keySize--;
            }
        }

        void addInterval(@NotNull E interval) {
            if (interval == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode", "addInterval"));
            }
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            this.intervals.add(this.createGetter(interval));
            if (this.isAttachedToTree()) {
                ((IntervalTreeImpl)this.myIntervalTree).keySize++;
                this.myIntervalTree.setNode(interval, this);
            }
        }

        protected Getter<E> createGetter(@NotNull E interval) {
            if (interval == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode", "createGetter"));
            }
            return new WeakReferencedGetter(interval, ((IntervalTreeImpl)this.myIntervalTree).myReferenceQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int computeDeltaUpToRoot() {
            block7: while (this.isValid()) {
                int treeModCount = this.myIntervalTree.modCount;
                long packedOffsets = this.cachedDeltaUpToRoot;
                if (IntervalNode.modCount(packedOffsets) == treeModCount) {
                    return IntervalNode.deltaUpToRoot(packedOffsets);
                }
                try {
                    boolean allDeltasAreNull;
                    int deltaUp;
                    block17: {
                        this.myIntervalTree.l.readLock().lock();
                        RedBlackTree.Node node2 = this;
                        IntervalNode<E> treeRoot = this.myIntervalTree.getRoot();
                        if (treeRoot == null) {
                            int n = this.delta;
                            return n;
                        }
                        deltaUp = 0;
                        allDeltasAreNull = true;
                        int height = 0;
                        long path = 0L;
                        while (node2 != treeRoot) {
                            long nodePackedOffsets = ((IntervalNode)node2).cachedDeltaUpToRoot;
                            if (((IntervalNode)node2).isValid() && IntervalNode.modCount(nodePackedOffsets) == treeModCount) {
                                deltaUp = IntervalNode.deltaUpToRoot(nodePackedOffsets) - ((IntervalNode)node2).delta;
                                allDeltasAreNull = IntervalNode.allDeltasUpAreNull(nodePackedOffsets);
                                break;
                            }
                            RedBlackTree.Node parent = ((IntervalNode)node2).getParent();
                            if (parent == null) {
                                int n = deltaUp;
                                return n;
                            }
                            path = path << 1 | (long)(((IntervalNode)parent).getLeft() == node2 ? 0 : 1);
                            node2 = parent;
                            ++height;
                        }
                        assert (height < 63) : height;
                        do {
                            int nodeDelta;
                            if (((IntervalNode)node2).isValid() && !((IntervalNode)node2).tryToSetCachedValues(deltaUp += (nodeDelta = ((IntervalNode)node2).delta), allDeltasAreNull &= nodeDelta == 0, treeModCount)) continue block7;
                            if (node2 == this) break block17;
                            node2 = (path & 1L) == 0L ? ((IntervalNode)node2).getLeft() : ((IntervalNode)node2).getRight();
                            path >>= 1;
                        } while (node2 != null);
                        int n = deltaUp;
                        return n;
                    }
                    assert (deltaUp == 0 || !allDeltasAreNull);
                    int n = deltaUp;
                    return n;
                }
                finally {
                    this.myIntervalTree.l.readLock().unlock();
                    continue;
                }
                break;
            }
            return 0;
        }

        int changeDelta(int change) {
            if (change != 0) {
                this.setCachedValues(0, false, 0);
                return this.delta += change;
            }
            return this.delta;
        }

        void clearDelta() {
            if (this.delta != 0) {
                this.setCachedValues(0, false, 0);
                this.delta = 0;
            }
        }

        public int setIntervalStart(int start) {
            this.myStart = start;
            return this.myStart;
        }

        public int setIntervalEnd(int end) {
            this.myEnd = end;
            return this.myEnd;
        }

        @Override
        public boolean isValid() {
            return this.isFlagSet((byte)4);
        }

        public boolean setValid(boolean value) {
            this.setFlag((byte)4, value);
            return value;
        }

        public int intervalStart() {
            return this.myStart;
        }

        public int intervalEnd() {
            return this.myEnd;
        }

        public IntervalTreeImpl<E> getTree() {
            return this.myIntervalTree;
        }

        private void setCachedValues(int deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            this.cachedDeltaUpToRoot = IntervalNode.packValues(deltaUpToRoot, allDeltaUpToRootAreNull, modCount);
        }

        private static long packValues(long deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            return deltaUpToRoot << 33 | (allDeltaUpToRootAreNull ? 0x100000000L : 0L) | (long)modCount;
        }

        private boolean tryToSetCachedValues(int deltaUpToRoot, boolean allDeltasUpAreNull, int treeModCount) {
            if (this.myIntervalTree.modCount != treeModCount) {
                return false;
            }
            long newValue = IntervalNode.packValues(deltaUpToRoot, allDeltasUpAreNull, treeModCount);
            long oldValue = this.cachedDeltaUpToRoot;
            return cachedDeltaUpdater.compareAndSetLong(this, oldValue, newValue);
        }

        private static boolean allDeltasUpAreNull(long packedOffsets) {
            return (packedOffsets >> 32 & 1L) != 0L;
        }

        private static int modCount(long packedOffsets) {
            return (int)packedOffsets;
        }

        private static int deltaUpToRoot(long packedOffsets) {
            return (int)(packedOffsets >> 33);
        }

        @NonNls
        public String toString() {
            return "Node: " + this.intervals;
        }

        private static class WeakReferencedGetter<T>
        extends WeakReference<T>
        implements Getter<T> {
            private WeakReferencedGetter(T referent, ReferenceQueue<? super T> q) {
                super(referent, q);
            }

            @NonNls
            public String toString() {
                return "Ref: " + this.get();
            }
        }
    }
}

