/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileContextProvider {
    public static final ExtensionPointName<FileContextProvider> EP_NAME = new ExtensionPointName("com.intellij.fileContextProvider");

    @Nullable
    public static FileContextProvider getProvider(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/FileContextProvider", "getProvider"));
        }
        for (FileContextProvider provider : Extensions.getExtensions(EP_NAME, (AreaInstance)file.getProject())) {
            if (!provider.isAvailable(file)) continue;
            return provider;
        }
        return null;
    }

    protected abstract boolean isAvailable(PsiFile var1);

    @NotNull
    public abstract Collection<PsiFileSystemItem> getContextFolders(PsiFile var1);

    @Nullable
    public abstract PsiFile getContextFile(PsiFile var1);
}

