/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.ref.Reference;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiParameterImpl");
    private volatile Reference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        this(stub, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub, @NotNull IStubElementType type2) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        super(stub, type2);
        this.myCachedType = null;
    }

    public PsiParameterImpl(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        super(node2);
        this.myCachedType = null;
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiType type2 = LambdaUtil.getFunctionalInterfaceType(lambdaExpression, true);
            if (type2 == null) {
                type2 = LambdaUtil.getFunctionalInterfaceType(lambdaExpression, false);
            }
            if ((type2 = FunctionalInterfaceParameterizationUtil.getGroundTargetType(type2, lambdaExpression)) instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type2).getConjuncts()) {
                    PsiType lambdaParameterFromType = PsiParameterImpl.getLambdaParameterFromType(parameterIndex, lambdaExpression, conjunct);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = PsiParameterImpl.getLambdaParameterFromType(parameterIndex, lambdaExpression, type2);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    private static PsiType getLambdaParameterFromType(int parameterIndex, PsiLambdaExpression lambdaExpression, PsiType conjunct) {
        PsiType psiType;
        PsiParameter[] parameters2;
        PsiMethod method;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(conjunct);
        if (resolveResult != null && (method = LambdaUtil.getFunctionalInterfaceMethod(conjunct)) != null && parameterIndex < (parameters2 = method.getParameterList().getParameters()).length && !LambdaUtil.dependsOnTypeParams(psiType = LambdaUtil.getSubstitutor(method, resolveResult).substitute(parameters2[parameterIndex].getType()), conjunct, lambdaExpression, new PsiTypeParameter[0])) {
            return psiType;
        }
        return null;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)super.clone();
        clone.myCachedType = null;
        return clone;
    }

    @Override
    @NotNull
    public final String getName() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getName"));
            }
            return string;
        }
        String string = this.getParameterIdentifier().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getName"));
        }
        return string;
    }

    @Override
    public final PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiParameterImpl", "setName"));
        }
        if (this instanceof PsiReceiverParameter) {
            throw new IncorrectOperationException("Cannot rename receiver parameter");
        }
        PsiImplUtil.setName(this.getParameterIdentifier(), name);
        return this;
    }

    @Override
    public final PsiIdentifier getNameIdentifier() {
        return PsiTreeUtil.getChildOfType(this, PsiIdentifier.class);
    }

    @NotNull
    private PsiElement getParameterIdentifier() {
        PsiJavaToken identifier = (PsiJavaToken)PsiTreeUtil.getChildOfAnyType(this, PsiIdentifier.class, PsiKeyword.class);
        assert (identifier != null) : this.getClass() + ":" + this.getText();
        PsiJavaToken psiJavaToken = identifier;
        if (psiJavaToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getParameterIdentifier"));
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getNode"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            PsiType psiType;
            PsiType type2 = SoftReference.dereference(this.myCachedType);
            if (type2 != null) {
                PsiType psiType2 = type2;
                if (psiType2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
                }
                return psiType2;
            }
            String typeText = TypeInfo.createTypeText(stub.getType(true));
            assert (typeText != null) : stub;
            try {
                type2 = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
                this.myCachedType = new SoftReference<PsiType>(type2);
                psiType = type2;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
                if (null == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
                }
                return null;
            }
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            assert (this.isLambdaParameter()) : this;
            PsiType psiType = PsiParameterImpl.getLambdaParameterType(this);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
            }
            return psiType;
        }
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, this.getParameterIdentifier());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
        }
        return psiType;
    }

    private boolean isLambdaParameter() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        PsiModifierList psiModifierList = modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiParameterImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiParameterImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameter(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            PsiParameterImpl psiParameterImpl = this;
            if (psiParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiParameterImpl;
        }
        if (parent instanceof PsiParameterList) {
            PsiElement psiElement = parent.getParent();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        if (parent instanceof PsiForeachStatement) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        if (parent instanceof PsiCatchSection) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        PsiElement[] children = parent.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals(this)) continue;
                for (int j = i + 1; j < children.length; ++j) {
                    if (!(children[j] instanceof PsiCodeBlock)) continue;
                    PsiElement psiElement = children[j];
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
                    }
                    return psiElement;
                }
                break;
            }
        }
        LOG.error("Code block not found among parameter' (" + this + ") parent' (" + parent + ") children: " + Arrays.asList(children));
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
        }
        return null;
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            return stub.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull(typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiParameterImpl.createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiParameter[] originalParameters;
        int index2;
        PsiElement originalMethod;
        PsiElement gParent;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod && (originalMethod = gParent.getOriginalElement()) instanceof PsiMethod && (index2 = ((PsiParameterList)parent).getParameterIndex(this)) < (originalParameters = ((PsiMethod)originalMethod).getParameterList().getParameters()).length) {
            return originalParameters[index2];
        }
        return this;
    }
}

