/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.JetControlFlowProcessor;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class PseudocodeUtil {
    @NotNull
    public static Pseudocode generatePseudocode(@NotNull JetDeclaration declaration, final @NotNull BindingContext bindingContext) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "generatePseudocode"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "generatePseudocode"));
        }
        BindingTrace mockTrace = new BindingTrace(){

            @Override
            @NotNull
            public BindingContext getBindingContext() {
                BindingContext bindingContext2 = bindingContext;
                if (bindingContext2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "getBindingContext"));
                }
                return bindingContext2;
            }

            @Override
            public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            }

            @Override
            public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return bindingContext.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = bindingContext.getKeys(slice);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "getKeys"));
                }
                return collection;
            }

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "report"));
                }
            }
        };
        Pseudocode pseudocode = new JetControlFlowProcessor(mockTrace).generatePseudocode(declaration);
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "generatePseudocode"));
        }
        return pseudocode;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull Instruction instruction, boolean onlyReference, @NotNull BindingContext bindingContext) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "extractVariableDescriptorIfAny"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "extractVariableDescriptorIfAny"));
        }
        JetElement element = null;
        if (instruction instanceof ReadValueInstruction) {
            element = ((ReadValueInstruction)instruction).getElement();
        } else if (instruction instanceof WriteValueInstruction) {
            element = ((WriteValueInstruction)instruction).getlValue();
        } else if (instruction instanceof VariableDeclarationInstruction) {
            element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
        }
        return BindingContextUtils.extractVariableDescriptorIfAny(bindingContext, element, onlyReference);
    }

    public static boolean isThisOrNoDispatchReceiver(@NotNull AccessValueInstruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "isThisOrNoDispatchReceiver"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "isThisOrNoDispatchReceiver"));
        }
        if (instruction.getReceiverValues().isEmpty()) {
            return true;
        }
        AccessTarget accessTarget = instruction.getTarget();
        if (accessTarget instanceof AccessTarget.BlackBox) {
            return false;
        }
        assert (accessTarget instanceof AccessTarget.Call) : "AccessTarget.Declaration has no receivers and it's not BlackBox, so it should be Call";
        ResolvedCall<?> accessResolvedCall = ((AccessTarget.Call)accessTarget).getResolvedCall();
        return PseudocodeUtil.isThisOrNoDispatchReceiver(accessResolvedCall, bindingContext);
    }

    public static boolean isThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> resolvedCall, @NotNull BindingContext bindingContext) {
        JetExpression expression;
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "isThisOrNoDispatchReceiver"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "isThisOrNoDispatchReceiver"));
        }
        ReceiverParameterDescriptor dispatchReceiverParameter = resolvedCall.getResultingDescriptor().getDispatchReceiverParameter();
        ReceiverValue dispatchReceiverValue = resolvedCall.getDispatchReceiver();
        if (dispatchReceiverParameter == null || !dispatchReceiverValue.exists()) {
            return true;
        }
        DeclarationDescriptor classDescriptor = null;
        if (dispatchReceiverValue instanceof ThisReceiver) {
            classDescriptor = ((ThisReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (dispatchReceiverValue instanceof ExpressionReceiver && (expression = JetPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof JetThisExpression) {
            JetThisExpression thisExpression = (JetThisExpression)expression;
            classDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
        }
        return dispatchReceiverParameter.getContainingDeclaration() == classDescriptor;
    }
}

