/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputMessageUtil {
    @NotNull
    public static String renderException(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "renderException"));
        }
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "renderException"));
        }
        return string;
    }

    @NotNull
    public static String formatOutputMessage(Collection<File> sourceFiles, File outputFile) {
        String string = "Output:\n" + outputFile.getPath() + "\n" + "Sources:" + "\n" + StringUtil.join(sourceFiles, "\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "formatOutputMessage"));
        }
        return string;
    }

    @Nullable
    public static Output parseOutputMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "parseOutputMessage"));
        }
        String[] strings2 = message.split("\n");
        if (strings2.length <= 2) {
            return null;
        }
        if (!"Output:".equals(strings2[0])) {
            return null;
        }
        if ("Sources:".equals(strings2[1])) {
            return new Output(OutputMessageUtil.parseSourceFiles(strings2, 2), null);
        }
        File outputFile = new File(strings2[1]);
        if (!"Sources:".equals(strings2[2])) {
            return null;
        }
        return new Output(OutputMessageUtil.parseSourceFiles(strings2, 3), outputFile);
    }

    private static Collection<File> parseSourceFiles(String[] strings2, int start) {
        ArrayList<File> sourceFiles = ContainerUtil.newArrayList();
        for (int i = start; i < strings2.length; ++i) {
            sourceFiles.add(new File(strings2[i]));
        }
        return sourceFiles;
    }

    public static class Output {
        @NotNull
        public final Collection<File> sourceFiles;
        @Nullable
        public final File outputFile;

        public Output(@NotNull Collection<File> sourceFiles, @Nullable File outputFile) {
            if (sourceFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil$Output", "<init>"));
            }
            this.sourceFiles = sourceFiles;
            this.outputFile = outputFile;
        }
    }
}

