/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class ReplFromTerminal {
    private ReplInterpreter replInterpreter;
    private Throwable replInitializationFailed;
    private final Object waitRepl;
    private final ConsoleReader consoleReader;

    public ReplFromTerminal(final @NotNull Disposable disposable, final @NotNull CompilerConfiguration compilerConfiguration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "<init>"));
        }
        if (compilerConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerConfiguration", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "<init>"));
        }
        this.waitRepl = new Object();
        new Thread("initialize-repl"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReplFromTerminal.this.replInterpreter = new ReplInterpreter(disposable, compilerConfiguration);
                }
                catch (Throwable e) {
                    ReplFromTerminal.this.replInitializationFailed = e;
                }
                Object object = ReplFromTerminal.this.waitRepl;
                synchronized (object) {
                    ReplFromTerminal.this.waitRepl.notifyAll();
                }
            }
        }.start();
        try {
            this.consoleReader = new ConsoleReader("kotlin", System.in, System.out, null);
            this.consoleReader.setHistoryEnabled(true);
            this.consoleReader.setExpandEvents(false);
            this.consoleReader.setHistory(new FileHistory(new File(new File(System.getProperty("user.home")), ".kotlin_history")));
        }
        catch (Exception e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    private ReplInterpreter getReplInterpreter() {
        if (this.replInterpreter != null) {
            return this.replInterpreter;
        }
        Object object = this.waitRepl;
        synchronized (object) {
            while (this.replInterpreter == null && this.replInitializationFailed == null) {
                try {
                    this.waitRepl.wait();
                }
                catch (Throwable e) {
                    throw UtilsPackage.rethrow(e);
                }
            }
            if (this.replInterpreter != null) {
                return this.replInterpreter;
            }
            throw UtilsPackage.rethrow(this.replInitializationFailed);
        }
    }

    private void doRun() {
        try {
            System.out.println("Welcome to Kotlin version 0.11.91.4 (JRE " + System.getProperty("java.runtime.version") + ")");
            System.out.println("Type :help for help, :quit for quit");
            WhatNextAfterOneLine next = WhatNextAfterOneLine.READ_LINE;
            while ((next = this.one(next)) != WhatNextAfterOneLine.QUIT) {
            }
        }
        catch (Exception e) {
            throw UtilsPackage.rethrow(e);
        }
        finally {
            try {
                ((FileHistory)this.consoleReader.getHistory()).flush();
            }
            catch (Exception e) {
                System.err.println("failed to flush history: " + e);
            }
        }
    }

    @NotNull
    private WhatNextAfterOneLine one(@NotNull WhatNextAfterOneLine next) {
        block12: {
            String line;
            block11: {
                block10: {
                    WhatNextAfterOneLine whatNextAfterOneLine;
                    if (next == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
                    }
                    try {
                        line = this.consoleReader.readLine(next == WhatNextAfterOneLine.INCOMPLETE ? "... " : ">>> ");
                        if (line != null) break block10;
                        whatNextAfterOneLine = WhatNextAfterOneLine.QUIT;
                    }
                    catch (Exception e) {
                        throw UtilsPackage.rethrow(e);
                    }
                    if (whatNextAfterOneLine == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
                    }
                    return whatNextAfterOneLine;
                }
                if (!line.startsWith(":") || line.length() != 1 && line.charAt(1) == ':') break block11;
                boolean notQuit = this.oneCommand(line.substring(1));
                WhatNextAfterOneLine whatNextAfterOneLine = notQuit ? WhatNextAfterOneLine.READ_LINE : WhatNextAfterOneLine.QUIT;
                if (whatNextAfterOneLine == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
                }
                return whatNextAfterOneLine;
            }
            ReplInterpreter.LineResultType lineResultType = this.eval(line);
            if (lineResultType != ReplInterpreter.LineResultType.INCOMPLETE) break block12;
            WhatNextAfterOneLine whatNextAfterOneLine = WhatNextAfterOneLine.INCOMPLETE;
            if (whatNextAfterOneLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
            }
            return whatNextAfterOneLine;
        }
        WhatNextAfterOneLine whatNextAfterOneLine = WhatNextAfterOneLine.READ_LINE;
        if (whatNextAfterOneLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
        }
        return whatNextAfterOneLine;
    }

    @NotNull
    private ReplInterpreter.LineResultType eval(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "eval"));
        }
        ReplInterpreter.LineResult lineResult = this.getReplInterpreter().eval(line);
        if (lineResult.getType() == ReplInterpreter.LineResultType.SUCCESS) {
            if (!lineResult.isUnit()) {
                System.out.println(lineResult.getValue());
            }
        } else if (lineResult.getType() != ReplInterpreter.LineResultType.INCOMPLETE) {
            if (lineResult.getType() == ReplInterpreter.LineResultType.ERROR) {
                System.out.print(lineResult.getErrorText());
            } else {
                throw new IllegalStateException("unknown line result type: " + lineResult);
            }
        }
        ReplInterpreter.LineResultType lineResultType = lineResult.getType();
        if (lineResultType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "eval"));
        }
        return lineResultType;
    }

    private boolean oneCommand(@NotNull String command) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "oneCommand"));
        }
        List<String> split = ReplFromTerminal.splitCommand(command);
        if (split.size() >= 1 && command.equals("help")) {
            System.out.println("Available commands:");
            System.out.println(":help                   show this help");
            System.out.println(":quit                   exit the interpreter");
            System.out.println(":dump bytecode          dump classes to terminal");
            System.out.println(":load <file>            load script from specified file");
            return true;
        }
        if (split.size() >= 2 && split.get(0).equals("dump") && split.get(1).equals("bytecode")) {
            this.getReplInterpreter().dumpClasses(new PrintWriter(System.out));
            return true;
        }
        if (split.size() >= 1 && split.get(0).equals("quit")) {
            return false;
        }
        if (split.size() >= 2 && split.get(0).equals("load")) {
            String fileName = split.get(1);
            String scriptText = FileUtil.loadFile(new File(fileName));
            this.eval(scriptText);
            return true;
        }
        System.out.println("Unknown command");
        System.out.println("Type :help for help");
        return true;
    }

    private static List<String> splitCommand(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "splitCommand"));
        }
        return Arrays.asList(command.split(" "));
    }

    public static void run(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "run"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "run"));
        }
        new ReplFromTerminal(disposable, configuration).doRun();
    }

    private static enum WhatNextAfterOneLine {
        READ_LINE,
        INCOMPLETE,
        QUIT;

    }
}

