/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class CompareTo
extends IntrinsicMethod {
    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType2, @Nullable PsiElement element, @NotNull List<JetExpression> arguments2, @NotNull StackValue receiver) {
        JetExpression argument;
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (arguments2.size() == 1) {
            argument = arguments2.get(0);
        } else if (arguments2.size() == 2) {
            receiver = codegen.gen(arguments2.get(0));
            argument = arguments2.get(1);
        } else {
            throw new IllegalStateException("Invalid arguments to compareTo: " + arguments2);
        }
        Type type2 = AsmUtil.comparisonOperandType(receiver.type, codegen.expressionType(argument));
        receiver.put(type2, v);
        codegen.gen(argument, type2);
        if (type2 == Type.INT_TYPE) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(II)I", false);
        } else if (type2 == Type.LONG_TYPE) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(JJ)I", false);
        } else if (type2 == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else {
            throw new UnsupportedOperationException();
        }
        Type type3 = Type.INT_TYPE;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        return type3;
    }
}

