/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingPackage$sam$Function$75ae0dca;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.InferencePackage$CapturedTypeConstructor$6c84c44e;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeConstructorMismatch;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"c\u001e)I!+\u001a8eKJ,'o\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*YA-[1h]>\u001cH/[2t\u0015%\u0011XM\u001c3fe&twMC\u0002B]fTq\"Q'C\u0013\u001e+v*V*`\u0007\u0006cEj\u0015\u0006\t%\u0016tG-\u001a:fe*A!/\u001a8eKJ,'O\u0003\u0006D_2dWm\u0019;j_:TABU3t_24X\rZ\"bY2TqA]3t_24XMC\u0003dC2d7OC\u0003n_\u0012,GN\u0003\nhKR\fUJQ%H+>+6kX\"B\u00192\u001b&\u0002F\"M\u0003N\u001bViU0P%~\u001bV\tU!S\u0003R+EIC\bDY\u0006\u001c8\u000fR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b/\u001d,Go\u0011'B'N+5kX(S?N+\u0005+\u0011*B)\u0016#%\u0002\u0005#F\u00072\u000b%+\u0011+J\u001f:{f*Q'F\u0015MQU\r\u001e(b[\u0016$G)Z2mCJ\fG/[8o\u0015\r\u00018/\u001b\u0006\u0014O\u0016$H)R\"M\u0003J\u000bE+S(O?:\u000bU*\u0012\u0006\r\u000b2+U*\u0012(U?R+\u0005\f\u0016\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'NC\bhKR,E*R'F\u001dR{F+\u0012-U\u0015\rauj\u0012\u0006\u0007\u0019><w-\u001a:\u000b\u000f=\u0004XM\\1qS*QA-[1h]>\u001cH/[2\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'\u0002\u0002(B\u001b\u0016SQAT1nK\u0012TqaZ3u\u001d\u0006kUI\u0003\fS\u000b:#UIU0D\u0019\u0006\u001b6kX(S?>\u0013%*R\"U\u0015AQU\r^\"mCN\u001cxJ](cU\u0016\u001cGOC\rhKR\u0014VI\u0014#F%~\u001bE*Q*T?>\u0013vl\u0014\"K\u000b\u000e#&b\u0007*F\u001d\u0012+%kX\"M\u0003N\u001bvl\u0014*`\u001f\nSUi\u0011+`\u001d\u0006kUI\u0003\u0010hKR\u0014VI\u0014#F%~\u001bE*Q*T?>\u0013vl\u0014\"K\u000b\u000e#vLT!N\u000b*Q\"+\u0012(E\u000bJ{6i\u0014'M\u000b\u000e#\u0016j\u0014(`\u001f\u001a{F+\u0017)F'*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(\"H4fiJ+e\nR#S?\u000e{E\nT#D)&{ejX(G?RK\u0006+R*\u000b1I+e\nR#S?\u000e{ej\u0015+S\u0003&sEkX*Z'R+UJ\u0003\tD_:\u001cHO]1j]R\u001c\u0016p\u001d;f[*I\u0011N\u001c4fe\u0016t7-\u001a\u0006\u001cO\u0016$(+\u0012(E\u000bJ{6i\u0014(T)J\u000b\u0015J\u0014+`'f\u001bF+R'\u000b1I+e\nR#S?B{5+\u0013+J\u001f:{f+\u0011*J\u0003:\u001bUI\u0003\u0005WCJL\u0017M\\2f\u0015m9W\r\u001e*F\u001d\u0012+%k\u0018)P'&#\u0016j\u0014(`-\u0006\u0013\u0016*\u0011(D\u000b*Y!+\u0012(E\u000bJ{F+\u0017)F\u001599W\r\u001e*F\u001d\u0012+%k\u0018+Z!\u0016S!CU#O\t\u0016\u0013v\fV-Q\u000b~\u0013u*\u0016(E'*QA+\u001f9f\u0005>,h\u000eZ:\u000b+\u001d,GOU#O\t\u0016\u0013v\fV-Q\u000b~\u0013u*\u0016(E'*11\u000b\u0016*J\u001d\u001eSaa\u0015;sS:<'\"C4fiN#&+\u0013(H\u0015%!vjX*U%&suI\u0003\u0007hKR$vjX*U%&suI\u0003\u0017U3B+u,\u0013(G\u000bJ+ejQ#`\u0007\u0006sej\u0014+`\u0007\u0006\u0003F+\u0016*F?RK\u0006+R*`%\u0016sE)\u0012*F%*\u0011\u0012J\u001c4fe\u0016t7-Z#se>\u0014H)\u0019;b\u0015=:W\r\u001e+Z!\u0016{\u0016J\u0014$F%\u0016s5)R0D\u0003:su\nV0D\u0003B#VKU#`)f\u0003ViU0S\u000b:#UIU#S\u0015E\"\u0016\fU#`\u0013:3UIU#O\u0007\u0016{6i\u0014(G\u0019&\u001bE+\u0013(H?N+&i\u0015+J)V#\u0016j\u0014(T?J+e\nR#S\u000bJSAgZ3u)f\u0003ViX%O\r\u0016\u0013VIT\"F?\u000e{eJ\u0012'J\u0007RKejR0T+\n\u001bF+\u0013+V)&{ejU0S\u000b:#UIU#S\u0015Q\"\u0016\fU#`\u0013:3UIU#O\u0007\u0016{fjT0J\u001d\u001a{%+T!U\u0013>suLR(S?B\u000b%+Q'F)\u0016\u0013vLU#O\t\u0016\u0013VI\u0015\u00068O\u0016$H+\u0017)F?&se)\u0012*F\u001d\u000e+uLT(`\u0013:3uJU'B)&{ej\u0018$P%~\u0003\u0016IU!N\u000bR+%k\u0018*F\u001d\u0012+%+\u0012*\u000bcQK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~#\u0016\fU#`\u0007>s5\u000b\u0016*V\u0007R{%kX'J'6\u000bEk\u0011%`%\u0016sE)\u0012*F%*!t-\u001a;U3B+u,\u0013(G\u000bJ+ejQ#`)f\u0003ViX\"P\u001dN#&+V\"U\u001fJ{V*S*N\u0003R\u001b\u0005j\u0018*F\u001d\u0012+%+\u0012*\u000bYQK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~+\u0006\u000bU#S?\n{UK\u0014#`-&{E*\u0011+F\t~\u0013VI\u0014#F%\u0016\u0013&bL4fiRK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~+\u0006\u000bU#S?\n{UK\u0014#`-&{E*\u0011+F\t~\u0013VI\u0014#F%\u0016\u0013&\"\u0001+\u000b\u001d\r|W.\\1TKB\f'/\u0019;fI*a\u0011\u000e^3n%\u0016tG-\u001a:fe*)#/\u001a8eKJ\u001c\u0015M\u001c8pi\u000e\u000b\u0007\u000f^;sKRK\b/\u001a)be\u0006lW\r^3s\u000bJ\u0014xN\u001d\u0006\u0013S:4WM]3oG\u0016,%O]8s\t\u0006$\u0018M\u0003\u0004sKN,H\u000e\u001e\u0006\u0019)\u0006\u0014G.\u001a3EKN\u001c'/\u001b9u_J\u0014VM\u001c3fe\u0016\u0014(\u0002\f:f]\u0012,'oQ8oM2L7\r^5oON+(m\u001d;jiV$\u0018n\u001c8t\u0013:4WM]3oG\u0016,%O]8s\u0015Y\u0011XM\u001c3fe\u000e{gn\u001d;sC&tGoU=ti\u0016l'\u0002E2p]N$(/Y5oiNK8\u000f^3n\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0013e\u0016tG-\u001a:EK\n,x-T3tg\u0006<WMC\u0004nKN\u001c\u0018mZ3\u000bII,g\u000eZ3s\u001d>LeNZ8s[\u0006$\u0018n\u001c8G_J\u0004\u0016M]1nKR,'/\u0012:s_JT\u0001C]3oI\u0016\u0014H+\u001f9f\u0005>,h\u000eZ:\u000b\u0015QL\b/\u001a\"pk:$7O\u0003\u0012sK:$WM\u001d+za\u0016\u001cuN\\:ueV\u001cGo\u001c:NSNl\u0017\r^2i\u000bJ\u0014xN\u001d\u0006\fe\u0016tG-\u001a:UsB,7O\u0003\u0003vi&d'B\n:f]\u0012,'/\u00169qKJ\u0014u.\u001e8e-&|G.\u0019;fI&sg-\u001a:f]\u000e,WI\u001d:per\u0016!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0002\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u0013)1\u0001\u0002\u0003\t\t1\u0001Qa\u0001\u0003\u0004\u0011\u0015a\u0001!\u0002\u0002\u0005\u0003!1QA\u0001C\u0006\u0011\u001b)!\u0001\u0002\u0004\t\u000f\u0015\u0019AQ\u0002E\u0006\u0019\u0001)!\u0001\u0002\u0003\t\t\u0015\u0011A!\u0001\u0005\n\u000b\r!\u0001\u0002#\u0005\r\u0001\u0015\u0011A!\u0001\u0005\f\u000b\r!\u0011\u0002#\u0006\r\u0001\u0015\t\u0001\"D\u0003\u0003\t)AY\"\u0002\u0002\u0005\u0016!YQa\u0001\u0003\f\u00113a\u0001!\u0002\u0002\u0005\u0016!}QA\u0001\u0003\r\u0011A)1\u0001\"\u0007\t\u001f1\u0001QA\u0001C\r\u0011=)1\u0001\u0002\u0005\t$1\u0001Qa\u0001\u0003\n\u0011Ma\u0001!\u0002\u0002\u0005\u0003!1Ra\u0001\u0003\u0010\u0011Wa\u0001!\u0002\u0002\u0005\r!ARa\u0001\u0003\u0011\u0011_a\u0001!B\u0002\u0005\u001f!MB\u0002A\u0003\u0004\tAAA\u0004\u0004\u0001\u0006\u0007\u0011\u0019\u00012\b\u0007\u0001\u000b\r!\u0001\u0003\u0003\u0011\r\u0001\u0015\u0019AA\u0001\u0005)\u0019\u0001)!\u0001\u0002\u0002\tQ\u0015\u0011A\u0001\u0005\u0005!\u000b\u0005A!&\u0002\u0002\u0005*!USA\u0001\u0003\u0016\u0011w)!\u0001\u0002\t\t0\u0015\u0011A\u0001\u0005\u0005\u001d\u000b\t!I\u0003#\u0018\u0006\u0005\u00119\u0002\"\u0002\u0003d\u00031\u0015\u0011DA\u0003\u0002\u0011\u000fi\u0013\u0004B2\u00051\u000f\tC\"B\u0001\t\n%I\u0011\u0002C\u0003\u0002\u0011\u0015IQ!\u0003\u0003\u0006\u0003!9\u0011\"\u0001C\u0002+\u000eAQa\u0001C\u0004\u0013\u0005Ay!D\u0002\u0005\u0010%\t\u0001rB\u0017\u0018\t\r$\u0001\u0004C\u0011\u000b\u000b\u0005AI!C\u0004\n\r\u0015\t\u0001\"B\u0005\u0004\u0013\t)\u0011\u0001#\u0005V\u0007!)1\u0001\u0002\u0005\n\u0003!=Qb\u0001C\n\u0013\u0005Ay!L\n\u0005G\u0012A\"\"\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005A\u0019\"V\u0002\t\u000b\r!!\"C\u0001\t\u00105\u0019AqC\u0005\u0002\u0011\u001fi3\u0003B2\u000511\tc!B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011/)6\u0001C\u0003\u0004\t1I\u0011\u0001c\u0004\u000e\u0007\u0011q\u0011\"\u0001E\b[A!\u0011\r\u0002M\u000fC\u001d)\u0011\u0001C\u0007\u0011\"U\u0019Q!\u0001\u0005\u000e\u0019\u0003)6\u0001B\u0003\u0004\t;I\u0011\u0001c\u0007.'\u0011\u0019G\u0001G\t\"\r\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001\u0003\bV\u0007!)1\u0001B\t\n\u0003!=Qb\u0001\u0003\u0013\u0013\u0005Ay!L\n\u0005G\u0012A*#\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005Ai\"V\u0002\t\u000b\r!)#C\u0001\t\u00105\u0019AqE\u0005\u0002\u0011\u001fi3\u0003B2\u00051Q\tc!B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011#)6\u0001C\u0003\u0004\tQI\u0011\u0001c\u0004\u000e\u0007\u0011%\u0012\"\u0001E\b[]!1\r\u0002\r\u0016C))\u0011\u0001#\u0003\n\u000f%1Q!\u0001\u0005\u0006\u0013\rI!!B\u0001\t U\u001b\u0001\"B\u0002\u0005+%\t\u0001rB\u0007\u0004\t[I\u0011\u0001c\u0004.'\u0011\u0019G\u0001G\f\"\r\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001#\tV\u0007!)1\u0001B\f\n\u0003!=Qb\u0001C\u0019\u0013\u0005Ay!L\n\u0005G\u0012A\u0012$\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005A\u0011#V\u0002\t\u000b\r!\u0011$C\u0001\t\u00105\u0019AAG\u0005\u0002\u0011\u001fi3\u0003B2\u00051k\tc!B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011?)6\u0001C\u0003\u0004\tkI\u0011\u0001c\u0004\u000e\u0007\u0011Y\u0012\"\u0001E\b[M!1\r\u0002M\u001cC\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001E\u0012+\u000eAQa\u0001C\u001c\u0013\u0005Ay!D\u0002\u0005:%\t\u0001rB\u0017\u0014\t\r$\u0001$H\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001BE+\u0004\u0011\u0015\u0019A!H\u0005\u0002\u0011\u001fi1\u0001\u0002\u0010\n\u0003!=Qf\u0005\u0003d\tau\u0012EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!\u001dQk\u0001\u0005\u0006\u0007\u0011u\u0012\"\u0001E\b\u001b\r!q$C\u0001\t\u00105\u001aBa\u0019\u0003\u0019@\u00052Q!\u0001E\u0005\u0013\rI!!B\u0001\t&U\u001b\u0001\"B\u0002\u0005@%\t\u0001rB\u0007\u0004\t\u0003J\u0011\u0001c\u0004.'\u0011\u0019G\u0001G\u0011\"\r\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001#\nV\u0007!)1\u0001B\u0011\n\u0003!=Qb\u0001C\"\u0013\u0005Ay!L\n\u0005G\u0012A\"%\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005A)#V\u0002\t\u000b\r!!%C\u0001\t\u00105\u0019AQI\u0005\u0002\u0011\u001fi3\u0003B2\u00051\r\nc!B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011K)6\u0001C\u0003\u0004\t\rJ\u0011\u0001c\u0004\u000e\u0007\u0011\u001d\u0013\"\u0001E\b[M!1\r\u0002\r%C\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001E\u0013+\u000eAQa\u0001\u0003%\u0013\u0005Ay!D\u0002\u0005J%\t\u0001rB\u0017)\t\u000f\tb\u0001\u0002\u0001\tKU\u0019Q!\u0001E\u0004\u0019\u0003AZ%h\u0006\u0005\u0001!1SbB\u0003\u0002\u0011\u0013IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0001\u0005ZQ!\u0001E\u0005\u0013!Iq!B\u0001\t\u000b%!\u0011bA\u0003\u0003\t\u0003A\u0001!U\u0002\u0006\t\u0017J\u0011\u0001c\u0004\u000e\u0003!=Q\u0016\bC\u00041\u001bjj\u0001\u0002\u0001\tO5\u0011Q!\u0001E\u0013!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001fj!!B\u0001\t'A\u001b\t!\t\u0002\u0006\u0003!\u0019\u0012kA\u0004\u0005N%\t\u0001rE\u0007\u0002\u0011Qi\u0011\u0001c\n.:\u0011\u001d\u0001\u0014KO\u0007\t\u0001Aq%\u0004\u0002\u0006\u0003!\u0015\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rJ\u0007\u0003\u000b\u0005A1\u0003UB\u0001C\t)\u0011\u0001C\nR\u0007\u001d!\t&C\u0001\t(5\t\u0001\u0002F\u0007\u0002\u0011Oi3\u0003B\u0001\u0019Su5A\u0001\u0001E*\u001b\t)\u0011\u0001#\tQ\u0007\u0001\t#!B\u0001\t%E\u001bQ\u0001B\u0015\n\u0003!-R\"\u0001\u0005\u0017[\u0007\"\u0011\u0001G\u0016\u001e\u000e\u0011\u0001\u0001rK\u0007\u0003\u000b\u0005A!\u0003U\u0002\u0001;\u001b!\u0001\u0001C\u0014\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0002\u0005:Q!\u0001\u0005\u0013!C)2!B\u0001\t%1\u0005\u0011kA\u0004\u0005W%\t\u00012F\u0007\u0002\u0011Wi\u0011\u0001\u0003\u000b.:\u0011\u001d\u0001\u0004LO\u0007\t\u0001Aq%\u0004\u0002\u0006\u0003!\u0015\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rJ\u0007\u0003\u000b\u0005A1\u0003UB\u0001C\t)\u0011\u0001C\nR\u0007\u001d!A&C\u0001\t(5\t\u0001\u0002F\u0007\u0002\u0011Oi3\u0003B\u0001\u0019Zu5A\u0001\u0001\u0005.\u001b\t)\u0011\u0001c\tQ\u0007\u0001\t#!B\u0001\t%E\u001bQ\u0001\"\u0017\n\u0003!-R\"\u0001E\u0017[s!9\u0001g\u0017\u001e\u000e\u0011\u0001\u0001bJ\u0007\u0003\u000b\u0005A)\u0003U\u0002\u0001;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001b\u0005)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0014#\u000e9A1L\u0005\u0002\u0011Oi\u0011\u0001\u0003\u000b\u000e\u0003!\u001dR\u0006\b\u0003\u000219j*\u0002\u0002\u0001\t-51Q!\u0001\u0005\u0006\u0013\rI!!B\u0001\t A\u001b\u0001!I\u0004\u0006\u0003!\u0011\u0002\u0013E\u000b\u0004\u000b\u0005A!\u0003$\u0001R\u0007\u0015!a&C\u0001\t,5\t\u0001rFW\u001d\t\u000fAr&(\u0004\u0005\u0001!9SBA\u0003\u0002\u0011K\u00016\u0001AO\u0007\t\u0001Ay%\u0004\u0002\u0006\u0003!\u0019\u0002k!\u0001\"\u0005\u0015\t\u0001bE)\u0004\u000f\u0011y\u0013\"\u0001E\u0014\u001b\u0005AA#D\u0001\t(U\u0002\u0001"})
public final class Renderers {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final Renderer<Object> TO_STRING;
    @NotNull
    public static final Renderer<String> STRING;
    @NotNull
    public static final Renderer<Named> NAME;
    @NotNull
    public static final Renderer<PsiElement> ELEMENT_TEXT;
    @NotNull
    public static final Renderer<JetNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT;
    @NotNull
    public static final Renderer<ClassDescriptor> RENDER_CLASS_OR_OBJECT_NAME;
    @NotNull
    public static final Renderer<JetType> RENDER_TYPE;
    @NotNull
    public static final Renderer<Variance> RENDER_POSITION_VARIANCE;
    @NotNull
    public static final Renderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @NotNull
    public static final Renderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @NotNull
    public static final Renderer<Collection<? extends JetType>> RENDER_COLLECTION_OF_TYPES;
    @NotNull
    public static final Renderer<ConstraintSystem> RENDER_CONSTRAINT_SYSTEM;
    @NotNull
    public static final Renderer<TypeBounds> RENDER_TYPE_BOUNDS;
    public static final Renderers INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(Renderers.class);
        new Renderers();
    }

    @NotNull
    public final Renderer<Object> getTO_STRING() {
        return TO_STRING;
    }

    @NotNull
    public final Renderer<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public final Renderer<Named> getNAME() {
        return NAME;
    }

    @NotNull
    public final Renderer<PsiElement> getELEMENT_TEXT() {
        return ELEMENT_TEXT;
    }

    @NotNull
    public final Renderer<JetNamedDeclaration> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final Renderer<JetClassOrObject> getRENDER_CLASS_OR_OBJECT() {
        return RENDER_CLASS_OR_OBJECT;
    }

    @NotNull
    public final Renderer<ClassDescriptor> getRENDER_CLASS_OR_OBJECT_NAME() {
        return RENDER_CLASS_OR_OBJECT_NAME;
    }

    @NotNull
    public final Renderer<JetType> getRENDER_TYPE() {
        return RENDER_TYPE;
    }

    @NotNull
    public final Renderer<Variance> getRENDER_POSITION_VARIANCE() {
        return RENDER_POSITION_VARIANCE;
    }

    @NotNull
    public final Renderer<Collection<? extends ResolvedCall<?>>> getAMBIGUOUS_CALLS() {
        return AMBIGUOUS_CALLS;
    }

    @platformStatic
    @NotNull
    public static final <T> Renderer<Collection<? extends T>> commaSeparated(@JetValueParameter(name="itemRenderer") @NotNull Renderer<T> itemRenderer) {
        Intrinsics.checkParameterIsNotNull(itemRenderer, "itemRenderer");
        return new Renderer<Collection<? extends T>>(itemRenderer){
            final /* synthetic */ Renderer $itemRenderer;

            @NotNull
            public final String render(@JetValueParameter(name="collection") Collection<? extends T> collection) {
                StringBuilder stringBuilder;
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                Iterator<T> iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    T next = iterator2.next();
                    $receiver.append(this.$itemRenderer.render(next));
                    if (!iterator2.hasNext()) continue;
                    $receiver.append(", ");
                }
                return stringBuilder.toString();
            }
            {
                this.$itemRenderer = renderer;
            }
        };
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER() {
        return TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER() {
        return TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER() {
        return TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER() {
        return TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER() {
        return TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), INSTANCE$.renderDebugMessage("Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor : substitutors) {
            CallableDescriptor substitutedDescriptor = inferenceErrorData.descriptor.substitute(substitutor);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(inferenceErrorData.constraintSystem);
        if (firstConflictingParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingParameter.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            JetType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<JetType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                JetType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || JetTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            boolean bl = (receiverType != null ? inferenceErrorData.receiverArgumentType != null : false) ? !JetTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType) : false;
            if (bl) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<JetType>)parameterTypes, new Predicate<ConstraintPosition>(errorPositions){
                final /* synthetic */ HashSet $errorPositions;

                public final boolean apply(@JetValueParameter(name="it") ConstraintPosition it) {
                    return this.$errorPositions.contains(it);
                }
                {
                    this.$errorPositions = hashSet;
                }
            });
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderTypeConstructorMismatchError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="renderer") @NotNull TabledDescriptorRenderer renderer) {
        ConstraintError it;
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(renderer, "renderer");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        if (constraintSystem == null) {
            throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
        }
        List<ConstraintError> constraintErrors = ((ConstraintSystemImpl)constraintSystem).getConstraintErrors();
        Iterable iterable = constraintErrors;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            it = (ConstraintError)t;
            if (!(it instanceof TypeConstructorMismatch)) continue;
            collection.add(t);
        }
        iterable = (ArrayList)collection;
        iterable2 = iterable;
        collection = new ArrayList();
        for (Object t : iterable2) {
            it = (ConstraintError)t;
            Collection collection2 = collection;
            ConstraintPosition constraintPosition = it.getConstraintPosition();
            collection2.add(constraintPosition);
        }
        List errorPositions = (ArrayList)collection;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, new Predicate<ConstraintPosition>(errorPositions){
            final /* synthetic */ List $errorPositions;

            public final boolean apply(@JetValueParameter(name="it") ConstraintPosition it) {
                return this.$errorPositions.contains(it);
            }
            {
                this.$errorPositions = list;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(tabledDescriptorRenderer, "renderer.table(\n        \u2026ositions.contains(it) }))");
        return tabledDescriptorRenderer;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        TypeParameterDescriptor firstUnknownParameter = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.constraintSystem.getTypeVariables()) {
            if (!inferenceErrorData.constraintSystem.getTypeBounds(typeParameter).isEmpty()) continue;
            firstUnknownParameter = typeParameter;
            break;
        }
        if (firstUnknownParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData));
            return result2;
        }
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ");
        TypeParameterDescriptor typeParameterDescriptor = firstUnknownParameter;
        if (typeParameterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        TabledDescriptorRenderer tabledDescriptorRenderer = result2.text(textRenderer.strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkExpressionValueIsNotNull(tabledDescriptorRenderer, "result\n                .\u2026specify it explicitly.\"))");
        return tabledDescriptorRenderer;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Object v1;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status;
        block7: {
            Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
            Intrinsics.checkParameterIsNotNull(result2, "result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            if (constraintSystem == null) {
                throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
            }
            ConstraintSystemImpl constraintSystem2 = (ConstraintSystemImpl)constraintSystem;
            status = constraintSystem2.getStatus();
            LOG.assertTrue(status.hasViolatedUpperBound(), INSTANCE$.renderDebugMessage("Upper bound violated renderer is applied for incorrect status", inferenceErrorData));
            systemWithoutWeakConstraints = constraintSystem2.getSystemWithoutWeakConstraints();
            Iterable iterable = inferenceErrorData.descriptor.getTypeParameters();
            for (Object t : iterable) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, it, true))) continue;
                v1 = t;
                break block7;
            }
            v1 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v1;
        if (typeParameterDescriptor == null ? status.hasConflictingConstraints() : false) {
            return Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
        }
        if (typeParameterDescriptor == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData));
            return result2;
        }
        JetType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeParameterDescriptor).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        JetType violatedUpperBound = null;
        for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
            JetType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            boolean bl = upperBoundWithSubstitutedInferredTypes != null ? !JetTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes) : false;
            if (!bl) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(INSTANCE$.renderDebugMessage("Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData));
            return result2;
        }
        Renderer<JetType> typeRenderer = result2.getTypeRenderer();
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound)));
        return result2;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        CapturedTypeConstructor capturedTypeConstructor;
        TypeConstructor typeConstructor2;
        TypeBounds.Bound boundWithCapturedType;
        Object object;
        Object v4;
        TypeParameterDescriptor typeParameterWithCapturedConstraint;
        block8: {
            ConstraintError constraintError;
            Object v1;
            Object object22;
            ConstraintSystemImpl constraintSystem;
            block7: {
                Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
                Intrinsics.checkParameterIsNotNull(result2, "result");
                ConstraintSystem constraintSystem2 = inferenceErrorData.constraintSystem;
                if (constraintSystem2 == null) {
                    throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                constraintSystem = (ConstraintSystemImpl)constraintSystem2;
                List<ConstraintError> errors = constraintSystem.getConstraintErrors();
                Iterable iterable = errors;
                for (Object object22 : iterable) {
                    ConstraintError it = (ConstraintError)object22;
                    if (!(it instanceof CannotCapture)) continue;
                    v1 = object22;
                    break block7;
                }
                v1 = null;
            }
            if (!((constraintError = (ConstraintError)v1) instanceof CannotCapture)) {
                constraintError = null;
            }
            CannotCapture cannotCapture = (CannotCapture)constraintError;
            typeParameterWithCapturedConstraint = cannotCapture != null ? cannotCapture.getTypeVariable() : null;
            if (typeParameterWithCapturedConstraint == null) {
                LOG.error(INSTANCE$.renderDebugMessage("An error 'cannot capture type parameter' is not found in errors", inferenceErrorData));
                return result2;
            }
            TypeBoundsImpl typeBounds = constraintSystem.getTypeBounds(typeParameterWithCapturedConstraint);
            object22 = typeBounds.getBounds();
            for (Object e : object22) {
                TypeBounds.Bound it = (TypeBounds.Bound)e;
                if (!InferencePackage$CapturedTypeConstructor$6c84c44e.isCaptured(it.getConstrainingType())) continue;
                v4 = e;
                break block8;
            }
            v4 = null;
        }
        if (!(((object = (boundWithCapturedType = (TypeBounds.Bound)v4)) != null && (object = ((TypeBounds.Bound)object).getConstrainingType()) != null ? object.getConstructor() : (typeConstructor2 = null)) instanceof CapturedTypeConstructor)) {
            typeConstructor2 = null;
        }
        if ((capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2) == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData));
            return result2;
        }
        JetType upperBound = typeParameterWithCapturedConstraint.getUpperBoundsAsType();
        String explanation = (!KotlinBuiltIns.isNullableAny(upperBound) ? Intrinsics.areEqual((Object)capturedTypeConstructor.getTypeProjection().getProjectionKind(), (Object)Variance.IN_VARIANCE) : false) ? "Type parameter has an upper bound '" + result2.getTypeRenderer().render(upperBound) + "'" + " that cannot be satisfied capturing 'in' projection" : "Only top-level type projections can be captured";
        result2.text(TabledDescriptorRenderer.newText().normal("'" + typeParameterWithCapturedConstraint.getName() + "'" + " cannot capture " + "'" + capturedTypeConstructor.getTypeProjection() + "'. " + explanation));
        return result2;
    }

    @NotNull
    public final Renderer<Collection<? extends ClassDescriptor>> getCLASSES_OR_SEPARATED() {
        return CLASSES_OR_SEPARATED;
    }

    private final String renderTypes(@JetValueParameter(name="types") Collection<? extends JetType> types) {
        return StringUtil.join(types, (Function)renderTypes.1.INSTANCE$, ", ");
    }

    @NotNull
    public final Renderer<Collection<? extends JetType>> getRENDER_COLLECTION_OF_TYPES() {
        return RENDER_COLLECTION_OF_TYPES;
    }

    private final String renderConstraintSystem(@JetValueParameter(name="constraintSystem") ConstraintSystem constraintSystem) {
        Set<TypeParameterDescriptor> typeVariables = constraintSystem.getTypeVariables();
        LinkedHashSet<TypeBounds> typeBounds = Sets.newLinkedHashSet();
        for (TypeParameterDescriptor variable : typeVariables) {
            typeBounds.add(constraintSystem.getTypeBounds(variable));
        }
        return "type parameter bounds:\n" + StringUtil.join((Collection)typeBounds, (Function)renderConstraintSystem.1.INSTANCE$, "\n") + "\n" + "status:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    @NotNull
    public final Renderer<ConstraintSystem> getRENDER_CONSTRAINT_SYSTEM() {
        return RENDER_CONSTRAINT_SYSTEM;
    }

    private final String renderTypeBounds(@JetValueParameter(name="typeBounds") TypeBounds typeBounds) {
        String string;
        Function1 renderBound2 = renderTypeBounds.renderBound.1.INSTANCE$;
        Name typeVariableName = typeBounds.getTypeVariable().getName();
        if (typeBounds.isEmpty()) {
            string = typeVariableName.asString();
        } else {
            Function1 function1 = renderBound2;
            string = typeVariableName + " " + StringUtil.join(typeBounds.getBounds(), (Function)(function1 == null ? null : new RenderingPackage$sam$Function$75ae0dca(function1)), ", ");
        }
        return string;
    }

    @NotNull
    public final Renderer<TypeBounds> getRENDER_TYPE_BOUNDS() {
        return RENDER_TYPE_BOUNDS;
    }

    private final String renderDebugMessage(@JetValueParameter(name="message") String message, @JetValueParameter(name="inferenceErrorData") InferenceErrorData inferenceErrorData) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(message);
        $receiver.append("\nConstraint system: \n");
        $receiver.append(INSTANCE$.getRENDER_CONSTRAINT_SYSTEM().render(inferenceErrorData.constraintSystem));
        $receiver.append("\nDescriptor:\n");
        $receiver.append(inferenceErrorData.descriptor);
        $receiver.append("\nExpected type:\n");
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            $receiver.append(inferenceErrorData.expectedType);
        } else {
            $receiver.append(INSTANCE$.getRENDER_TYPE().render(inferenceErrorData.expectedType));
        }
        $receiver.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            $receiver.append(INSTANCE$.getRENDER_TYPE().render(inferenceErrorData.receiverArgumentType)).append(".");
        }
        StringBuilder stringBuilder2 = $receiver.append("(");
        Collection collection = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkExpressionValueIsNotNull(collection, "inferenceErrorData.valueArgumentsTypes");
        stringBuilder2.append(Renderers.INSTANCE$.renderTypes(collection)).append(")");
        return stringBuilder.toString();
    }

    Renderers() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(Renderers.class);
        TO_STRING = TO_STRING.1.INSTANCE$;
        STRING = STRING.1.INSTANCE$;
        NAME = NAME.1.INSTANCE$;
        ELEMENT_TEXT = ELEMENT_TEXT.1.INSTANCE$;
        DECLARATION_NAME = DECLARATION_NAME.1.INSTANCE$;
        RENDER_CLASS_OR_OBJECT = RENDER_CLASS_OR_OBJECT.1.INSTANCE$;
        RENDER_CLASS_OR_OBJECT_NAME = RENDER_CLASS_OR_OBJECT_NAME.1.INSTANCE$;
        RENDER_TYPE = RENDER_TYPE.1.INSTANCE$;
        RENDER_POSITION_VARIANCE = RENDER_POSITION_VARIANCE.1.INSTANCE$;
        AMBIGUOUS_CALLS = AMBIGUOUS_CALLS.1.INSTANCE$;
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER = TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER.1.INSTANCE$;
        CLASSES_OR_SEPARATED = CLASSES_OR_SEPARATED.1.INSTANCE$;
        RENDER_COLLECTION_OF_TYPES = RENDER_COLLECTION_OF_TYPES.1.INSTANCE$;
        RENDER_CONSTRAINT_SYSTEM = RENDER_CONSTRAINT_SYSTEM.1.INSTANCE$;
        RENDER_TYPE_BOUNDS = RENDER_TYPE_BOUNDS.1.INSTANCE$;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$0(@JetValueParameter(name="$this", type="?") Renderers $this) {
        Renderers renderers = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ String access$renderConstraintSystem$2(@JetValueParameter(name="$this", type="?") Renderers $this, @JetValueParameter(name="constraintSystem") @NotNull ConstraintSystem constraintSystem) {
        return $this.renderConstraintSystem(constraintSystem);
    }

    @NotNull
    public static final /* synthetic */ String access$renderTypeBounds$3(@JetValueParameter(name="$this", type="?") Renderers $this, @JetValueParameter(name="typeBounds") @NotNull TypeBounds typeBounds) {
        return $this.renderTypeBounds(typeBounds);
    }
}

