/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.util.SmartList;
import java.util.List;
import jet.runtime.typeinfo.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.propertyTranslator.PropertyTranslatorPackage;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.types.JetType;

public class DeclarationBodyVisitor
extends TranslatorVisitor<Void> {
    @KotlinSignature(value="val result: MutableList<JsPropertyInitializer>")
    protected final List<JsPropertyInitializer> result;
    protected final List<JsPropertyInitializer> staticResult;
    protected final List<JsPropertyInitializer> enumEntryList;

    public DeclarationBodyVisitor(@NotNull List<JsPropertyInitializer> result2, @NotNull List<JsPropertyInitializer> staticResult) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        if (staticResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticResult", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        this.enumEntryList = new SmartList<JsPropertyInitializer>();
        this.result = result2;
        this.staticResult = staticResult;
    }

    @NotNull
    public List<JsPropertyInitializer> getResult() {
        List<JsPropertyInitializer> list = this.result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "getResult"));
        }
        return list;
    }

    public List<JsPropertyInitializer> getEnumEntryList() {
        return this.enumEntryList;
    }

    @Override
    protected Void emptyResult(@NotNull TranslationContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "emptyResult"));
        }
        return null;
    }

    @Override
    public Void visitClass(@NotNull JetClass expression, TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitClass"));
        }
        return null;
    }

    @Override
    public Void visitEnumEntry(@NotNull JetEnumEntry enumEntry, TranslationContext data2) {
        JsExpression jsEnumEntryCreation;
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitEnumEntry"));
        }
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(data2.bindingContext(), enumEntry);
        List<JetType> supertypes2 = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor);
        if (enumEntry.getBody() != null || supertypes2.size() > 1) {
            jsEnumEntryCreation = ClassTranslator.generateClassCreation(enumEntry, data2);
        } else {
            assert (supertypes2.size() == 1) : "Simple Enum entry must have one supertype";
            jsEnumEntryCreation = new ClassInitializerTranslator(enumEntry, data2).generateEnumEntryInstanceCreation(supertypes2.get(0));
        }
        this.enumEntryList.add(new JsPropertyInitializer(data2.getNameForDescriptor(descriptor).makeRef(), jsEnumEntryCreation));
        return null;
    }

    @Override
    public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, TranslationContext context2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitObjectDeclaration"));
        }
        if (!declaration.isCompanion()) {
            return null;
        }
        JsInvocation value = ClassTranslator.generateClassCreation(declaration, context2);
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), declaration);
        JsFunction fun = TranslationUtils.simpleReturnFunction(context2.getScopeForDescriptor(descriptor), value);
        this.staticResult.add(InitializerUtils.createCompanionObjectInitializer(fun, context2));
        return null;
    }

    @Override
    public Void visitNamedFunction(@NotNull JetNamedFunction expression, TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context2.bindingContext(), expression);
        if (descriptor.getModality() == Modality.ABSTRACT) {
            return null;
        }
        JsPropertyInitializer methodAsPropertyInitializer = Translation.functionTranslator(expression, context2).translateAsMethod();
        this.result.add(methodAsPropertyInitializer);
        return null;
    }

    @Override
    public Void visitProperty(@NotNull JetProperty expression, TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context2.bindingContext(), expression);
        PropertyTranslatorPackage.translateAccessors(propertyDescriptor, expression, this.result, context2);
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull JetClassInitializer expression, TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitAnonymousInitializer"));
        }
        return null;
    }
}

