/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public final class PsiUtils {
    private PsiUtils() {
    }

    @Nullable
    public static JetSimpleNameExpression getSimpleName(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSimpleName"));
        }
        if (expression instanceof JetSimpleNameExpression) {
            return (JetSimpleNameExpression)expression;
        }
        if (expression instanceof JetQualifiedExpression) {
            return PsiUtils.getSelectorAsSimpleName((JetQualifiedExpression)expression);
        }
        return null;
    }

    @Nullable
    public static JetSimpleNameExpression getSelectorAsSimpleName(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSelectorAsSimpleName"));
        }
        JetExpression selectorExpression = PsiUtils.getSelector(expression);
        if (!(selectorExpression instanceof JetSimpleNameExpression)) {
            return null;
        }
        return (JetSimpleNameExpression)selectorExpression;
    }

    @NotNull
    public static JetExpression getSelector(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSelector"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        assert (selectorExpression != null) : "Selector should not be null.";
        JetExpression jetExpression = selectorExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSelector"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetSimpleNameExpression getNotNullSimpleNameSelector(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getNotNullSimpleNameSelector"));
        }
        JetSimpleNameExpression selectorAsSimpleName = PsiUtils.getSelectorAsSimpleName(expression);
        assert (selectorAsSimpleName != null);
        JetSimpleNameExpression jetSimpleNameExpression = selectorAsSimpleName;
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getNotNullSimpleNameSelector"));
        }
        return jetSimpleNameExpression;
    }

    @NotNull
    public static JetToken getOperationToken(@NotNull JetOperationExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getOperationToken"));
        }
        JetSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType instanceof JetToken) : "Expected JetToken type, but " + elementType.getClass() + ", expression: " + expression.getText();
        JetToken jetToken = (JetToken)elementType;
        if (jetToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getOperationToken"));
        }
        return jetToken;
    }

    @NotNull
    public static JetExpression getBaseExpression(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getBaseExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetExpression jetExpression = baseExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getBaseExpression"));
        }
        return jetExpression;
    }

    public static boolean isPrefix(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isPrefix"));
        }
        return expression instanceof JetPrefixExpression;
    }

    public static boolean isAssignment(JetToken token) {
        return token == JetTokens.EQ;
    }

    public static boolean isInOrNotInOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isInOrNotInOperation"));
        }
        return PsiUtils.isInOperation(binaryExpression) || PsiUtils.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isNotInOperation"));
        }
        return binaryExpression.getOperationToken() == JetTokens.NOT_IN;
    }

    public static boolean isNegatedOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isNegatedOperation"));
        }
        return binaryExpression.getOperationToken() == JetTokens.EXCLEQ || PsiUtils.isNotInOperation(binaryExpression);
    }

    private static boolean isInOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isInOperation"));
        }
        return binaryExpression.getOperationToken() == JetTokens.IN_KEYWORD;
    }

    @NotNull
    public static JetExpression getLoopBody(@NotNull JetLoopExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopBody"));
        }
        JetExpression body = expression.getBody();
        assert (body != null) : "Loops cannot have null bodies.";
        JetExpression jetExpression = body;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopBody"));
        }
        return jetExpression;
    }

    @Nullable
    public static JetParameter getLoopParameter(@NotNull JetForExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopParameter"));
        }
        return expression.getLoopParameter();
    }

    @NotNull
    public static List<JetParameter> getPrimaryConstructorParameters(@NotNull JetClassOrObject classDeclaration) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
        }
        if (classDeclaration instanceof JetClass) {
            List<JetParameter> list = ((JetClass)classDeclaration).getPrimaryConstructorParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    @NotNull
    public static JetExpression getLoopRange(@NotNull JetForExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopRange"));
        }
        JetExpression rangeExpression = expression.getLoopRange();
        assert (rangeExpression != null);
        JetExpression jetExpression = rangeExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopRange"));
        }
        return jetExpression;
    }

    @NotNull
    public static CallableDescriptor getFunctionDescriptor(@NotNull JetCallExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getFunctionDescriptor"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getFunctionDescriptor"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, context2.bindingContext());
        assert (resolvedCall != null);
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            VariableDescriptor variableDescriptor = ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall().getCandidateDescriptor();
            if (variableDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getFunctionDescriptor"));
            }
            return variableDescriptor;
        }
        CallableDescriptor callableDescriptor = resolvedCall.getCandidateDescriptor();
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getFunctionDescriptor"));
        }
        return callableDescriptor;
    }
}

