/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.AbiVersionUtil;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final Map<JvmClassName, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<JvmClassName, KotlinClassHeader.Kind>();
    private static final Map<JvmClassName, KotlinClassHeader.Kind> OLD_DEPRECATED_ANNOTATIONS_KINDS = new HashMap<JvmClassName, KotlinClassHeader.Kind>();
    private int version = -1;
    private String[] annotationData = null;
    private KotlinClassHeader.Kind headerKind = null;
    private JvmAnnotationNames.KotlinClass.Kind classKind = null;
    private JvmAnnotationNames.KotlinSyntheticClass.Kind syntheticClassKind = null;

    private static void initOldAnnotations() {
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION), KotlinClassHeader.Kind.CLASS);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION), KotlinClassHeader.Kind.PACKAGE_FACADE);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_CLASS), KotlinClassHeader.Kind.CLASS);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_PACKAGE), KotlinClassHeader.Kind.PACKAGE_FACADE);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_PACKAGE_FRAGMENT), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_TRAIT_IMPL), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
    }

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null) {
            return null;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            return new KotlinClassHeader(this.headerKind, this.version, null, this.classKind, this.syntheticClassKind);
        }
        if ((this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.PACKAGE_FACADE) && this.annotationData == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, this.version, this.annotationData, this.classKind, this.syntheticClassKind);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        if (this.headerKind != null) {
            return null;
        }
        JvmClassName annotation2 = JvmClassName.byClassId(classId);
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(annotation2);
        if (newKind != null) {
            this.headerKind = newKind;
            switch (newKind) {
                case CLASS: {
                    return new ClassHeaderReader();
                }
                case PACKAGE_FACADE: {
                    return new PackageHeaderReader();
                }
                case SYNTHETIC_CLASS: {
                    return new SyntheticClassHeaderReader();
                }
            }
            throw new IllegalStateException("Unknown kind: " + (Object)((Object)newKind));
        }
        KotlinClassHeader.Kind oldAnnotationKind = OLD_DEPRECATED_ANNOTATIONS_KINDS.get(annotation2);
        if (oldAnnotationKind != null) {
            this.headerKind = oldAnnotationKind;
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    @Nullable
    private static <E extends Enum<E>> E valueOfOrNull(@NotNull Class<E> enumClass, @NotNull String entry) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "valueOfOrNull"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "valueOfOrNull"));
        }
        try {
            return Enum.valueOf(enumClass, entry);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static /* synthetic */ String[] access$102(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(JvmAnnotationNames.KotlinClass.CLASS_NAME, KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), KotlinClassHeader.Kind.PACKAGE_FACADE);
        HEADER_KINDS.put(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME, KotlinClassHeader.Kind.SYNTHETIC_CLASS);
        ReadKotlinClassHeaderAnnotationVisitor.initOldAnnotations();
    }

    private class SyntheticClassHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public SyntheticClassHeaderReader() {
            super(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME);
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (JvmAnnotationNames.KotlinSyntheticClass.KIND_CLASS_ID.equals(enumClassId) && "kind".equals(name.asString())) {
                ReadKotlinClassHeaderAnnotationVisitor.this.syntheticClassKind = (JvmAnnotationNames.KotlinSyntheticClass.Kind)ReadKotlinClassHeaderAnnotationVisitor.valueOfOrNull(JvmAnnotationNames.KotlinSyntheticClass.Kind.class, enumEntryName.asString());
                if (ReadKotlinClassHeaderAnnotationVisitor.this.syntheticClassKind != null) {
                    return;
                }
            }
            this.unexpectedEnumArgument(name, enumClassId, enumEntryName);
        }
    }

    private class PackageHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public PackageHeaderReader() {
            super(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE));
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$PackageHeaderReader", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$PackageHeaderReader", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$PackageHeaderReader", "visitEnum"));
            }
            this.unexpectedEnumArgument(name, enumClassId, enumEntryName);
        }
    }

    private class ClassHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public ClassHeaderReader() {
            super(JvmAnnotationNames.KotlinClass.CLASS_NAME);
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$ClassHeaderReader", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$ClassHeaderReader", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$ClassHeaderReader", "visitEnum"));
            }
            if (JvmAnnotationNames.KotlinClass.KIND_CLASS_ID.equals(enumClassId) && "kind".equals(name.asString())) {
                ReadKotlinClassHeaderAnnotationVisitor.this.classKind = (JvmAnnotationNames.KotlinClass.Kind)ReadKotlinClassHeaderAnnotationVisitor.valueOfOrNull(JvmAnnotationNames.KotlinClass.Kind.class, enumEntryName.asString());
                if (ReadKotlinClassHeaderAnnotationVisitor.this.classKind != null) {
                    return;
                }
            }
            this.unexpectedEnumArgument(name, enumClassId, enumEntryName);
        }
    }

    private abstract class HeaderAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        protected final JvmClassName annotationClassName;

        public HeaderAnnotationArgumentVisitor(@NotNull JvmClassName annotationClassName) {
            if (annotationClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "<init>"));
            }
            this.annotationClassName = annotationClassName;
        }

        @Override
        public void visit(@Nullable Name name, @Nullable Object value) {
            if (name != null && name.asString().equals("abiVersion")) {
                ReadKotlinClassHeaderAnnotationVisitor.this.version = value == null ? -1 : (Integer)value;
            } else {
                this.unexpectedArgument(name);
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitArray"));
            }
            if (name.asString().equals("data")) {
                return this.stringArrayVisitor();
            }
            if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                throw new IllegalStateException("Unexpected array argument " + name + " for annotation " + this.annotationClassName);
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringArrayVisitor() {
            final ArrayList strings2 = new ArrayList(1);
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(){

                @Override
                public void visit(@Nullable Object value) {
                    if (!(value instanceof String)) {
                        throw new IllegalStateException("Unexpected argument value: " + value);
                    }
                    strings2.add((String)value);
                }

                @Override
                public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                    if (enumClassId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$1", "visitEnum"));
                    }
                    if (enumEntryName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$1", "visitEnum"));
                    }
                    HeaderAnnotationArgumentVisitor.this.unexpectedArgument(null);
                }

                @Override
                public void visitEnd() {
                    ReadKotlinClassHeaderAnnotationVisitor.access$102(ReadKotlinClassHeaderAnnotationVisitor.this, strings2.toArray(new String[strings2.size()]));
                }
            };
            if (annotationArrayArgumentVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "stringArrayVisitor"));
            }
            return annotationArrayArgumentVisitor;
        }

        @Nullable
        protected KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor unexpectedArgument(@Nullable Name name) {
            if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                throw new IllegalStateException("Unexpected argument " + name + " for annotation " + this.annotationClassName);
            }
            return null;
        }

        protected void unexpectedEnumArgument(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "unexpectedEnumArgument"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "unexpectedEnumArgument"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "unexpectedEnumArgument"));
            }
            if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                throw new IllegalStateException("Unexpected enum entry for class annotation " + this.annotationClassName + ": " + name + "=" + enumClassId + "." + enumEntryName);
            }
        }

        @Override
        public void visitEnd() {
        }
    }
}

