/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetWithExpressionInitializer;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetPropertyAccessor
extends JetDeclarationStub<KotlinPropertyAccessorStub>
implements JetDeclarationWithBody,
JetModifierListOwner,
JetWithExpressionInitializer {
    public JetPropertyAccessor(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "<init>"));
        }
        super(node2);
    }

    public JetPropertyAccessor(@NotNull KotlinPropertyAccessorStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "<init>"));
        }
        super(stub, JetStubElementTypes.PROPERTY_ACCESSOR);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "accept"));
        }
        return visitor2.visitPropertyAccessor(this, data2);
    }

    public boolean isSetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return !stub.isGetter();
        }
        return this.findChildByType(JetTokens.SET_KEYWORD) != null;
    }

    public boolean isGetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.isGetter();
        }
        return this.findChildByType(JetTokens.GET_KEYWORD) != null;
    }

    @Nullable
    public JetParameter getParameter() {
        JetParameterList parameterList = (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
        if (parameterList == null) {
            return null;
        }
        List<JetParameter> parameters2 = parameterList.getParameters();
        if (parameters2.isEmpty()) {
            return null;
        }
        return parameters2.get(0);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameter parameter = this.getParameter();
        if (parameter == null) {
            List<JetParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "getValueParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.singletonList(parameter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "getValueParameters"));
        }
        return list;
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasBlockBody() {
        return this.getEqualsToken() == null;
    }

    @Override
    public boolean hasBody() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(JetTokens.EQ);
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Nullable
    public JetTypeReference getReturnTypeReference() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }

    @NotNull
    public PsiElement getNamePlaceholder() {
        Object get2 = this.findChildByType(JetTokens.GET_KEYWORD);
        if (get2 != null) {
            Object t = get2;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "getNamePlaceholder"));
            }
            return t;
        }
        Object t = this.findChildByType(JetTokens.SET_KEYWORD);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPropertyAccessor", "getNamePlaceholder"));
        }
        return t;
    }

    @Nullable
    public ASTNode getRightParenthesis() {
        return this.getNode().findChildByType(JetTokens.RPAR);
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), JetExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }
}

