/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypedef;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.DeclarationResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisParameters;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.resolveUtil.ResolveUtilPackage;
import org.jetbrains.kotlin.resolve.varianceChecker.VarianceChecker;

public class LazyTopDownAnalyzer {
    private BindingTrace trace;
    private DeclarationResolver declarationResolver;
    private OverrideResolver overrideResolver;
    private OverloadResolver overloadResolver;
    private VarianceChecker varianceChecker;
    private ModuleDescriptor moduleDescriptor;
    private LazyDeclarationResolver lazyDeclarationResolver;
    private BodyResolver bodyResolver;
    private TopLevelDescriptorProvider topLevelDescriptorProvider;
    private FileScopeProvider fileScopeProvider;
    private DeclarationScopeProvider declarationScopeProvider;

    @Inject
    public void setLazyDeclarationResolver(@NotNull LazyDeclarationResolver lazyDeclarationResolver) {
        if (lazyDeclarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyDeclarationResolver", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setLazyDeclarationResolver"));
        }
        this.lazyDeclarationResolver = lazyDeclarationResolver;
    }

    @Inject
    public void setTopLevelDescriptorProvider(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider) {
        if (topLevelDescriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelDescriptorProvider", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setTopLevelDescriptorProvider"));
        }
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
    }

    @Inject
    public void setFileScopeProvider(@NotNull FileScopeProvider fileScopeProvider) {
        if (fileScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScopeProvider", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setFileScopeProvider"));
        }
        this.fileScopeProvider = fileScopeProvider;
    }

    @Inject
    public void setDeclarationScopeProvider(DeclarationScopeProviderImpl declarationScopeProvider) {
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setTrace"));
        }
        this.trace = trace;
    }

    @Inject
    public void setDeclarationResolver(@NotNull DeclarationResolver declarationResolver) {
        if (declarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationResolver", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setDeclarationResolver"));
        }
        this.declarationResolver = declarationResolver;
    }

    @Inject
    public void setOverrideResolver(@NotNull OverrideResolver overrideResolver) {
        if (overrideResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideResolver", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setOverrideResolver"));
        }
        this.overrideResolver = overrideResolver;
    }

    @Inject
    public void setVarianceChecker(@NotNull VarianceChecker varianceChecker) {
        if (varianceChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varianceChecker", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setVarianceChecker"));
        }
        this.varianceChecker = varianceChecker;
    }

    @Inject
    public void setOverloadResolver(@NotNull OverloadResolver overloadResolver) {
        if (overloadResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadResolver", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setOverloadResolver"));
        }
        this.overloadResolver = overloadResolver;
    }

    @Inject
    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    @Inject
    public void setBodyResolver(@NotNull BodyResolver bodyResolver) {
        if (bodyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyResolver", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "setBodyResolver"));
        }
        this.bodyResolver = bodyResolver;
    }

    @NotNull
    public TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull Collection<? extends PsiElement> declarations, @NotNull DataFlowInfo outerDataFlowInfo) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        final TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters, outerDataFlowInfo);
        final HashMultimap<FqName, JetElement> topLevelFqNames = HashMultimap.create();
        final ArrayList<JetProperty> properties2 = new ArrayList<JetProperty>();
        final ArrayList<JetNamedFunction> functions2 = new ArrayList<JetNamedFunction>();
        for (PsiElement psiElement : declarations) {
            psiElement.accept(new JetVisitorVoid(){

                private void registerDeclarations(@NotNull List<JetDeclaration> declarations) {
                    if (declarations == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "registerDeclarations"));
                    }
                    for (JetDeclaration jetDeclaration : declarations) {
                        jetDeclaration.accept(this);
                    }
                }

                @Override
                public void visitDeclaration(@NotNull JetDeclaration dcl) {
                    if (dcl == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitDeclaration"));
                    }
                    throw new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                }

                @Override
                public void visitJetFile(@NotNull JetFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitJetFile"));
                    }
                    if (file.isScript()) {
                        JetScript script = file.getScript();
                        assert (script != null);
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.this.trace, file);
                        c.getScripts().put(script, LazyTopDownAnalyzer.this.topLevelDescriptorProvider.getScriptDescriptor(script));
                    } else {
                        JetPackageDirective packageDirective = file.getPackageDirective();
                        assert (packageDirective != null) : "No package in a non-script file: " + file;
                        c.addFile(file);
                        packageDirective.accept(this);
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.this.trace, file);
                        this.registerDeclarations(file.getDeclarations());
                        topLevelFqNames.put(file.getPackageFqName(), packageDirective);
                    }
                }

                @Override
                public void visitPackageDirective(@NotNull JetPackageDirective directive) {
                    if (directive == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitPackageDirective"));
                    }
                    DescriptorResolver.resolvePackageHeader(directive, LazyTopDownAnalyzer.this.moduleDescriptor, LazyTopDownAnalyzer.this.trace);
                }

                @Override
                public void visitImportDirective(@NotNull JetImportDirective importDirective) {
                    if (importDirective == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitImportDirective"));
                    }
                    LazyFileScope fileScope = (LazyFileScope)LazyTopDownAnalyzer.this.fileScopeProvider.getFileScope(importDirective.getContainingJetFile());
                    fileScope.forceResolveImport(importDirective);
                }

                private void visitClassOrObject(@NotNull JetClassOrObject classOrObject) {
                    if (classOrObject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitClassOrObject"));
                    }
                    ClassDescriptorWithResolutionScopes descriptor = (ClassDescriptorWithResolutionScopes)LazyTopDownAnalyzer.this.lazyDeclarationResolver.getClassDescriptor(classOrObject);
                    c.getDeclaredClasses().put(classOrObject, descriptor);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    LazyTopDownAnalyzer.registerTopLevelFqName(topLevelFqNames, classOrObject, descriptor);
                    this.checkClassOrObjectDeclarations(classOrObject, descriptor);
                }

                private void checkClassOrObjectDeclarations(JetClassOrObject classOrObject, ClassDescriptor classDescriptor) {
                    boolean companionObjectAlreadyFound = false;
                    for (JetDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                        if (jetDeclaration instanceof JetObjectDeclaration && ((JetObjectDeclaration)jetDeclaration).isCompanion()) {
                            if (companionObjectAlreadyFound) {
                                LazyTopDownAnalyzer.this.trace.report(Errors.MANY_COMPANION_OBJECTS.on((JetObjectDeclaration)jetDeclaration));
                            }
                            companionObjectAlreadyFound = true;
                            continue;
                        }
                        if (!(jetDeclaration instanceof JetSecondaryConstructor)) continue;
                        if (DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor)) {
                            LazyTopDownAnalyzer.this.trace.report(Errors.SECONDARY_CONSTRUCTOR_IN_OBJECT.on((JetSecondaryConstructor)jetDeclaration));
                            continue;
                        }
                        if (classDescriptor.getKind() != ClassKind.TRAIT) continue;
                        LazyTopDownAnalyzer.this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(jetDeclaration));
                    }
                }

                @Override
                public void visitClass(@NotNull JetClass klass) {
                    if (klass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitClass"));
                    }
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private void registerPrimaryConstructorParameters(@NotNull JetClass klass) {
                    if (klass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "registerPrimaryConstructorParameters"));
                    }
                    for (JetParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                        if (!jetParameter.hasValOrVarNode()) continue;
                        c.getPrimaryConstructorParameterProperties().put(jetParameter, (PropertyDescriptor)LazyTopDownAnalyzer.this.lazyDeclarationResolver.resolveToDescriptor(jetParameter));
                    }
                }

                @Override
                public void visitSecondaryConstructor(@NotNull JetSecondaryConstructor constructor2) {
                    if (constructor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitSecondaryConstructor"));
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)LazyTopDownAnalyzer.this.lazyDeclarationResolver.resolveToDescriptor(constructor2.getClassOrObject());
                    if (!DescriptorUtils.canHaveSecondaryConstructors(classDescriptor)) {
                        return;
                    }
                    c.getSecondaryConstructors().put(constructor2, (ConstructorDescriptor)LazyTopDownAnalyzer.this.lazyDeclarationResolver.resolveToDescriptor(constructor2));
                    LazyTopDownAnalyzer.this.registerScope(c, constructor2);
                }

                @Override
                public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
                    if (enumEntry == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitEnumEntry"));
                    }
                    this.visitClassOrObject(enumEntry);
                }

                @Override
                public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
                    if (declaration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitObjectDeclaration"));
                    }
                    this.visitClassOrObject(declaration);
                }

                @Override
                public void visitAnonymousInitializer(@NotNull JetClassInitializer initializer) {
                    if (initializer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitAnonymousInitializer"));
                    }
                    LazyTopDownAnalyzer.this.registerScope(c, initializer);
                    JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)initializer, JetClassOrObject.class);
                    c.getAnonymousInitializers().put(initializer, (ClassDescriptorWithResolutionScopes)LazyTopDownAnalyzer.this.lazyDeclarationResolver.resolveToDescriptor(classOrObject));
                }

                @Override
                public void visitTypedef(@NotNull JetTypedef typedef) {
                    if (typedef == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedef", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitTypedef"));
                    }
                    LazyTopDownAnalyzer.this.trace.report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
                }

                @Override
                public void visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration) {
                    if (multiDeclaration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitMultiDeclaration"));
                    }
                }

                @Override
                public void visitNamedFunction(@NotNull JetNamedFunction function) {
                    if (function == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitNamedFunction"));
                    }
                    functions2.add(function);
                }

                @Override
                public void visitProperty(@NotNull JetProperty property2) {
                    if (property2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer$1", "visitProperty"));
                    }
                    properties2.add(property2);
                }
            });
        }
        this.createFunctionDescriptors(c, functions2);
        this.createPropertyDescriptors(c, topLevelFqNames, properties2);
        LazyTopDownAnalyzer.resolveAllHeadersInClasses(c);
        this.declarationResolver.checkRedeclarationsInPackages(this.topLevelDescriptorProvider, topLevelFqNames);
        this.declarationResolver.checkRedeclarations(c);
        ResolveUtilPackage.checkTraitRequirements(c.getDeclaredClasses(), this.trace);
        this.overrideResolver.check(c);
        this.varianceChecker.check(c);
        this.declarationResolver.resolveAnnotationsOnFiles(c, this.fileScopeProvider);
        this.overloadResolver.process(c);
        this.bodyResolver.resolveBodies(c);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        return topDownAnalysisContext;
    }

    private static void resolveAllHeadersInClasses(TopDownAnalysisContext c) {
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getAllClasses()) {
            ((LazyClassDescriptor)classDescriptor).resolveMemberHeaders();
        }
    }

    private void createPropertyDescriptors(TopDownAnalysisContext c, Multimap<FqName, JetElement> topLevelFqNames, List<JetProperty> properties2) {
        for (JetProperty property2 : properties2) {
            PropertyDescriptor descriptor = (PropertyDescriptor)this.lazyDeclarationResolver.resolveToDescriptor(property2);
            c.getProperties().put(property2, descriptor);
            LazyTopDownAnalyzer.registerTopLevelFqName(topLevelFqNames, property2, descriptor);
            this.registerScope(c, property2);
            this.registerScope(c, property2.getGetter());
            this.registerScope(c, property2.getSetter());
        }
    }

    private void createFunctionDescriptors(TopDownAnalysisContext c, List<JetNamedFunction> functions2) {
        for (JetNamedFunction function : functions2) {
            c.getFunctions().put(function, (SimpleFunctionDescriptor)this.lazyDeclarationResolver.resolveToDescriptor(function));
            this.registerScope(c, function);
        }
    }

    private void registerScope(@NotNull TopDownAnalysisContext c, @Nullable JetDeclaration declaration) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "registerScope"));
        }
        if (declaration == null) {
            return;
        }
        c.registerDeclaringScope(declaration, this.declarationScopeProvider.getResolutionScopeForDeclaration(declaration));
    }

    private static void registerTopLevelFqName(@NotNull Multimap<FqName, JetElement> topLevelFqNames, @NotNull JetNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
        FqName fqName2;
        if (topLevelFqNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelFqNames", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "registerTopLevelFqName"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "registerTopLevelFqName"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzer", "registerTopLevelFqName"));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor) && (fqName2 = declaration.getFqName()) != null) {
            topLevelFqNames.put(fqName2, declaration);
        }
    }
}

