/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage$callUtil$7f7cb59d;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"%\b)I2)\u00199ukJLgnZ%o\u00072|7/\u001e:f\u0007\",7m[3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\tG\",7m[3sg*Y1)\u00197m\u0007\",7m[3s\u0015\u0019a\u0014N\\5u})\taI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$(bF2iK\u000e\\7)\u00199ukJLgnZ%o\u00072|7/\u001e:f\u0015!1\u0018M]5bE2,'B\u0005,be&\f'\r\\3EKN\u001c'/\u001b9u_JTQ\u0001\u001e:bG\u0016TABQ5oI&tw\r\u0016:bG\u0016TQa]2pa\u0016T\u0001BS3u'\u000e|\u0007/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b%%\u001c8)\u00199ukJ,G-\u00138J]2Lg.\u001a\u0006\u000f\u0005&tG-\u001b8h\u0007>tG/\u001a=u\u00159\u00198m\u001c9f\u0007>tG/Y5oKJTQ\u0003R3dY\u0006\u0014\u0018\r^5p]\u0012+7o\u0019:jaR|'O\u0003\bwCJL\u0017M\u00197f!\u0006\u0014XM\u001c;\u000b\u000f\t{w\u000e\\3b]\"\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0006!\u001dA\u0002A\u0003\u0003\t\u0005AY!B\u0002\u0005\t!)A\u0002A\u0003\u0003\t\tAy!B\u0002\u0005\u000b!9A\u0002A\u0003\u0003\t\tA\u0001\"B\u0002\u0005\r!EA\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0004\t\u00131\u0001QA\u0001\u0003\u0006\u0011\u001d)!\u0001\u0002\u0004\t\u0012\u0015\u0019A\u0001\u0002E\u000b\u0019\u0001)1\u0001b\u0001\t\u00181\u0001QA\u0001C\u0002\u00115)1\u0001\u0002\u0006\t\u001a1\u0001QA\u0001\u0003\u0005\u0011+)!\u0001b\u0001\t\u0018\u0015\u0011AA\u0003E\r\u000b\r!\u0019\u0001\u0003\b\r\u0001\u0015\u0019A\u0001\u0002\u0005\u0010\u0019\u0001)1\u0001B\u0004\t!1\u0001QA\u0001C\u0002\u00119)!\u0001\u0002\u0003\t\u001f\u0011\u0001AbA\r\u0003\u000b\u0005A9!l\u0014\u0005\u0017E)A\u0001\u0001E\u0005+\t)\u0011\u0001#\u0003\u0019\ru]A\u0001\u0001E\u0007\u001b\u001d)\u0011\u0001c\u0003\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001AO\u0007\t\u0001A\u0001\"\u0004\u0002\u0006\u0003!5\u0001k!\u0001\"\u0005\u0015\t\u0001rB)\u0004\u000f\u00111\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"D\u0001\t\u001252C!\u0001M\n;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0001u5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001c\u0005Q\u0007\u0003ij\u0001\u0002\u0001\t\u00195\u0011Q!\u0001E\u000b!\u000e\t\u0011EA\u0003\u0002\u0011\u001f\t6!\u0003C\n\u0013\u0005!\u0001!D\u0001\t\u00175\t\u0001rC\u0007\u0002\u00111ic\u0005B\u0001\u0019\u001cu5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001#\u0007Q\u0007\u0001ij\u0001\u0002\u0001\t\u001e5\u0011Q!\u0001\u0005\u000e!\u000e\u0005QT\u0002\u0003\u0001\u0011?i!!B\u0001\t\u001bA\u001b\u0011!\t\u0002\u0006\u0003!m\u0011kA\u0005\u0005\u001c%\tA\u0011A\u0007\u0002\u00119i\u0011\u0001#\b\u000e\u0003!uQgC\u0003\u000b\t\r\b\u0001\u0004B\u0011\u0003\u000b\u0005A1!U\u0002\u0004\t\u0011I\u0011\u0001\u0002\u0001"})
public final class CapturingInClosureChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(CapturingInClosureChecker.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<F> resolvedCall, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<F> variableResolvedCall = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall() : resolvedCall;
        F f = variableResolvedCall.getResultingDescriptor();
        if (!(f instanceof VariableDescriptor)) {
            f = null;
        }
        if ((variableDescriptor = (VariableDescriptor)f) != null) {
            BindingTrace bindingTrace = ((ResolutionContext)context2).trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            JetScope jetScope = ((ResolutionContext)context2).scope;
            Intrinsics.checkExpressionValueIsNotNull(jetScope, "context.scope");
            this.checkCapturingInClosure(variableDescriptor, bindingTrace, jetScope);
        }
    }

    private final void checkCapturingInClosure(@JetValueParameter(name="variable") VariableDescriptor variable, @JetValueParameter(name="trace") BindingTrace trace, @JetValueParameter(name="scope") JetScope scope2) {
        DeclarationDescriptor variableParent = variable.getContainingDeclaration();
        DeclarationDescriptor scopeContainer = scope2.getContainingDeclaration();
        if ((Intrinsics.areEqual(scopeContainer, variableParent) ^ true ? variableParent instanceof CallableDescriptor : false) && Intrinsics.areEqual((Object)((CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable))), (Object)CaptureKind.NOT_INLINE) ^ true) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            boolean inline2 = this.isCapturedInInline(bindingContext, scopeContainer, variableParent);
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline2 ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
        }
    }

    private final boolean isCapturedInInline(@JetValueParameter(name="context") BindingContext context2, @JetValueParameter(name="scopeContainer") DeclarationDescriptor scopeContainer, @JetValueParameter(name="variableParent") DeclarationDescriptor variableParent) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!(scopeDeclaration instanceof JetFunctionLiteral)) {
            return false;
        }
        PsiElement parent = ((JetFunctionLiteral)scopeDeclaration).getParent();
        boolean bl = parent instanceof JetFunctionLiteralExpression;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "parent of JetFunctionLiteral is " + parent;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PsiElement psiElement = parent;
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetFunctionLiteralExpression");
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$7f7cb59d.getParentResolvedCall((JetFunctionLiteralExpression)psiElement, context2, true);
        if (resolvedCall == null) {
            return false;
        }
        CallableDescriptor callable2 = resolvedCall.getResultingDescriptor();
        if (callable2 instanceof SimpleFunctionDescriptor ? ((SimpleFunctionDescriptor)callable2).getInlineStrategy().isInline() : false) {
            boolean bl2;
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            boolean bl3 = scopeContainerParent != null;
            if (KotlinPackage.getASSERTIONS_ENABLED() && !bl3) {
                String string = "parent is null for " + scopeContainer;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!Intrinsics.areEqual(scopeContainerParent, variableParent)) {
                DeclarationDescriptor declarationDescriptor = scopeContainerParent;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "scopeContainerParent");
                bl2 = this.isCapturedInInline(context2, declarationDescriptor, variableParent);
            } else {
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }
}

