/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.core.CoreJavaFileManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

public class KotlinJavaPsiFacade {
    private volatile KotlinPsiElementFinderWrapper[] elementFinders;
    private volatile SoftReference<PackageCache> packageCache;
    private final Project project;

    public static KotlinJavaPsiFacade getInstance(Project project) {
        return ServiceManager.getService(project, KotlinJavaPsiFacade.class);
    }

    public KotlinJavaPsiFacade(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "<init>"));
        }
        this.project = project;
        final PsiModificationTracker modificationTracker2 = PsiManager.getInstance(project).getModificationTracker();
        MessageBus bus = project.getMessageBus();
        bus.connect().subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            @Override
            public void modificationCountChanged() {
                long now = modificationTracker2.getJavaStructureModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    KotlinJavaPsiFacade.this.packageCache = null;
                }
            }
        });
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClass"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClass"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName, scope2);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            PsiClass aClass = finder.findClass(qualifiedName, scope2);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
        }
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName, scope2);
        String className = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope2);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
        }
        return psiClassArray;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] finders() {
        KotlinPsiElementFinderWrapper[] answer = this.elementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.elementFinders = answer;
        }
        if (answer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "finders"));
        }
        return answer;
    }

    @NotNull
    protected KotlinPsiElementFinderWrapper[] calcFinders() {
        ArrayList<KotlinPsiElementFinderWrapper> elementFinders = new ArrayList<KotlinPsiElementFinderWrapper>();
        elementFinders.add(new KotlinPsiElementFinderImpl(this.getProject()));
        List<PsiElementFinder> nonKotlinFinders = KotlinPackage.filter(this.getProject().getExtensions(PsiElementFinder.EP_NAME), new Function1<PsiElementFinder, Boolean>(){

            @Override
            public Boolean invoke(PsiElementFinder finder) {
                return !(finder instanceof NonClasspathClassFinder) && !(finder instanceof KotlinFinderMarker) && !(finder instanceof PsiElementFinderImpl);
            }
        });
        elementFinders.addAll(KotlinPackage.map(nonKotlinFinders, new Function1<PsiElementFinder, KotlinPsiElementFinderWrapper>(){

            @Override
            public KotlinPsiElementFinderWrapper invoke(PsiElementFinder finder) {
                return KotlinJavaPsiFacade.wrap(finder);
            }
        }));
        KotlinPsiElementFinderWrapper[] kotlinPsiElementFinderWrapperArray = elementFinders.toArray(new KotlinPsiElementFinderWrapper[elementFinders.size()]);
        if (kotlinPsiElementFinderWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "calcFinders"));
        }
        return kotlinPsiElementFinderWrapperArray;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName, GlobalSearchScope searchScope) {
        Pair<String, GlobalSearchScope> key;
        PsiPackage aPackage;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findPackage"));
        }
        PackageCache cache2 = SoftReference.dereference(this.packageCache);
        if (cache2 == null) {
            cache2 = new PackageCache();
            this.packageCache = new SoftReference<PackageCache>(cache2);
        }
        if ((aPackage = (PsiPackage)cache2.packageInScopeCache.get(key = new Pair<String, GlobalSearchScope>(qualifiedName, searchScope))) != null) {
            return aPackage;
        }
        KotlinPsiElementFinderWrapper[] finders = this.filteredFinders();
        Boolean packageFoundInAllScope = (Boolean)cache2.hasPackageInAllScopeCache.get(qualifiedName);
        if (packageFoundInAllScope != null) {
            if (!packageFoundInAllScope.booleanValue()) {
                return null;
            }
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, searchScope)) == null) continue;
                return ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, key, aPackage);
            }
        } else {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                aPackage = finder.findPackage(qualifiedName, searchScope);
                if (aPackage == null) continue;
                return ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, key, aPackage);
            }
            boolean found = false;
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, GlobalSearchScope.allScope(this.project))) == null) continue;
                found = true;
                break;
            }
            cache2.hasPackageInAllScopeCache.put(qualifiedName, found);
        }
        return null;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (dumbService.isDumb()) {
            List<KotlinPsiElementFinderWrapper> list = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list.toArray(new KotlinPsiElementFinderWrapper[list.size()]);
        }
        if (finders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "filteredFinders"));
        }
        return finders;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "getProject"));
        }
        return project;
    }

    public static KotlinPsiElementFinderWrapper wrap(PsiElementFinder finder) {
        return finder instanceof DumbAware ? new KotlinPsiElementFinderWrapperImplDumbAware(finder) : new KotlinPsiElementFinderWrapperImpl(finder);
    }

    static class KotlinPsiElementFinderImpl
    implements DumbAware,
    KotlinPsiElementFinderWrapper {
        private final JavaFileManager javaFileManager;
        private final boolean isCoreJavaFileManager;
        private final PsiManager psiManager;
        private final PackageIndex packageIndex;

        public KotlinPsiElementFinderImpl(Project project) {
            this.javaFileManager = KotlinPsiElementFinderImpl.findJavaFileManager(project);
            this.isCoreJavaFileManager = this.javaFileManager instanceof CoreJavaFileManager;
            this.packageIndex = PackageIndex.getInstance(project);
            this.psiManager = PsiManager.getInstance(project);
        }

        @NotNull
        private static JavaFileManager findJavaFileManager(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findJavaFileManager"));
            }
            JavaFileManager javaFileManager = ServiceManager.getService(project, JavaFileManager.class);
            if (javaFileManager == null) {
                throw new IllegalStateException("JavaFileManager component is not found in project");
            }
            JavaFileManager javaFileManager2 = javaFileManager;
            if (javaFileManager2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findJavaFileManager"));
            }
            return javaFileManager2;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findClass"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findClass"));
            }
            PsiClass aClass = this.javaFileManager.findClass(qualifiedName, scope2);
            if (aClass != null && (!this.isCoreJavaFileManager || scope2.contains(aClass.getContainingFile().getOriginalFile().getVirtualFile()))) {
                return aClass;
            }
            return null;
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findPackage"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findPackage"));
            }
            if (this.isCoreJavaFileManager) {
                return this.javaFileManager.findPackage(qualifiedName);
            }
            Query<VirtualFile> dirs = this.packageIndex.getDirsByPackageName(qualifiedName, true);
            return KotlinPsiElementFinderImpl.hasDirectoriesInScope(dirs, scope2) ? new PsiPackageImpl(this.psiManager, qualifiedName) : null;
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static boolean hasDirectoriesInScope(Query<VirtualFile> dirs, final GlobalSearchScope scope2) {
            CommonProcessors.FindProcessor<VirtualFile> findProcessor = new CommonProcessors.FindProcessor<VirtualFile>(){

                @Override
                protected boolean accept(VirtualFile file) {
                    return scope2.accept(file);
                }
            };
            dirs.forEach((Processor<VirtualFile>)findProcessor);
            return findProcessor.isFound();
        }
    }

    private static class KotlinPsiElementFinderWrapperImplDumbAware
    extends KotlinPsiElementFinderWrapperImpl
    implements DumbAware {
        private KotlinPsiElementFinderWrapperImplDumbAware(PsiElementFinder finder) {
            super(finder);
        }
    }

    private static class KotlinPsiElementFinderWrapperImpl
    implements KotlinPsiElementFinderWrapper {
        private final PsiElementFinder finder;

        private KotlinPsiElementFinderWrapperImpl(@NotNull PsiElementFinder finder) {
            if (finder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "<init>"));
            }
            this.finder = finder;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findClass"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findClass"));
            }
            return this.finder.findClass(qualifiedName, scope2);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findPackage"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findPackage"));
            }
            return this.finder.findPackage(qualifiedName);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return true;
        }

        public String toString() {
            return this.finder.toString();
        }
    }

    static interface KotlinPsiElementFinderWrapper {
        public PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiPackage findPackage(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public boolean isSameResultForAnyScope();
    }

    private static class PackageCache {
        final ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> packageInScopeCache = ContainerUtil.newConcurrentMap();
        final ConcurrentMap<String, Boolean> hasPackageInAllScopeCache = ContainerUtil.newConcurrentMap();

        private PackageCache() {
        }
    }
}

