/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;
import org.jetbrains.kotlin.utils.KotlinFrontEndException;

public class ExpressionTypingVisitorDispatcher
extends JetVisitor<JetTypeInfo, ExpressionTypingContext>
implements ExpressionTypingInternals {
    private final ExpressionTypingComponents components;
    private final BasicExpressionTypingVisitor basic;
    private final ExpressionTypingVisitorForStatements statements;
    private final FunctionsTypingVisitor functions;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;

    @NotNull
    public static ExpressionTypingFacade create(@NotNull ExpressionTypingComponents components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "create"));
        }
        ExpressionTypingVisitorDispatcher expressionTypingVisitorDispatcher = new ExpressionTypingVisitorDispatcher(components, null);
        if (expressionTypingVisitorDispatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "create"));
        }
        return expressionTypingVisitorDispatcher;
    }

    @NotNull
    public static ExpressionTypingInternals createForBlock(@NotNull ExpressionTypingComponents components, @NotNull WritableScope writableScope) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        if (writableScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        ExpressionTypingVisitorDispatcher expressionTypingVisitorDispatcher = new ExpressionTypingVisitorDispatcher(components, writableScope);
        if (expressionTypingVisitorDispatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        return expressionTypingVisitorDispatcher;
    }

    private ExpressionTypingVisitorDispatcher(@NotNull ExpressionTypingComponents components, WritableScope writableScope) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "<init>"));
        }
        this.components = components;
        this.basic = new BasicExpressionTypingVisitor(this);
        this.controlStructures = new ControlStructureTypingVisitor(this);
        this.patterns = new PatternMatchingTypingVisitor(this);
        this.functions = new FunctionsTypingVisitor(this);
        this.statements = writableScope != null ? new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns, this.functions) : null;
    }

    @Override
    @NotNull
    public ExpressionTypingComponents getComponents() {
        ExpressionTypingComponents expressionTypingComponents = this.components;
        if (expressionTypingComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getComponents"));
        }
        return expressionTypingComponents;
    }

    @Override
    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable JetExpression right, @NotNull ExpressionTypingContext context2) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        JetTypeInfo jetTypeInfo = this.basic.checkInExpression(callElement, operationSign, leftArgument, right, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo safeGetTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getTypeInfo(expression, context2);
        if (typeInfo.getType() != null) {
            JetTypeInfo jetTypeInfo = typeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(ErrorUtils.createErrorType("Type for " + expression.getText()), context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2, this);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        if (!isStatement) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (this.statements != null) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2, this.statements);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2, this.createStatementVisitor(context2));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    private ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context2) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context2, "statement scope"), this.basic, this.controlStructures, this.patterns, this.functions);
    }

    @Override
    public void checkStatementType(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkStatementType"));
        }
        expression.accept(this.createStatementVisitor(context2), context2);
    }

    @NotNull
    private JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2, JetVisitor<JetTypeInfo, ExpressionTypingContext> visitor2) {
        JetTypeInfo jetTypeInfo;
        JetTypeInfo result2;
        block15: {
            block14: {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
                }
                JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context2.trace.getBindingContext());
                if (recordedTypeInfo == null) break block14;
                JetTypeInfo jetTypeInfo2 = recordedTypeInfo;
                if (jetTypeInfo2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
                }
                return jetTypeInfo2;
            }
            result2 = expression.accept(visitor2, context2);
            if (!context2.trace.get(BindingContext.PROCESSED, expression).booleanValue()) break block15;
            JetTypeInfo jetTypeInfo3 = JetTypeInfo.create(context2.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression), result2.getDataFlowInfo());
            if (jetTypeInfo3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo3;
        }
        try {
            try {
                if (result2.getType() instanceof DeferredType) {
                    result2 = JetTypeInfo.create(((DeferredType)result2.getType()).getDelegate(), result2.getDataFlowInfo());
                }
                if (result2.getType() != null) {
                    context2.trace.record(BindingContext.EXPRESSION_TYPE, expression, result2.getType());
                }
            }
            catch (ReenteringLazyValueComputationException e) {
                context2.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
                result2 = JetTypeInfo.create(null, context2.dataFlowInfo);
            }
            context2.trace.record(BindingContext.PROCESSED, expression);
            BindingContextUtilPackage.recordScopeAndDataFlowInfo(context2.replaceDataFlowInfo(result2.getDataFlowInfo()), expression);
            jetTypeInfo = result2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (KotlinFrontEndException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new KotlinFrontEndException("Exception while analyzing expression at " + DiagnosticUtils.atLocation(expression) + ":\n" + expression.getText() + "\n", e);
        }
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitFunctionLiteralExpression"));
        }
        return expression.accept(this.functions, data2);
    }

    @Override
    public JetTypeInfo visitNamedFunction(@NotNull JetNamedFunction function, ExpressionTypingContext data2) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitNamedFunction"));
        }
        return function.accept(this.functions, data2);
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitThrowExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitReturnExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitContinueExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitIfExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitTryExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitForExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhileExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitDoWhileExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitBreakExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitIsExpression(@NotNull JetIsExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitIsExpression"));
        }
        return expression.accept(this.patterns, data2);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhenExpression"));
        }
        return expression.accept(this.patterns, data2);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitJetElement"));
        }
        return element.accept(this.basic, data2);
    }
}

