/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAnchor {
    @Nullable
    public abstract PsiElement retrieve();

    public abstract PsiFile getFile();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public static PsiAnchor create(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiAnchor", "create"));
        }
        if (!element.isValid()) {
            throw new PsiInvalidElementAccessException(element);
        }
        if (element instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            if (virtualFile != null) {
                return new PsiFileReference(virtualFile, (PsiFile)element);
            }
            return new HardReference(element);
        }
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            return new PsiDirectoryReference(virtualFile, element.getProject());
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return new HardReference(element);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return new HardReference(element);
        }
        StubIndexReference stubRef = PsiAnchor.createStubReference(element, file);
        if (stubRef != null) {
            return stubRef;
        }
        if (!element.isPhysical() && element instanceof PsiCompiledElement || element instanceof LightElement) {
            return new HardReference(element);
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return new HardReference(element);
        }
        Language lang = null;
        FileViewProvider viewProvider = file.getViewProvider();
        Set<Language> languages = viewProvider.getLanguages();
        for (Language l : languages) {
            if (!PsiTreeUtil.isAncestor(viewProvider.getPsi(l), element, false)) continue;
            lang = l;
            break;
        }
        if (lang == null) {
            lang = element.getLanguage();
        }
        return new TreeRangeReference(file, textRange.getStartOffset(), textRange.getEndOffset(), element.getClass(), lang, virtualFile);
    }

    @Nullable
    public static StubIndexReference createStubReference(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiAnchor", "createStubReference"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/PsiAnchor", "createStubReference"));
        }
        if (element instanceof StubBasedPsiElement && element.isPhysical() && (element instanceof PsiCompiledElement || PsiAnchor.canHaveStub(containingFile))) {
            int index2;
            StubBasedPsiElement elt = (StubBasedPsiElement)element;
            IStubElementType elementType = elt.getElementType();
            if ((elt.getStub() != null || elementType.shouldCreateStub(element.getNode())) && (index2 = PsiAnchor.calcStubIndex((StubBasedPsiElement)element)) != -1) {
                return new StubIndexReference(containingFile, index2, containingFile.getLanguage(), elementType);
            }
        }
        return null;
    }

    private static boolean canHaveStub(PsiFile file) {
        if (!(file instanceof PsiFileImpl)) {
            return false;
        }
        VirtualFile vFile = file.getVirtualFile();
        IElementType elementType = ((PsiFileImpl)file).getContentElementType();
        return elementType instanceof IStubFileElementType && vFile != null && ((IStubFileElementType)elementType).shouldBuildStubFor(vFile);
    }

    public static int calcStubIndex(StubBasedPsiElement psi) {
        if (psi instanceof PsiFile) {
            return 0;
        }
        Object liveStub = psi.getStub();
        if (liveStub != null) {
            return ((StubBase)liveStub).id;
        }
        PsiFileImpl file = (PsiFileImpl)psi.getContainingFile();
        StubTree stubTree = file.calcStubTree();
        for (StubElement stb : stubTree.getPlainList()) {
            if (stb.getPsi() != psi) continue;
            return ((StubBase)stb).id;
        }
        return -1;
    }

    @Nullable
    public static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index2, @NotNull IStubElementType elementType, boolean throwIfNull) {
        List list;
        boolean foreign;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/PsiAnchor", "restoreFromStubIndex"));
        }
        if (fileImpl == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)"Null file");
            }
            return null;
        }
        StubTree tree = fileImpl.getStubTree();
        boolean bl = foreign = tree == null;
        if (foreign) {
            if (fileImpl instanceof PsiFileImpl) {
                tree = ((PsiFileImpl)fileImpl).calcStubTree();
            } else {
                if (throwIfNull) {
                    throw new AssertionError((Object)("Not PsiFileImpl: " + fileImpl.getClass()));
                }
                return null;
            }
        }
        if (index2 >= (list = tree.getPlainList()).size()) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Too large index: " + index2 + ">=" + list.size()));
            }
            return null;
        }
        StubElement stub = (StubElement)list.get(index2);
        if (stub.getStubType() != elementType) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Element type mismatch: " + stub.getStubType() + "!=" + elementType));
            }
            return null;
        }
        if (foreign) {
            Object cachedPsi = ((StubBase)stub).getCachedPsi();
            if (cachedPsi != null) {
                return cachedPsi;
            }
            ASTNode ast = fileImpl.findTreeForStub(tree, stub);
            if (ast != null) {
                return ast.getPsi();
            }
            if (throwIfNull) {
                throw new AssertionError((Object)"No AST for stub");
            }
            return null;
        }
        return stub.getPsi();
    }

    public static class StubIndexReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final int myIndex;
        private final Language myLanguage;
        private final IStubElementType myElementType;
        private final long myCreationModCount;

        public StubIndexReference(@NotNull PsiFile file, int index2, @NotNull Language language, IStubElementType elementType) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/PsiAnchor$StubIndexReference", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/PsiAnchor$StubIndexReference", "<init>"));
            }
            this.myLanguage = language;
            this.myElementType = elementType;
            this.myVirtualFile = file.getVirtualFile();
            this.myProject = file.getProject();
            this.myIndex = index2;
            this.myCreationModCount = file.getManager().getModificationTracker().getModificationCount();
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            if (this.myProject.isDisposed() || !this.myVirtualFile.isValid()) {
                return null;
            }
            PsiFile file = PsiManager.getInstance(this.myProject).findFile(this.myVirtualFile);
            if (file == null) {
                return null;
            }
            if (file.getLanguage() == this.myLanguage) {
                return file;
            }
            return file.getViewProvider().getPsi(this.myLanguage);
        }

        @Override
        public PsiElement retrieve() {
            return (PsiElement)ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiElement>(){

                public PsiElement compute() {
                    return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)StubIndexReference.this.getFile(), StubIndexReference.this.myIndex, StubIndexReference.this.myElementType, false);
                }
            });
        }

        public String diagnoseNull() {
            try {
                PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiElement>(){

                    public PsiElement compute() {
                        return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)StubIndexReference.this.getFile(), StubIndexReference.this.myIndex, StubIndexReference.this.myElementType, true);
                    }
                });
                return "No diagnostics, element=" + element + "@" + (element == null ? 0 : System.identityHashCode(element));
            }
            catch (AssertionError e) {
                return ((Throwable)((Object)e)).getMessage() + "; current modCount=" + PsiManager.getInstance(this.getProject()).getModificationTracker().getModificationCount() + "; creation modCount=" + this.myCreationModCount;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StubIndexReference)) {
                return false;
            }
            StubIndexReference that = (StubIndexReference)o;
            return this.myIndex == that.myIndex && this.myVirtualFile.equals(that.myVirtualFile) && Comparing.equal(this.myElementType, that.myElementType) && this.myLanguage == that.myLanguage;
        }

        public int hashCode() {
            return ((31 * this.myVirtualFile.hashCode() + this.myIndex) * 31 + (this.myElementType == null ? 0 : this.myElementType.hashCode())) * 31 + this.myLanguage.hashCode();
        }

        @NonNls
        public String toString() {
            return "StubIndexReference{myVirtualFile=" + this.myVirtualFile + ", myProject=" + this.myProject + ", myIndex=" + this.myIndex + ", myLanguage=" + this.myLanguage + ", itemType=" + this.myElementType + '}';
        }

        @Override
        public int getStartOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType.toString() + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType.toString() + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getEndOffset();
        }

        public VirtualFile getVirtualFile() {
            return this.myVirtualFile;
        }

        public Project getProject() {
            return this.myProject;
        }
    }

    private static class PsiDirectoryReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;

        private PsiDirectoryReference(@NotNull VirtualFile file, @NotNull Project project) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/PsiAnchor$PsiDirectoryReference", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/PsiAnchor$PsiDirectoryReference", "<init>"));
            }
            this.myFile = file;
            this.myProject = project;
            assert (file.isDirectory()) : file;
        }

        @Override
        public PsiElement retrieve() {
            return SelfElementInfo.restoreDirectoryFromVirtual(this.myFile, this.myProject);
        }

        @Override
        public PsiFile getFile() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiDirectoryReference)) {
                return false;
            }
            PsiDirectoryReference reference = (PsiDirectoryReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }
    }

    private static class PsiFileReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;
        @NotNull
        private final Language myLanguage;

        private PsiFileReference(@NotNull VirtualFile file, @NotNull PsiFile psiFile) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/PsiAnchor$PsiFileReference", "<init>"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/PsiAnchor$PsiFileReference", "<init>"));
            }
            this.myFile = file;
            this.myProject = psiFile.getProject();
            this.myLanguage = PsiFileReference.findLanguage(psiFile);
        }

        private static Language findLanguage(PsiFile file) {
            FileViewProvider vp = file.getViewProvider();
            Set<Language> languages = vp.getLanguages();
            for (Language language : languages) {
                if (!file.equals(vp.getPsi(language))) continue;
                return language;
            }
            throw new AssertionError((Object)("Non-retrievable file: " + file.getClass() + "; " + file.getLanguage() + "; " + languages));
        }

        @Override
        public PsiElement retrieve() {
            return this.getFile();
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myFile, this.myProject, this.myLanguage);
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return (int)this.myFile.getLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiFileReference)) {
                return false;
            }
            PsiFileReference reference = (PsiFileReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            if (!this.myLanguage.equals(reference.myLanguage)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myLanguage.hashCode();
        }
    }

    public static class HardReference
    extends PsiAnchor {
        private final PsiElement myElement;

        public HardReference(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiElement retrieve() {
            return this.myElement;
        }

        @Override
        public PsiFile getFile() {
            return this.myElement.getContainingFile();
        }

        @Override
        public int getStartOffset() {
            return this.myElement.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myElement.getTextRange().getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HardReference)) {
                return false;
            }
            HardReference that = (HardReference)o;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }
    }

    private static class TreeRangeReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final Language myLanguage;
        private final Language myFileLanguage;
        private final int myStartOffset;
        private final int myEndOffset;
        private final Class myClass;

        private TreeRangeReference(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class aClass, @NotNull Language language, @NotNull VirtualFile virtualFile) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            this.myVirtualFile = virtualFile;
            this.myProject = file.getProject();
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myClass = aClass;
            this.myLanguage = language;
            this.myFileLanguage = file.getLanguage();
        }

        @Override
        @Nullable
        public PsiElement retrieve() {
            PsiFile psiFile = this.getFile();
            if (psiFile == null || !psiFile.isValid()) {
                return null;
            }
            PsiElement element = psiFile.getViewProvider().findElementAt(this.myStartOffset, this.myLanguage);
            if (element == null) {
                return null;
            }
            while (!element.getClass().equals(this.myClass) || element.getTextRange().getStartOffset() != this.myStartOffset || element.getTextRange().getEndOffset() != this.myEndOffset) {
                if ((element = element.getParent()) != null && element.getTextRange() != null) continue;
                return null;
            }
            return element;
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myFileLanguage);
        }

        @Override
        public int getStartOffset() {
            return this.myStartOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TreeRangeReference)) {
                return false;
            }
            TreeRangeReference that = (TreeRangeReference)o;
            return this.myEndOffset == that.myEndOffset && this.myStartOffset == that.myStartOffset && this.myClass.equals(that.myClass) && this.myVirtualFile.equals(that.myVirtualFile);
        }

        public int hashCode() {
            int result2 = this.myClass.getName().hashCode();
            result2 = 31 * result2 + this.myStartOffset;
            result2 = 31 * result2 + this.myEndOffset;
            result2 = 31 * result2 + this.myVirtualFile.hashCode();
            return result2;
        }
    }
}

