/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        @Override
        public int computeHashCode(PsiTypeParameter object) {
            String name = object.getName();
            return name == null ? 0 : name.hashCode();
        }

        @Override
        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent(element1, element2);
        }
    };
    private final Map<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor myAddingBoundsSubstitutionVisitor;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this.myAddingBoundsSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.ADD_BOUNDS);
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.SIMPLE);
        this.mySubstitutionMap = new THashMap<PsiTypeParameter, PsiType>(map, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl() {
        this.myAddingBoundsSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.ADD_BOUNDS);
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.SIMPLE);
        this.mySubstitutionMap = new THashMap<PsiTypeParameter, PsiType>(2, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this();
        this.mySubstitutionMap.put(typeParameter, mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this();
        this.putAllInternal(parentClass, mappings);
    }

    @Override
    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "substitute"));
        }
        if (this.containsInMap(typeParameter)) {
            return this.getFromMap(typeParameter);
        }
        return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter);
    }

    private boolean containsInMap(PsiTypeParameter typeParameter) {
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.containsKey(typeParameter);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "getFromMap"));
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.get(typeParameter);
    }

    @Override
    public PsiType substitute(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        PsiUtil.ensureValidType(type2);
        PsiType substituted = type2.accept(this.myAddingBoundsSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type2);
    }

    @Override
    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "substituteWithBoundsPromotion"));
        }
        return this.addBounds(this.substitute(typeParameter), typeParameter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSubstitutorImpl)) {
            return false;
        }
        PsiSubstitutorImpl that = (PsiSubstitutorImpl)o;
        return !(this.mySubstitutionMap != null ? !((Object)this.mySubstitutionMap).equals(that.mySubstitutionMap) : that.mySubstitutionMap != null);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? ((Object)this.mySubstitutionMap).hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
        if (extendsTypes.length > 0) {
            return this.substitute(extendsTypes[0]);
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private PsiType addBounds(PsiType substituted, @NotNull PsiTypeParameter typeParameter) {
        PsiType erasure;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "addBounds"));
        }
        PsiType oldSubstituted = substituted;
        PsiElement captureContext = null;
        if (substituted instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType captured = (PsiCapturedWildcardType)substituted;
            substituted = captured.getWildcard();
            captureContext = captured.getContext();
        }
        if (substituted instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiClassType[] boundTypes;
            PsiType originalBound = ((PsiWildcardType)substituted).getBound();
            PsiManager manager = typeParameter.getManager();
            for (PsiClassType boundType : boundTypes = typeParameter.getExtendsListTypes()) {
                PsiType substitutedBoundType = ((PsiType)boundType).accept(this.mySimpleSubstitutionVisitor);
                PsiWildcardType wildcardType = (PsiWildcardType)substituted;
                if (substitutedBoundType == null || substitutedBoundType instanceof PsiWildcardType || substitutedBoundType.equalsToText("java.lang.Object") || originalBound != null && (TypeConversionUtil.erasure(substitutedBoundType).isAssignableFrom(TypeConversionUtil.erasure(originalBound)) || TypeConversionUtil.erasure(substitutedBoundType).isAssignableFrom(originalBound))) continue;
                if (wildcardType.isExtends()) {
                    PsiType glb;
                    PsiType bound = wildcardType.getBound();
                    if (bound instanceof PsiArrayType && substitutedBoundType instanceof PsiArrayType && !bound.isAssignableFrom(substitutedBoundType) && !substitutedBoundType.isAssignableFrom(bound) || (glb = GenericsUtil.getGreatestLowerBound(bound, substitutedBoundType)) == null) continue;
                    substituted = PsiWildcardType.createExtends(manager, glb);
                    continue;
                }
                substituted = substitutedBoundType instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)substitutedBoundType).getWildcard() : PsiWildcardType.createExtends(manager, substitutedBoundType);
            }
        } else if (substituted instanceof PsiWildcardType && ((PsiWildcardType)substituted).isSuper() && !(oldSubstituted instanceof PsiCapturedWildcardType) && (erasure = TypeConversionUtil.erasure(((PsiWildcardType)substituted).getBound())) != null) {
            PsiClassType[] boundTypes;
            for (PsiClassType boundType : boundTypes = typeParameter.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(erasure, boundType)) continue;
                return ((PsiType)boundType).accept(this.mySimpleSubstitutionVisitor);
            }
        }
        if (captureContext != null) {
            substituted = oldSubstituted instanceof PsiCapturedWildcardType && substituted == ((PsiCapturedWildcardType)oldSubstituted).getWildcard() ? oldSubstituted : PsiCapturedWildcardType.create((PsiWildcardType)substituted, captureContext, typeParameter);
        }
        return substituted;
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/PsiSubstitutorImpl", "correctExternalSubstitution"));
        }
        if (substituted != null) {
            return substituted;
        }
        return original.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType(arrayType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType(ellipsisType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory().createType(aClass);
            }

            @Override
            public PsiType visitType(PsiType type2) {
                LOG.error(type2.getInternalCanonicalText());
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        return new PsiSubstitutorImpl(this.mySubstitutionMap);
    }

    @Override
    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "put"));
        }
        PsiSubstitutorImpl ret = this.clone();
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        ret.mySubstitutionMap.put(typeParameter, mapping);
        PsiSubstitutorImpl psiSubstitutorImpl = ret;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "put"));
        }
        return psiSubstitutorImpl;
    }

    private void putAllInternal(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAllInternal"));
        }
        PsiTypeParameter[] params = parentClass.getTypeParameters();
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                this.mySubstitutionMap.put(param, mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            this.mySubstitutionMap.put(param, null);
        }
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        PsiSubstitutorImpl substitutor = this.clone();
        substitutor.putAllInternal(parentClass, mappings);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        return psiSubstitutorImpl;
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        if (another instanceof EmptySubstitutorImpl) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutorImpl substitutor = this.clone();
        substitutor.mySubstitutionMap.putAll(anotherImpl.mySubstitutionMap);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        return psiSubstitutorImpl;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass != null ? aClass.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY;
        }
        return new PsiSubstitutorImpl(map);
    }

    @Override
    public boolean isValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null || type2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null) continue;
            PsiUtil.ensureValidType(type2);
        }
    }

    @Override
    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        Map<PsiTypeParameter, PsiType> map = Collections.unmodifiableMap(this.mySubstitutionMap);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "getSubstitutionMap"));
        }
        return map;
    }

    private class SubstitutionVisitor
    extends SubstitutionVisitorBase {
        private final SubstituteKind myKind;

        private SubstitutionVisitor(SubstituteKind kind) {
            this.myKind = kind;
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return classType;
            }
            PsiUtilCore.ensureValid(aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                if (PsiSubstitutorImpl.this.containsInMap(typeParameter)) {
                    PsiType result2 = this.substituteTypeParameter(typeParameter);
                    if (result2 != null) {
                        PsiUtil.ensureValidType(result2);
                    }
                    return result2;
                }
                return classType;
            }
            HashMap<PsiTypeParameter, PsiType> hashMap = new HashMap<PsiTypeParameter, PsiType>(2);
            if (!this.processClass(aClass, resolveResult.getSubstitutor(), hashMap)) {
                return null;
            }
            PsiClassType result3 = JavaPsiFacade.getElementFactory(aClass.getProject()).createType(aClass, PsiSubstitutorImpl.createSubstitutor(hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType(result3);
            return result3;
        }

        private PsiType substituteTypeParameter(@NotNull PsiTypeParameter typeParameter) {
            if (typeParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor", "substituteTypeParameter"));
            }
            PsiType t = PsiSubstitutorImpl.this.getFromMap(typeParameter);
            if (this.myKind == SubstituteKind.SIMPLE) {
                return t;
            }
            if (this.myKind == SubstituteKind.ADD_BOUNDS) {
                return PsiSubstitutorImpl.this.addBounds(t, typeParameter);
            }
            return t;
        }

        private PsiType substituteInternal(PsiType type2) {
            return type2.accept(this);
        }

        private boolean processClass(PsiClass resolve2, PsiSubstitutor originalSubstitutor, Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            for (PsiTypeParameter param : params = resolve2.getTypeParameters()) {
                PsiType substituted;
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                if (original instanceof PsiWildcardType) {
                    PsiType bound;
                    substituted = this.substituteInternal(original);
                    if (substituted instanceof PsiCapturedWildcardType) {
                        substituted = PsiCapturedWildcardType.create(((PsiCapturedWildcardType)substituted).getWildcard(), ((PsiCapturedWildcardType)substituted).getContext(), param);
                    } else if (substituted instanceof PsiWildcardType && (bound = ((PsiWildcardType)substituted).getBound()) instanceof PsiCapturedWildcardType) {
                        bound = PsiCapturedWildcardType.create(((PsiCapturedWildcardType)bound).getWildcard(), ((PsiCapturedWildcardType)bound).getContext(), param);
                        substituted = ((PsiWildcardType)substituted).isExtends() ? PsiWildcardType.createExtends(((PsiWildcardType)substituted).getManager(), bound) : PsiWildcardType.createSuper(((PsiWildcardType)substituted).getManager(), bound);
                    }
                } else {
                    substituted = this.substituteInternal(original);
                }
                substMap.put(param, substituted);
            }
            if (resolve2.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve2.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }
    }

    static enum SubstituteKind {
        SIMPLE,
        ADD_BOUNDS;

    }

    private static abstract class SubstitutionVisitorBase
    extends PsiTypeMapper {
        private SubstitutionVisitorBase() {
        }

        @Override
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType type2) {
            return this.visitWildcardType(type2.getWildcard());
        }

        @Override
        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = bound.accept(this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                return SubstitutionVisitorBase.handleBoundComposition(wildcardType, (PsiWildcardType)newBound);
            }
            if (newBound instanceof PsiCapturedWildcardType) {
                PsiWildcardType wildcard = ((PsiCapturedWildcardType)newBound).getWildcard();
                if (wildcardType.isExtends() != wildcard.isExtends()) {
                    if (wildcard.isBounded()) {
                        return wildcardType.isExtends() ? PsiWildcardType.createExtends(wildcardType.getManager(), newBound) : PsiWildcardType.createSuper(wildcardType.getManager(), newBound);
                    }
                    return newBound;
                }
                if (wildcard.isBounded()) {
                    return newBound;
                }
            }
            return newBound == PsiType.NULL ? newBound : SubstitutionVisitorBase.rebound(wildcardType, newBound);
        }

        private static PsiType handleBoundComposition(PsiWildcardType wildcardType, PsiWildcardType bound) {
            PsiType newBoundBound = bound.getBound();
            if (bound.isExtends() == wildcardType.isExtends() && newBoundBound != null) {
                return SubstitutionVisitorBase.rebound(wildcardType, newBoundBound);
            }
            if (newBoundBound != null) {
                return wildcardType.isExtends() ? PsiWildcardType.createExtends(wildcardType.getManager(), newBoundBound) : PsiWildcardType.createSuper(wildcardType.getManager(), newBoundBound);
            }
            return PsiWildcardType.createUnbounded(wildcardType.getManager());
        }

        private static PsiWildcardType rebound(PsiWildcardType type2, PsiType newBound) {
            LOG.assertTrue(type2.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type2.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    return PsiWildcardType.createUnbounded(type2.getManager());
                }
                return PsiWildcardType.createExtends(type2.getManager(), newBound);
            }
            return PsiWildcardType.createSuper(type2.getManager(), newBound);
        }

        @Override
        public abstract PsiType visitClassType(PsiClassType var1);
    }
}

