/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapBinding
extends Binding
implements MultiNodeBinding {
    private static final Logger LOG = Logger.getInstance(MapBinding.class);
    private static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
    };
    private final MapAnnotation myMapAnnotation;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;

    public MapBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/MapBinding", "<init>"));
        }
        super(accessor);
        this.myMapAnnotation = accessor.getAnnotation(MapAnnotation.class);
    }

    @Override
    public void init(@NotNull Type originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/MapBinding", "init"));
        }
        ParameterizedType type2 = (ParameterizedType)originalType;
        Type[] typeArguments = type2.getActualTypeArguments();
        this.keyClass = XmlSerializerImpl.typeToClass(typeArguments[0]);
        this.valueClass = XmlSerializerImpl.typeToClass(typeArguments[1]);
        this.keyBinding = XmlSerializerImpl.getClassBinding(this.keyClass, typeArguments[0], null);
        this.valueBinding = XmlSerializerImpl.getClassBinding(this.valueClass, typeArguments[1], null);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    private String getEntryAttributeName() {
        return this.myMapAnnotation == null ? "entry" : this.myMapAnnotation.entryTagName();
    }

    private String getKeyAttributeName() {
        return this.myMapAnnotation == null ? "key" : this.myMapAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        return this.myMapAnnotation == null ? "value" : this.myMapAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(Object context2, @NotNull List<?> nodes) {
        List<Object> childNodes;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/MapBinding", "deserializeList"));
        }
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            assert (nodes.size() == 1);
            childNodes = ((Element)nodes.get(0)).getContent();
        } else {
            childNodes = nodes;
        }
        return this.deserialize(context2, childNodes);
    }

    @Override
    public Object deserialize(Object context2, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/MapBinding", "deserialize"));
        }
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            return this.deserialize(context2, ((Element)node).getContent());
        }
        return this.deserialize(context2, Collections.singletonList((Element)node));
    }

    private Map deserialize(Object context2, List<?> childNodes) {
        Map map = (Map)context2;
        map.clear();
        for (Object childNode : childNodes) {
            if (XmlSerializerImpl.isIgnoredNode(childNode)) continue;
            Element entry = (Element)childNode;
            if (!entry.getName().equals(this.getEntryAttributeName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + entry);
                continue;
            }
            map.put(this.deserializeKeyOrValue(entry, this.getKeyAttributeName(), context2, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(entry, this.getValueAttributeName(), context2, this.valueBinding, this.valueClass));
        }
        return map;
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context2, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/util/xmlb/MapBinding", "deserializeKeyOrValue"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/util/xmlb/MapBinding", "deserializeKeyOrValue"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/MapBinding", "deserializeKeyOrValue"));
        }
        Attribute attribute = entry.getAttribute(attributeName);
        if (attribute != null) {
            return binding == null ? XmlSerializerImpl.convert(attribute.getValue(), valueClass) : binding.deserialize(context2, attribute);
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
            assert (binding != null);
            for (Content child : entry.getContent()) {
                if (!binding.isBoundTo(child)) continue;
                return binding.deserialize(context2, child);
            }
        } else {
            List<Content> children = XmlSerializerImpl.getFilteredContent(entry.getChild(attributeName));
            if (children.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, context2, children);
        }
        return null;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundWithTag()) {
            return this.myMapAnnotation.entryTagName().equals(((Element)node).getName());
        }
        return ((Element)node).getName().equals("map");
    }
}

