/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.CodegenUtilKt;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CollectionStubMethodGenerator;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.MethodKind;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperClass;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.DiagnosticsPackage;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmClassSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.NameSerializationUtil;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private Type superClassAsmType;
    @Nullable
    private JetType superClassType;
    private final Type classAsmType;
    private List<PropertyAndDefaultValue> companionObjectPropertiesToCopy;
    private final List<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>> additionalTasks;
    private final List<JetEnumEntry> myEnumConstants;

    public ImplementationBodyCodegen(@NotNull JetClassOrObject aClass, @NotNull ClassContext context2, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        super(aClass, context2, v, state, parentCodegen);
        this.additionalTasks = new ArrayList<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>>();
        this.myEnumConstants = new ArrayList<JetEnumEntry>();
        this.classAsmType = this.typeMapper.mapClass(this.descriptor);
    }

    @Override
    protected void generateDeclaration() {
        boolean isStatic;
        this.getSuperClass();
        JvmClassSignature signature = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        if (this.myClass instanceof JetClass) {
            JetClass jetClass = (JetClass)this.myClass;
            if (jetClass.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
                isAbstract = true;
            }
            if (jetClass.isTrait()) {
                isAbstract = true;
                isInterface = true;
            } else if (jetClass.isAnnotation()) {
                isAbstract = true;
                isInterface = true;
                isAnnotation = true;
                signature.getInterfaces().add("java/lang/annotation/Annotation");
            } else if (jetClass.isEnum()) {
                isAbstract = JvmCodegenUtil.hasAbstractMembers(this.descriptor);
                isEnum = true;
            }
            if (DescriptorUtils.isObject(this.descriptor)) {
                isFinal = true;
            }
            if (!jetClass.hasModifier(JetTokens.OPEN_KEYWORD) && !isAbstract) {
                isFinal = !jetClass.isEnum() || this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES;
            }
            isStatic = !jetClass.isInner();
        } else {
            isStatic = this.myClass instanceof JetObjectDeclaration && ((JetObjectDeclaration)this.myClass).isCompanion();
            isFinal = true;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (isStatic) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (JetDeclaration declaration : this.myClass.getDeclarations()) {
                if (!(declaration instanceof JetEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (JetEnumEntry)declaration)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        List<String> interfaces = signature.getInterfaces();
        this.v.defineClass(this.myClass, 50, access, signature.getName(), signature.getJavaGenericSignature(), signature.getSuperclassName(), ArrayUtil.toStringArray(interfaces));
        this.v.visitSource(this.myClass.getContainingFile().getName(), null);
        InlineCodegenUtil.initDefaultSourceMappingIfNeeded(this.context, this, this.state);
        this.writeEnclosingMethod();
        AnnotationCodegen.forClass(this.v.getVisitor(), this.typeMapper).genAnnotations(this.descriptor, null);
        this.generateReflectionObjectFieldIfNeeded();
    }

    @Override
    protected void generateKotlinAnnotation() {
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        JvmAnnotationNames.KotlinClass.Kind kind = DescriptorUtils.isAnonymousObject(this.descriptor) ? JvmAnnotationNames.KotlinClass.Kind.ANONYMOUS_OBJECT : (DescriptorUtils.isTopLevelOrInnerClass(this.descriptor) ? JvmAnnotationNames.KotlinClass.Kind.CLASS : JvmAnnotationNames.KotlinClass.Kind.LOCAL_CLASS);
        DescriptorSerializer serializer = DescriptorSerializer.create(this.descriptor, new JvmSerializerExtension(this.v.getSerializationBindings(), this.typeMapper));
        ProtoBuf.Class classProto = serializer.classProto(this.descriptor).build();
        ClassData data2 = new ClassData(NameSerializationUtil.createNameResolver(serializer.getStringTable()), classProto);
        AnnotationVisitor av = this.v.getVisitor().visitAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS), true);
        av.visit("abiVersion", 22);
        av.visitEnum("kind", Type.getObjectType(JvmAnnotationNames.KotlinClass.KIND_INTERNAL_NAME).getDescriptor(), kind.toString());
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(data2.toBytes())) {
            array.visit(null, string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    private void writeEnclosingMethod() {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor) || !(this.descriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.writeOuterClassAndEnclosingMethod();
        }
    }

    @NotNull
    private JvmClassSignature signature() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        this.typeMapper.writeFormalTypeParameters(this.descriptor.getTypeConstructor().getParameters(), sw);
        sw.writeSuperclass();
        if (this.superClassType == null) {
            sw.writeClassBegin(this.superClassAsmType);
            sw.writeClassEnd();
        } else {
            this.typeMapper.mapSupertype(this.superClassType, sw);
        }
        sw.writeSuperclassEnd();
        ArrayList<JetType> interfaceSupertypes = Lists.newArrayList();
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null) : "No supertype for class: " + this.myClass.getText();
            if (!JvmCodegenUtil.isInterface(superType.getConstructor().getDeclarationDescriptor())) continue;
            interfaceSupertypes.add(superType);
        }
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        for (JetType supertype : interfaceSupertypes) {
            sw.writeInterface();
            Type jvmName = this.typeMapper.mapSupertype(supertype, sw);
            sw.writeInterfaceEnd();
            superInterfaces.add(jvmName.getInternalName());
        }
        JvmClassSignature jvmClassSignature = new JvmClassSignature(this.classAsmType.getInternalName(), this.superClassAsmType.getInternalName(), new ArrayList<String>(superInterfaces), sw.makeJavaGenericSignature());
        if (jvmClassSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "signature"));
        }
        return jvmClassSignature;
    }

    protected void getSuperClass() {
        this.superClassAsmType = AsmTypes.OBJECT_TYPE;
        this.superClassType = null;
        List<JetDelegationSpecifier> delegationSpecifiers = this.myClass.getDelegationSpecifiers();
        if (this.myClass instanceof JetClass && ((JetClass)this.myClass).isTrait()) {
            return;
        }
        for (JetDelegationSpecifier specifier : delegationSpecifiers) {
            ClassDescriptor superClassDescriptor;
            if (!(specifier instanceof JetDelegatorToSuperClass) && !(specifier instanceof JetDelegatorToSuperCall)) continue;
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null) : String.format("No type recorded for \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(specifier));
            ClassifierDescriptor classifierDescriptor = superType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor) || JvmCodegenUtil.isInterface(superClassDescriptor = (ClassDescriptor)classifierDescriptor)) continue;
            this.superClassType = superType;
            this.superClassAsmType = this.typeMapper.mapClass(superClassDescriptor);
        }
        if (this.superClassType == null) {
            if (this.descriptor.getKind() == ClassKind.ENUM_CLASS) {
                this.superClassType = KotlinBuiltIns.getInstance().getEnumType(this.descriptor.getDefaultType());
                this.superClassAsmType = this.typeMapper.mapType(this.superClassType);
            }
            if (this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
                this.superClassType = this.descriptor.getTypeConstructor().getSupertypes().iterator().next();
                this.superClassAsmType = this.typeMapper.mapType(this.superClassType);
            }
        }
    }

    @Override
    protected void generateSyntheticParts() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
        this.generateFieldForSingleton();
        this.generateCompanionObjectBackingFieldCopies();
        DelegationFieldsInfo delegationFieldsInfo = this.getDelegationFieldsInfo(this.myClass.getDelegationSpecifiers());
        try {
            this.lookupConstructorExpressionsInClosureIfPresent();
            this.generatePrimaryConstructor(delegationFieldsInfo);
            for (ConstructorDescriptor secondaryConstructor : DescriptorUtilPackage.getSecondaryConstructors(this.descriptor)) {
                this.generateSecondaryConstructor(secondaryConstructor);
            }
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating constructors of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
        this.generateTraitMethods();
        this.generateDelegates(delegationFieldsInfo);
        this.generateSyntheticAccessors();
        this.generateEnumMethodsAndConstInitializers();
        this.generateFunctionsForDataClasses();
        new CollectionStubMethodGenerator(this.state, this.descriptor, this.functionCodegen, this.v).generate();
        this.generateToArray();
        AsmUtil.genClosureFields(this.context.closure, this.v, this.typeMapper);
        for (ExpressionCodegenExtension extension : ExpressionCodegenExtension.OBJECT$.getInstances(this.state.getProject())) {
            extension.generateClassSyntheticParts(this.v, this.state, this.myClass, this.descriptor);
        }
    }

    private void generateReflectionObjectFieldIfNeeded() {
        if (DescriptorUtils.isAnnotationClass(this.descriptor)) {
            return;
        }
        ImplementationBodyCodegen.generateReflectionObjectField(this.state, this.classAsmType, this.v, AsmUtil.method("createKotlinClass", AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), "$kotlinClass", this.createOrGetClInitCodegen().v);
    }

    private boolean isGenericToArrayPresent() {
        Collection<FunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getFunctions(Name.identifier("toArray"));
        for (FunctionDescriptor function : functions2) {
            JetType elementType;
            if (CallResolverUtil.isOrOverridesSynthesized(function) || function.getValueParameters().size() != 1 || function.getTypeParameters().size() != 1) continue;
            JetType returnType2 = function.getReturnType();
            assert (returnType2 != null) : function.toString();
            JetType paramType = function.getValueParameters().get(0).getType();
            if (!KotlinBuiltIns.isArray(returnType2) || !KotlinBuiltIns.isArray(paramType) || !JetTypeChecker.DEFAULT.equalTypes(elementType = function.getTypeParameters().get(0).getDefaultType(), KotlinBuiltIns.getInstance().getArrayElementType(returnType2)) || !JetTypeChecker.DEFAULT.equalTypes(elementType, KotlinBuiltIns.getInstance().getArrayElementType(paramType))) continue;
            return true;
        }
        return false;
    }

    private void generateToArray() {
        InstructionAdapter iv;
        MethodVisitor mv;
        int access;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        int n = access = this.descriptor.getKind() == ClassKind.TRAIT ? 1025 : 1;
        if (CodegenUtil.getDeclaredFunctionByRawSignature(this.descriptor, Name.identifier("toArray"), builtIns.getArray(), new ClassifierDescriptor[0]) == null) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, "toArray", "()[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", false);
                iv.areturn(Type.getType("[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
        if (!this.isGenericToArrayPresent()) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.load(1, Type.getType("[Ljava/lang/Object;"));
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", false);
                iv.areturn(Type.getType("[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
    }

    private void generateFunctionsForDataClasses() {
        if (!KotlinBuiltIns.isData(this.descriptor)) {
            return;
        }
        new DataClassMethodGeneratorImpl(this.myClass, this.bindingContext).generate();
    }

    @NotNull
    private static ConstructorDescriptor getPrimaryConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getPrimaryConstructorOfDataClass"));
        }
        ConstructorDescriptor constructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        assert (constructor2 != null) : "Data class must have primary constructor: " + classDescriptor;
        ConstructorDescriptor constructorDescriptor = constructor2;
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getPrimaryConstructorOfDataClass"));
        }
        return constructorDescriptor;
    }

    private void generateEnumMethodsAndConstInitializers() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
            this.initializeEnumConstants();
        }
    }

    private void generateEnumValuesMethod() {
        Type type2 = this.typeMapper.mapType(KotlinBuiltIns.getInstance().getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        FunctionDescriptor valuesFunction = KotlinPackage.single(this.descriptor.getStaticScope().getFunctions(DescriptorUtils.ENUM_VALUES), new Function1<FunctionDescriptor, Boolean>(){

            @Override
            public Boolean invoke(FunctionDescriptor descriptor) {
                return CodegenUtil.isEnumValuesMethod(descriptor);
            }
        });
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(this.myClass, valuesFunction), 9, DescriptorUtils.ENUM_VALUES.asString(), "()" + type2.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), "$VALUES", type2.getDescriptor());
        mv.visitMethodInsn(182, type2.getInternalName(), "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, type2.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        FunctionDescriptor valueOfFunction = KotlinPackage.single(this.descriptor.getStaticScope().getFunctions(DescriptorUtils.ENUM_VALUE_OF), new Function1<FunctionDescriptor, Boolean>(){

            @Override
            public Boolean invoke(FunctionDescriptor descriptor) {
                return CodegenUtil.isEnumValueOfMethod(descriptor);
            }
        });
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(this.myClass, valueOfFunction), 9, DescriptorUtils.ENUM_VALUE_OF.asString(), "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn(this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    protected void generateSyntheticAccessors() {
        Map<DeclarationDescriptor, DeclarationDescriptor> accessors = this.context.getAccessors();
        for (Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry : accessors.entrySet()) {
            this.generateSyntheticAccessor(entry);
        }
    }

    private void generateSyntheticAccessor(Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry) {
        if (entry.getValue() instanceof FunctionDescriptor) {
            FunctionDescriptor bridge = (FunctionDescriptor)entry.getValue();
            final FunctionDescriptor original = (FunctionDescriptor)entry.getKey();
            this.functionCodegen.generateMethod(DiagnosticsPackage.Synthetic(null, original), bridge, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, bridge){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$3", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$3", "doGenerateBody"));
                    }
                    ImplementationBodyCodegen.markLineNumberForSyntheticFunction(ImplementationBodyCodegen.this.descriptor, codegen.v);
                    ImplementationBodyCodegen.this.generateMethodCallTo(original, codegen.v);
                    codegen.v.areturn(signature.getReturnType());
                }
            });
        } else if (entry.getValue() instanceof PropertyDescriptor) {
            final PropertyDescriptor bridge = (PropertyDescriptor)entry.getValue();
            final PropertyDescriptor original = (PropertyDescriptor)entry.getKey();
            PropertyGetterDescriptor getter = bridge.getGetter();
            assert (getter != null);
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
                public PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    if (propertyDescriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$1PropertyAccessorStrategy", "<init>"));
                    }
                    super(ImplementationBodyCodegen.this.state, callableDescriptor);
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    boolean forceField = AsmUtil.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isCompanionObject(bridge.getContainingDeclaration());
                    StackValue.Property property2 = codegen.intermediateValueForProperty(original, forceField, null, MethodKind.SYNTHETIC_ACCESSOR, StackValue.none());
                    InstructionAdapter iv = codegen.v;
                    ImplementationBodyCodegen.markLineNumberForSyntheticFunction(ImplementationBodyCodegen.this.descriptor, iv);
                    Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        property2.put(property2.type, iv);
                    } else {
                        ((StackValue)property2).store(StackValue.onStack(property2.type), iv, true);
                    }
                    iv.areturn(signature.getReturnType());
                }
            }
            this.functionCodegen.generateMethod(DiagnosticsPackage.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), getter, new PropertyAccessorStrategy(getter));
            if (bridge.isVar()) {
                PropertySetterDescriptor setter = bridge.getSetter();
                assert (setter != null);
                this.functionCodegen.generateMethod(DiagnosticsPackage.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), setter, new PropertyAccessorStrategy(setter));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void markLineNumberForSyntheticFunction(@Nullable ClassDescriptor declarationDescriptor, @NotNull InstructionAdapter v) {
        Integer lineNumber;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "markLineNumberForSyntheticFunction"));
        }
        if (declarationDescriptor == null) {
            return;
        }
        PsiElement classElement = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
        if (classElement != null && (lineNumber = CodegenUtil.getLineNumberForElement(classElement, false)) != null) {
            Label label = new Label();
            v.visitLabel(label);
            v.visitLineNumber(lineNumber, label);
        }
    }

    private void generateMethodCallTo(FunctionDescriptor functionDescriptor, InstructionAdapter iv) {
        boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
        boolean callFromAccessor = !JetTypeMapper.isAccessor(functionDescriptor);
        CallableMethod callableMethod = isConstructor ? this.typeMapper.mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : this.typeMapper.mapToCallableMethod(functionDescriptor, callFromAccessor, this.context);
        int reg = 1;
        if (isConstructor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
        } else if (callFromAccessor && !AnnotationsPackage.isPlatformStaticInObjectOrClass(functionDescriptor)) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
        }
        for (Type argType : callableMethod.getAsmMethod().getArgumentTypes()) {
            iv.load(reg, argType);
            reg += argType.getSize();
        }
        callableMethod.invokeWithoutAssertions(iv);
    }

    private void generateFieldForSingleton() {
        if (DescriptorUtils.isEnumEntry(this.descriptor) || DescriptorUtils.isCompanionObject(this.descriptor)) {
            return;
        }
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            StackValue.Field field = StackValue.singleton(this.descriptor, this.typeMapper);
            this.v.newField(DiagnosticsPackage.OtherOrigin(this.myClass), 25, field.name, field.type.getDescriptor(), null, null);
            if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
                return;
            }
            InstructionAdapter v = this.createOrGetClInitCodegen().v;
            v.anew(this.classAsmType);
            v.invokespecial(this.classAsmType.getInternalName(), "<init>", "()V", false);
            return;
        }
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 == null) {
            return;
        }
        JetObjectDeclaration companionObject = KotlinPackage.firstOrNull(((JetClass)this.myClass).getCompanionObjects());
        assert (companionObject != null) : "Companion object not found: " + this.myClass.getText();
        StackValue.Field field = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
        this.v.newField(DiagnosticsPackage.OtherOrigin(companionObject), 25, field.name, field.type.getDescriptor(), null, null);
        StackValue.Field deprecatedField = StackValue.deprecatedCompanionObjectAccessor(companionObjectDescriptor2, this.typeMapper);
        FieldVisitor fv = this.v.newField(DiagnosticsPackage.OtherOrigin(companionObject), 131097, deprecatedField.name, deprecatedField.type.getDescriptor(), null, null);
        fv.visitAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(new FqName("java.lang.Deprecated")), true).visitEnd();
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        if (!AsmUtil.isCompanionObjectWithBackingFieldsInOuter(companionObjectDescriptor2)) {
            this.generateCompanionObjectInitializer(companionObjectDescriptor2);
        }
    }

    private void generateCompanionObjectBackingFieldCopies() {
        if (this.companionObjectPropertiesToCopy == null) {
            return;
        }
        for (PropertyAndDefaultValue info : this.companionObjectPropertiesToCopy) {
            PropertyDescriptor property2 = info.descriptor;
            Type type2 = this.typeMapper.mapType(property2);
            FieldVisitor fv = this.v.newField(DiagnosticsPackage.Synthetic(DescriptorToSourceUtils.descriptorToDeclaration(property2), property2), 25, this.context.getFieldName(property2, false), type2.getDescriptor(), this.typeMapper.mapFieldSignature(property2.getType()), info.defaultValue);
            AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(property2, type2);
            if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || info.defaultValue != null) continue;
            ExpressionCodegen codegen = this.createOrGetClInitCodegen();
            int companionObjectIndex = this.putCompanionObjectInLocalVar(codegen);
            StackValue.local(companionObjectIndex, AsmTypes.OBJECT_TYPE).put(AsmTypes.OBJECT_TYPE, codegen.v);
            this.copyFieldFromCompanionObject(property2);
        }
    }

    private int putCompanionObjectInLocalVar(ExpressionCodegen codegen) {
        FrameMap frameMap = codegen.myFrameMap;
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        int companionObjectIndex = frameMap.getIndex(companionObjectDescriptor2);
        if (companionObjectIndex == -1) {
            companionObjectIndex = frameMap.enter(companionObjectDescriptor2, AsmTypes.OBJECT_TYPE);
            StackValue.Field companionObject = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            StackValue.local(companionObjectIndex, companionObject.type).store(companionObject, codegen.v);
        }
        return companionObjectIndex;
    }

    private void copyFieldFromCompanionObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        StackValue.Property property2 = codegen.intermediateValueForProperty(propertyDescriptor, false, null, StackValue.none());
        StackValue.Field field = StackValue.field(property2.type, this.classAsmType, propertyDescriptor.getName().asString(), true, StackValue.none());
        field.store(property2, codegen.v);
    }

    private void generateCompanionObjectInitializer(@NotNull ClassDescriptor companionObject) {
        if (companionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "companionObject", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateCompanionObjectInitializer"));
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        FunctionDescriptor constructor2 = codegen.accessibleFunctionDescriptor(KotlinPackage.single(companionObject.getConstructors()));
        this.generateMethodCallTo(constructor2, codegen.v);
        codegen.v.dup();
        StackValue instance = StackValue.onStack(this.typeMapper.mapClass(companionObject));
        StackValue.singleton(companionObject, this.typeMapper).store(instance, codegen.v, true);
        StackValue.deprecatedCompanionObjectAccessor(companionObject, this.typeMapper).store(instance, codegen.v, true);
    }

    private void generatePrimaryConstructor(final DelegationFieldsInfo delegationFieldsInfo) {
        if (this.ignoreIfTraitOrAnnotation()) {
            return;
        }
        ConstructorDescriptor constructorDescriptor = this.descriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(this.myClass, constructorDescriptor), constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased<ConstructorDescriptor>(this.state, constructorDescriptor){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                }
                ImplementationBodyCodegen.this.generatePrimaryConstructorImpl((ConstructorDescriptor)this.callableDescriptor, codegen, delegationFieldsInfo);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(constructorDescriptor);
        FunctionCodegen.generateConstructorWithoutParametersIfNeeded(this.state, callableMethod, constructorDescriptor, this.v, this.myClass);
        if (DescriptorUtils.isCompanionObject(this.descriptor)) {
            this.context.recordSyntheticAccessorIfNeeded(constructorDescriptor, this.bindingContext);
        }
    }

    private void generateSecondaryConstructor(@NotNull ConstructorDescriptor constructorDescriptor) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSecondaryConstructor"));
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor), constructorDescriptor), constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased<ConstructorDescriptor>(this.state, constructorDescriptor){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$5", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$5", "doGenerateBody"));
                }
                ImplementationBodyCodegen.this.generateSecondaryConstructorImpl((ConstructorDescriptor)this.callableDescriptor, codegen);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
    }

    private void generatePrimaryConstructorImpl(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen, @NotNull DelegationFieldsInfo fieldsInfo) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        if (fieldsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldsInfo", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        InstructionAdapter iv = codegen.v;
        this.generateClosureInitialization(iv);
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, JvmCodegenUtil.getDelegationConstructorCall(this.bindingContext, constructorDescriptor));
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            StackValue.singleton(this.descriptor, this.typeMapper).store(StackValue.LOCAL_0, iv);
        }
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            this.genCallToDelegatorByExpressionSpecifier(iv, codegen, (JetDelegatorByExpressionSpecifier)specifier, fieldsInfo);
        }
        int curParam = 0;
        List<ValueParameterDescriptor> parameters2 = constructorDescriptor.getValueParameters();
        for (JetParameter parameter : this.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVarNode()) {
                VariableDescriptor descriptor = parameters2.get(curParam);
                Type type2 = this.typeMapper.mapType(descriptor);
                iv.load(0, this.classAsmType);
                iv.load(codegen.myFrameMap.getIndex(descriptor), type2);
                PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                assert (propertyDescriptor != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                iv.putfield(this.classAsmType.getInternalName(), this.context.getFieldName(propertyDescriptor, false), type2.getDescriptor());
            }
            ++curParam;
        }
        if (AsmUtil.isCompanionObjectWithBackingFieldsInOuter(this.descriptor)) {
            final ImplementationBodyCodegen parentCodegen = (ImplementationBodyCodegen)this.getParentCodegen();
            parentCodegen.generateCompanionObjectInitializer(this.descriptor);
            this.generateInitializers(new Function0<ExpressionCodegen>(){

                @Override
                public ExpressionCodegen invoke() {
                    return parentCodegen.createOrGetClInitCodegen();
                }
            });
        } else {
            this.generateInitializers(codegen);
        }
        iv.visitInsn(177);
    }

    private void generateSecondaryConstructorImpl(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSecondaryConstructorImpl"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSecondaryConstructorImpl"));
        }
        InstructionAdapter iv = codegen.v;
        ResolvedCall<ConstructorDescriptor> constructorDelegationCall = JvmCodegenUtil.getDelegationConstructorCall(this.bindingContext, constructorDescriptor);
        ConstructorDescriptor delegateConstructor = constructorDelegationCall == null ? null : constructorDelegationCall.getResultingDescriptor();
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, constructorDelegationCall);
        if (!this.isSameClassConstructor(delegateConstructor)) {
            this.generateClosureInitialization(iv);
            this.generateInitializers(codegen);
        }
        JetSecondaryConstructor constructor2 = (JetSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        assert (constructor2 != null);
        codegen.gen(constructor2.getBodyExpression(), Type.VOID_TYPE);
        iv.visitInsn(177);
    }

    private void generateInitializers(final @NotNull ExpressionCodegen codegen) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateInitializers"));
        }
        this.generateInitializers(new Function0<ExpressionCodegen>(){

            @Override
            public ExpressionCodegen invoke() {
                return codegen;
            }
        });
    }

    private void generateClosureInitialization(@NotNull InstructionAdapter iv) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateClosureInitialization"));
        }
        MutableClosure closure = this.context.closure;
        if (closure != null) {
            List<FieldInfo> argsFromClosure = ClosureCodegen.calculateConstructorParameters(this.typeMapper, closure, this.classAsmType);
            int k = 1;
            for (FieldInfo info : argsFromClosure) {
                k = AsmUtil.genAssignInstanceFieldFromParam(info, k, iv);
            }
        }
    }

    private void genSimpleSuperCall(InstructionAdapter iv) {
        iv.load(0, this.superClassAsmType);
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS || this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypes.JAVA_STRING_TYPE);
            iv.load(2, Type.INT_TYPE);
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        } else {
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "()V", false);
        }
    }

    @NotNull
    private DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<JetDelegationSpecifier> delegationSpecifiers) {
        if (delegationSpecifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationSpecifiers", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getDelegationFieldsInfo"));
        }
        DelegationFieldsInfo result2 = new DelegationFieldsInfo();
        int n = 0;
        for (JetDelegationSpecifier specifier : delegationSpecifiers) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            JetExpression expression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression, this.descriptor, this.bindingContext);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext)) {
                result2.addField((JetDelegatorByExpressionSpecifier)specifier, propertyDescriptor);
            } else {
                JetType expressionType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
                Type asmType = expressionType != null ? this.typeMapper.mapType(expressionType) : this.typeMapper.mapType(this.getSuperClass(specifier));
                result2.addField((JetDelegatorByExpressionSpecifier)specifier, asmType, "$delegate_" + n);
            }
            ++n;
        }
        DelegationFieldsInfo delegationFieldsInfo = result2;
        if (delegationFieldsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getDelegationFieldsInfo"));
        }
        return delegationFieldsInfo;
    }

    @NotNull
    private ClassDescriptor getSuperClass(@NotNull JetDelegationSpecifier specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getSuperClass"));
        }
        ClassDescriptor classDescriptor = CodegenUtil.getSuperClassByDelegationSpecifier(specifier, this.bindingContext);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getSuperClass"));
        }
        return classDescriptor;
    }

    private void genCallToDelegatorByExpressionSpecifier(InstructionAdapter iv, ExpressionCodegen codegen, JetDelegatorByExpressionSpecifier specifier, DelegationFieldsInfo fieldsInfo) {
        JetExpression expression = specifier.getDelegateExpression();
        DelegationFieldsInfo.Field fieldInfo = fieldsInfo.getInfo(specifier);
        if (fieldInfo.generateField) {
            iv.load(0, this.classAsmType);
            fieldInfo.getStackValue().store(codegen.gen(expression), iv);
        }
    }

    private void lookupConstructorExpressionsInClosureIfPresent() {
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || this.descriptor.getConstructors().isEmpty()) {
            return;
        }
        JetVisitorVoid visitor2 = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "visitJetElement"));
                }
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expr) {
                DeclarationDescriptor toLookup;
                if (expr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "visitSimpleNameExpression"));
                }
                DeclarationDescriptor descriptor = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr);
                if (DescriptorUtils.isLocalFunction(descriptor)) {
                    toLookup = descriptor;
                } else if (descriptor instanceof CallableMemberDescriptor) {
                    toLookup = descriptor.getContainingDeclaration();
                } else if (descriptor instanceof VariableDescriptor) {
                    ClassDescriptor classDescriptor;
                    if (descriptor.getContainingDeclaration() instanceof ConstructorDescriptor && (classDescriptor = (ClassDescriptor)descriptor.getContainingDeclaration().getContainingDeclaration()) == ImplementationBodyCodegen.this.descriptor) {
                        return;
                    }
                    toLookup = descriptor;
                } else {
                    return;
                }
                ImplementationBodyCodegen.this.context.lookupInContext(toLookup, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true);
            }

            @Override
            public void visitThisExpression(@NotNull JetThisExpression expression) {
                ReceiverParameterDescriptor parameter;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "visitThisExpression"));
                }
                DeclarationDescriptor descriptor = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
                assert (descriptor instanceof CallableDescriptor || descriptor instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor;
                if (descriptor instanceof ClassDescriptor) {
                    ImplementationBodyCodegen.this.context.lookupInContext(descriptor, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true);
                }
                if (descriptor instanceof CallableDescriptor && (parameter = ((CallableDescriptor)descriptor).getExtensionReceiverParameter()) != null) {
                    ImplementationBodyCodegen.this.context.lookupInContext(parameter, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true);
                }
            }
        };
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (declaration instanceof JetProperty) {
                JetProperty property2 = (JetProperty)declaration;
                JetExpression initializer = property2.getInitializer();
                if (initializer == null) continue;
                initializer.accept(visitor2);
                continue;
            }
            if (declaration instanceof JetClassInitializer) {
                JetClassInitializer initializer = (JetClassInitializer)declaration;
                initializer.accept(visitor2);
                continue;
            }
            if (!(declaration instanceof JetSecondaryConstructor)) continue;
            JetSecondaryConstructor constructor2 = (JetSecondaryConstructor)declaration;
            constructor2.accept(visitor2);
        }
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            JetExpression delegateExpression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
            assert (delegateExpression != null);
            delegateExpression.accept(visitor2);
        }
        ClassDescriptor superClass = DescriptorUtilPackage.getSuperClassNotAny(this.descriptor);
        if (superClass != null) {
            ConstructorDescriptor primaryConstructor2;
            if (superClass.isInner()) {
                this.context.lookupInContext(superClass.getContainingDeclaration(), StackValue.LOCAL_0, this.state, true);
            }
            if ((primaryConstructor2 = this.descriptor.getUnsubstitutedPrimaryConstructor()) != null && !DescriptorUtils.isAnonymousObject(this.descriptor)) {
                JetValueArgumentList argumentList;
                ResolvedCall<ConstructorDescriptor> delegationCall = JvmCodegenUtil.getDelegationConstructorCall(this.bindingContext, primaryConstructor2);
                JetValueArgumentList jetValueArgumentList = argumentList = delegationCall != null ? delegationCall.getCall().getValueArgumentList() : null;
                if (argumentList != null) {
                    argumentList.accept(visitor2);
                }
            }
        }
    }

    private boolean ignoreIfTraitOrAnnotation() {
        if (this.myClass instanceof JetClass) {
            JetClass aClass = (JetClass)this.myClass;
            if (aClass.isTrait()) {
                return true;
            }
            if (aClass.isAnnotation()) {
                return true;
            }
        }
        return false;
    }

    private void generateTraitMethods() {
        if (JetPsiUtil.isTrait(this.myClass)) {
            return;
        }
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getTraitMethods(this.descriptor).entrySet()) {
            FunctionDescriptor traitFun = entry.getKey();
            if (traitFun instanceof JavaCallableMemberDescriptor) continue;
            this.generateDelegationToTraitImpl(traitFun, entry.getValue());
        }
    }

    private void generateDelegationToTraitImpl(final @NotNull FunctionDescriptor traitFun, @NotNull FunctionDescriptor inheritedFun) {
        if (traitFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitFun", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        if (inheritedFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritedFun", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        this.functionCodegen.generateMethod(DiagnosticsPackage.DelegationToTraitImpl(DescriptorToSourceUtils.descriptorToDeclaration(traitFun), traitFun), inheritedFun, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, inheritedFun){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$9", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$9", "doGenerateBody"));
                }
                DeclarationDescriptor containingDeclaration = traitFun.getContainingDeclaration();
                if (!DescriptorUtils.isTrait(containingDeclaration)) {
                    return;
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration;
                Type traitImplType = ImplementationBodyCodegen.this.typeMapper.mapTraitImpl(containingTrait);
                Method traitMethod = ImplementationBodyCodegen.this.typeMapper.mapSignature(traitFun.getOriginal(), OwnerKind.TRAIT_IMPL).getAsmMethod();
                Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                Type[] originalArgTypes = traitMethod.getArgumentTypes();
                assert (originalArgTypes.length == argTypes.length + 1) : "Invalid trait implementation signature: " + signature + " vs " + traitMethod + " for " + traitFun;
                InstructionAdapter iv = codegen.v;
                iv.load(0, AsmTypes.OBJECT_TYPE);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i + 1], iv);
                    reg += argTypes[i].getSize();
                }
                KotlinBuiltIns.getInstance();
                if (KotlinBuiltIns.isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType2 = signature.getReturnType();
                StackValue.onStack(traitMethod.getReturnType()).put(returnType2, iv);
                iv.areturn(returnType2);
            }
        });
    }

    private void generateDelegatorToConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor, @Nullable ResolvedCall<ConstructorDescriptor> delegationConstructorCall) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (delegationConstructorCall == null) {
            this.genSimpleSuperCall(iv);
            return;
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        ConstructorDescriptor delegateConstructor = delegationConstructorCall.getResultingDescriptor();
        CallableMethod delegateConstructorCallable = this.typeMapper.mapToCallableMethod(delegateConstructor);
        CallableMethod callable2 = this.typeMapper.mapToCallableMethod(constructorDescriptor);
        List<JvmMethodParameterSignature> delegatingParameters = delegateConstructorCallable.getValueParameters();
        List<JvmMethodParameterSignature> parameters2 = callable2.getValueParameters();
        ArgumentGenerator argumentGenerator = this.isSameClassConstructor(delegateConstructor) ? ImplementationBodyCodegen.generateThisCallImplicitArguments(iv, codegen, delegateConstructor, delegateConstructorCallable, delegatingParameters, parameters2) : this.generateSuperCallImplicitArguments(iv, codegen, constructorDescriptor, delegateConstructor, delegateConstructorCallable, delegatingParameters, parameters2);
        codegen.invokeMethodWithArguments(delegateConstructorCallable, delegationConstructorCall, StackValue.none(), codegen.defaultCallGenerator, argumentGenerator);
    }

    private boolean isSameClassConstructor(@Nullable ConstructorDescriptor delegatingConstructor) {
        return delegatingConstructor != null && delegatingConstructor.getContainingDeclaration() == this.descriptor;
    }

    @NotNull
    private ArgumentGenerator generateSuperCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ConstructorDescriptor superConstructor, @NotNull CallableMethod superCallable, @NotNull List<JvmMethodParameterSignature> superParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (superConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superConstructor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (superCallable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCallable", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (superParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        int offset = 1;
        int superIndex = 0;
        for (JvmMethodParameterSignature parameter : parameters2) {
            if (superIndex >= superParameters.size()) break;
            JvmMethodParameterKind superKind = superParameters.get(superIndex).getKind();
            JvmMethodParameterKind kind = parameter.getKind();
            Type type2 = parameter.getAsmType();
            if (superKind == JvmMethodParameterKind.VALUE && kind == JvmMethodParameterKind.SUPER_CALL_PARAM) break;
            if (superKind == JvmMethodParameterKind.OUTER) {
                assert (kind == JvmMethodParameterKind.OUTER || kind == JvmMethodParameterKind.SUPER_CALL_PARAM) : String.format("Non-outer parameter incorrectly mapped to outer for %s: %s vs %s", constructorDescriptor, parameters2, superParameters);
                ClassDescriptor outerForSuper = (ClassDescriptor)superConstructor.getContainingDeclaration().getContainingDeclaration();
                StackValue outer = codegen.generateThisOrOuter(outerForSuper, false);
                outer.put(outer.type, codegen.v);
                ++superIndex;
            } else if (kind == JvmMethodParameterKind.SUPER_CALL_PARAM || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL) {
                iv.load(offset, type2);
                ++superIndex;
            }
            offset += type2.getSize();
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            List<JvmMethodParameterSignature> superValues = superParameters.subList(superIndex, superParameters.size());
            ObjectSuperCallArgumentGenerator objectSuperCallArgumentGenerator = new ObjectSuperCallArgumentGenerator(superValues, iv, offset);
            if (objectSuperCallArgumentGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
            }
            return objectSuperCallArgumentGenerator;
        }
        CallBasedArgumentGenerator callBasedArgumentGenerator = new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, superConstructor.getValueParameters(), superCallable.getValueParameterTypes());
        if (callBasedArgumentGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        return callBasedArgumentGenerator;
    }

    @NotNull
    private static ArgumentGenerator generateThisCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor delegatingConstructor, @NotNull CallableMethod delegatingCallable, @NotNull List<JvmMethodParameterSignature> delegatingParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        int index2;
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (delegatingConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingConstructor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (delegatingCallable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingCallable", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (delegatingParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        int offset = 1;
        for (index2 = 0; index2 < delegatingParameters.size(); ++index2) {
            JvmMethodParameterKind delegatingKind = delegatingParameters.get(index2).getKind();
            if (delegatingKind == JvmMethodParameterKind.VALUE) {
                assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough implicit parameters";
                break;
            }
            assert (index2 < parameters2.size() && parameters2.get(index2).getKind() == delegatingKind) : "Constructors of the same class should have the same set of implicit arguments";
            JvmMethodParameterSignature parameter = parameters2.get(index2);
            iv.load(offset, parameter.getAsmType());
            offset += parameter.getAsmType().getSize();
        }
        assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough parameters";
        CallBasedArgumentGenerator callBasedArgumentGenerator = new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, delegatingConstructor.getValueParameters(), delegatingCallable.getValueParameterTypes());
        if (callBasedArgumentGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        return callBasedArgumentGenerator;
    }

    @Override
    protected void generateDeclaration(JetDeclaration declaration) {
        if (declaration instanceof JetEnumEntry) {
            String name = declaration.getName();
            assert (name != null) : "Enum entry has no name: " + declaration.getText();
            ClassDescriptor entryDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
            FieldVisitor fv = this.v.newField(DiagnosticsPackage.OtherOrigin(declaration, entryDescriptor), 16409, name, this.classAsmType.getDescriptor(), null, null);
            AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(entryDescriptor, null);
            this.myEnumConstants.add((JetEnumEntry)declaration);
        }
        super.generateDeclaration(declaration);
    }

    private void initializeEnumConstants() {
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        Type arrayAsmType = this.typeMapper.mapType(KotlinBuiltIns.getInstance().getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        this.v.newField(DiagnosticsPackage.OtherOrigin(this.myClass), 4122, "$VALUES", arrayAsmType.getDescriptor(), null, null);
        iv.iconst(this.myEnumConstants.size());
        iv.newarray(this.classAsmType);
        if (!this.myEnumConstants.isEmpty()) {
            iv.dup();
            int size = this.myEnumConstants.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(codegen, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), "$VALUES", arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull ExpressionCodegen codegen, int ordinal) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "initializeEnumConstant"));
        }
        InstructionAdapter iv = codegen.v;
        JetEnumEntry enumConstant = this.myEnumConstants.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, enumConstant);
        assert (classDescriptor != null);
        Type implClass = this.typeMapper.mapClass(classDescriptor);
        List<JetDelegationSpecifier> delegationSpecifiers = enumConstant.getDelegationSpecifiers();
        if (delegationSpecifiers.size() > 1) {
            throw new UnsupportedOperationException("multiple delegation specifiers for enum constant not supported");
        }
        iv.anew(implClass);
        iv.dup();
        iv.aconst(enumConstant.getName());
        iv.iconst(ordinal);
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, enumConstant)) {
            JetDelegationSpecifier specifier = delegationSpecifiers.get(0);
            if (!(specifier instanceof JetDelegatorToSuperCall)) {
                throw new UnsupportedOperationException("unsupported type of enum constant initializer: " + specifier);
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCallWithAssert(specifier, this.bindingContext);
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall.getResultingDescriptor());
            codegen.invokeMethodWithArguments(method, resolvedCall, StackValue.none());
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumConstant.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypes.OBJECT_TYPE);
    }

    private void generateDelegates(DelegationFieldsInfo delegationFieldsInfo) {
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            DelegationFieldsInfo.Field field = delegationFieldsInfo.getInfo((JetDelegatorByExpressionSpecifier)specifier);
            this.generateDelegateField(field);
            JetExpression delegateExpression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
            JetType delegateExpressionType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, delegateExpression);
            this.generateDelegates(this.getSuperClass(specifier), delegateExpressionType, field);
        }
    }

    private void generateDelegateField(DelegationFieldsInfo.Field fieldInfo) {
        if (!fieldInfo.generateField) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4114, fieldInfo.name, fieldInfo.type.getDescriptor(), null, null);
    }

    protected void generateDelegates(ClassDescriptor toTrait, JetType delegateExpressionType, DelegationFieldsInfo.Field field) {
        for (Map.Entry<CallableMemberDescriptor, CallableDescriptor> entry : CodegenUtilKt.getDelegates(this.descriptor, toTrait, delegateExpressionType).entrySet()) {
            CallableMemberDescriptor callableMemberDescriptor = entry.getKey();
            CallableDescriptor delegateTo = entry.getValue();
            if (callableMemberDescriptor instanceof PropertyDescriptor) {
                this.propertyCodegen.genDelegate((PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)delegateTo, field.getStackValue());
                continue;
            }
            if (!(callableMemberDescriptor instanceof FunctionDescriptor)) continue;
            this.functionCodegen.genDelegate((FunctionDescriptor)callableMemberDescriptor, (FunctionDescriptor)delegateTo, field.getStackValue());
        }
    }

    public void addCompanionObjectPropertyToCopy(@NotNull PropertyDescriptor descriptor, Object defaultValue) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "addCompanionObjectPropertyToCopy"));
        }
        if (this.companionObjectPropertiesToCopy == null) {
            this.companionObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.companionObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor, defaultValue));
    }

    @Override
    protected void done() {
        for (Function2<ImplementationBodyCodegen, ClassBuilder, Unit> task : this.additionalTasks) {
            task.invoke(this, this.v);
        }
        super.done();
    }

    public void addAdditionalTask(Function2<ImplementationBodyCodegen, ClassBuilder, Unit> additionalTask) {
        this.additionalTasks.add(additionalTask);
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(@NotNull PropertyDescriptor descriptor, Object defaultValue) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$PropertyAndDefaultValue", "<init>"));
            }
            this.descriptor = descriptor;
            this.defaultValue = defaultValue;
        }
    }

    private static class ObjectSuperCallArgumentGenerator
    extends ArgumentGenerator {
        private final List<JvmMethodParameterSignature> parameters;
        private final InstructionAdapter iv;
        private int offset;

        public ObjectSuperCallArgumentGenerator(@NotNull List<JvmMethodParameterSignature> superParameters, @NotNull InstructionAdapter iv, int firstValueParamOffset) {
            if (superParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "<init>"));
            }
            if (iv == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "<init>"));
            }
            this.parameters = superParameters;
            this.iv = iv;
            this.offset = firstValueParamOffset;
        }

        @Override
        public void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateExpression"));
            }
            this.generateSuperCallArgument(i);
        }

        @Override
        public void generateDefault(int i, @NotNull DefaultValueArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateDefault"));
            }
            AsmUtil.pushDefaultValueOnStack(this.parameters.get(i).getAsmType(), this.iv);
        }

        @Override
        public void generateVararg(int i, @NotNull VarargValueArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateVararg"));
            }
            this.generateSuperCallArgument(i);
        }

        private void generateSuperCallArgument(int i) {
            Type type2 = this.parameters.get(i).getAsmType();
            this.iv.load(this.offset, type2);
            this.offset += type2.getSize();
        }
    }

    private class DelegationFieldsInfo {
        private final Map<JetDelegatorByExpressionSpecifier, Field> fields = new HashMap<JetDelegatorByExpressionSpecifier, Field>();

        private DelegationFieldsInfo() {
        }

        @NotNull
        public Field getInfo(JetDelegatorByExpressionSpecifier specifier) {
            Field field = this.fields.get(specifier);
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DelegationFieldsInfo", "getInfo"));
            }
            return field;
        }

        private void addField(JetDelegatorByExpressionSpecifier specifier, PropertyDescriptor propertyDescriptor) {
            this.fields.put(specifier, new Field(ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor), propertyDescriptor.getName().asString(), false));
        }

        private void addField(JetDelegatorByExpressionSpecifier specifier, Type type2, String name) {
            this.fields.put(specifier, new Field(type2, name, true));
        }

        private class Field {
            public final Type type;
            public final String name;
            public final boolean generateField;

            private Field(Type type2, String name, boolean generateField) {
                this.type = type2;
                this.name = name;
                this.generateField = generateField;
            }

            @NotNull
            public StackValue getStackValue() {
                StackValue.Field field = StackValue.field(this.type, ImplementationBodyCodegen.this.classAsmType, this.name, false, StackValue.none());
                if (field == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DelegationFieldsInfo$Field", "getStackValue"));
                }
                return field;
            }
        }
    }

    private class DataClassMethodGeneratorImpl
    extends DataClassMethodGenerator {
        DataClassMethodGeneratorImpl(JetClassOrObject klass, BindingContext bindingContext) {
            super(klass, bindingContext);
        }

        @Override
        public void generateEqualsMethod(@NotNull List<PropertyDescriptor> properties2) {
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateEqualsMethod"));
            }
            FunctionDescriptor equalsFunction = CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier("equals"), KotlinBuiltIns.getInstance().getBoolean(), KotlinBuiltIns.getInstance().getAny());
            assert (equalsFunction != null) : String.format("Should be called only for classes with non-trivial '%s'. In %s, %s", "equals", ImplementationBodyCodegen.this.descriptor.getName(), ImplementationBodyCodegen.this.descriptor);
            MethodContext context2 = ImplementationBodyCodegen.this.context.intoFunction(equalsFunction);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(DiagnosticsPackage.OtherOrigin(equalsFunction), 1, "equals", "(Ljava/lang/Object;)Z", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            Label eq = new Label();
            Label ne = new Label();
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.ifacmpeq(eq);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.instanceOf(ImplementationBodyCodegen.this.classAsmType);
            iv.ifeq(ne);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.checkcast(ImplementationBodyCodegen.this.classAsmType);
            iv.store(2, AsmTypes.OBJECT_TYPE);
            for (PropertyDescriptor propertyDescriptor : properties2) {
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                this.genPropertyOnStack(iv, context2, propertyDescriptor, 0);
                this.genPropertyOnStack(iv, context2, propertyDescriptor, 2);
                if (asmType.getSort() == 9) {
                    Type elementType = AsmUtil.correctElementType(asmType);
                    if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                        iv.invokestatic("java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", false);
                    } else {
                        iv.invokestatic("java/util/Arrays", "equals", "(" + asmType.getDescriptor() + asmType.getDescriptor() + ")Z", false);
                    }
                    iv.ifeq(ne);
                    continue;
                }
                if (asmType.getSort() == 6) {
                    iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                    iv.ifne(ne);
                    continue;
                }
                if (asmType.getSort() == 8) {
                    iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                    iv.ifne(ne);
                    continue;
                }
                StackValue value = AsmUtil.genEqualsForExpressionsOnStack(JetTokens.EQEQ, StackValue.onStack(asmType), StackValue.onStack(asmType));
                value.put(Type.BOOLEAN_TYPE, iv);
                iv.ifeq(ne);
            }
            iv.mark(eq);
            iv.iconst(1);
            iv.areturn(Type.INT_TYPE);
            iv.mark(ne);
            iv.iconst(0);
            iv.areturn(Type.INT_TYPE);
            FunctionCodegen.endVisit(mv, "equals", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateHashCodeMethod(@NotNull List<PropertyDescriptor> properties2) {
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateHashCodeMethod"));
            }
            FunctionDescriptor hashCodeFunction = CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier("hashCode"), KotlinBuiltIns.getInstance().getInt(), new ClassifierDescriptor[0]);
            assert (hashCodeFunction != null) : String.format("Should be called only for classes with non-trivial '%s'. In %s, %s", "hashCode", ImplementationBodyCodegen.this.descriptor.getName(), ImplementationBodyCodegen.this.descriptor);
            MethodContext context2 = ImplementationBodyCodegen.this.context.intoFunction(hashCodeFunction);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(DiagnosticsPackage.OtherOrigin(hashCodeFunction), 1, "hashCode", "()I", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (!first) {
                    iv.iconst(31);
                    iv.mul(Type.INT_TYPE);
                }
                this.genPropertyOnStack(iv, context2, propertyDescriptor, 0);
                Label ifNull = null;
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                if (!AsmUtil.isPrimitive(asmType)) {
                    ifNull = new Label();
                    iv.dup();
                    iv.ifnull(ifNull);
                }
                AsmUtil.genHashCode(mv, iv, asmType);
                if (ifNull != null) {
                    Label end = new Label();
                    iv.goTo(end);
                    iv.mark(ifNull);
                    iv.pop();
                    iv.iconst(0);
                    iv.mark(end);
                }
                if (first) {
                    first = false;
                    continue;
                }
                iv.add(Type.INT_TYPE);
            }
            mv.visitInsn(172);
            FunctionCodegen.endVisit(mv, "hashCode", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateToStringMethod(@NotNull List<PropertyDescriptor> properties2) {
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateToStringMethod"));
            }
            FunctionDescriptor toString2 = CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier("toString"), KotlinBuiltIns.getInstance().getString(), new ClassifierDescriptor[0]);
            assert (toString2 != null) : String.format("Should be called only for classes with non-trivial '%s'. In %s, %s", "toString", ImplementationBodyCodegen.this.descriptor.getName(), ImplementationBodyCodegen.this.descriptor);
            MethodContext context2 = ImplementationBodyCodegen.this.context.intoFunction(toString2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(DiagnosticsPackage.OtherOrigin(toString2), 1, "toString", "()Ljava/lang/String;", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            AsmUtil.genStringBuilderConstructor(iv);
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (first) {
                    iv.aconst(ImplementationBodyCodegen.this.descriptor.getName() + "(" + propertyDescriptor.getName().asString() + "=");
                    first = false;
                } else {
                    iv.aconst(", " + propertyDescriptor.getName().asString() + "=");
                }
                AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE);
                Type type2 = this.genPropertyOnStack(iv, context2, propertyDescriptor, 0);
                if (type2.getSort() == 9) {
                    Type elementType = AsmUtil.correctElementType(type2);
                    if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                        iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
                        type2 = AsmTypes.JAVA_STRING_TYPE;
                    } else if (elementType.getSort() != 2) {
                        iv.invokestatic("java/util/Arrays", "toString", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
                        type2 = AsmTypes.JAVA_STRING_TYPE;
                    }
                }
                AsmUtil.genInvokeAppendMethod(iv, type2);
            }
            iv.aconst(")");
            AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE);
            iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit(mv, "toString", ImplementationBodyCodegen.this.myClass);
        }

        private Type genPropertyOnStack(InstructionAdapter iv, MethodContext context2, @NotNull PropertyDescriptor propertyDescriptor, int index2) {
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "genPropertyOnStack"));
            }
            iv.load(index2, ImplementationBodyCodegen.this.classAsmType);
            if (JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, false, context2)) {
                Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor.getType());
                String fieldName = ((FieldOwnerContext)context2.getParentContext()).getFieldName(propertyDescriptor, false);
                iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), fieldName, type2.getDescriptor());
                return type2.getReturnType();
            }
            Method method = ImplementationBodyCodegen.this.typeMapper.mapSignature(propertyDescriptor.getGetter()).getAsmMethod();
            iv.invokevirtual(ImplementationBodyCodegen.this.classAsmType.getInternalName(), method.getName(), method.getDescriptor(), false);
            return method.getReturnType();
        }

        @Override
        public void generateComponentFunction(@NotNull FunctionDescriptor function, final @NotNull ValueParameterDescriptor parameter) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateComponentFunction"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateComponentFunction"));
            }
            PsiElement originalElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(originalElement, function), function, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                    if (mv == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (frameMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (context2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (parentCodegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    Type componentType = signature.getReturnType();
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    if (!componentType.equals(Type.VOID_TYPE)) {
                        PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, DescriptorToSourceUtils.descriptorToDeclaration(parameter));
                        assert (property2 != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                        DataClassMethodGeneratorImpl.this.genPropertyOnStack(iv, context2, property2, 0);
                    }
                    iv.areturn(componentType);
                }
            });
        }

        @Override
        public void generateCopyFunction(final @NotNull FunctionDescriptor function, @NotNull List<JetParameter> constructorParameters) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateCopyFunction"));
            }
            if (constructorParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateCopyFunction"));
            }
            final Type thisDescriptorType = ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(ImplementationBodyCodegen.this.myClass, function), function, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                    ClassDescriptor captureThis;
                    if (mv == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (frameMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (context2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (parentCodegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.anew(thisDescriptorType);
                    iv.dup();
                    ConstructorDescriptor constructor2 = ImplementationBodyCodegen.getPrimaryConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                    assert (function.getValueParameters().size() == constructor2.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function.getValueParameters().size() + ", " + "constructor: " + constructor2.getValueParameters().size();
                    MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                    if (closure != null && (captureThis = closure.getCaptureThis()) != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(captureThis);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type2.getDescriptor());
                    }
                    int parameterIndex = 1;
                    for (ValueParameterDescriptor parameterDescriptor : function.getValueParameters()) {
                        Type type3 = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                        iv.load(parameterIndex, type3);
                        parameterIndex += type3.getSize();
                    }
                    Method constructorAsmMethod = ImplementationBodyCodegen.this.typeMapper.mapSignature(constructor2).getAsmMethod();
                    iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorAsmMethod.getDescriptor(), false);
                    iv.areturn(thisDescriptorType);
                }
            });
            ImplementationBodyCodegen.this.functionCodegen.generateDefaultIfNeeded(ImplementationBodyCodegen.this.context.intoFunction(function), function, OwnerKind.IMPLEMENTATION, new DefaultParameterValueLoader(){

                @Override
                public StackValue genValue(ValueParameterDescriptor valueParameter, ExpressionCodegen codegen) {
                    assert (KotlinBuiltIns.isData((ClassDescriptor)function.getContainingDeclaration())) : "Function container should be annotated with [data]: " + function;
                    PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter);
                    assert (property2 != null) : "Copy function doesn't correspond to any property: " + function;
                    return codegen.intermediateValueForProperty(property2, false, null, StackValue.LOCAL_0);
                }
            }, null);
        }
    }
}

