/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.binding.CodegenAnnotatingVisitor;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.org.objectweb.asm.Type;

public class CodegenBinding {
    public static final WritableSlice<ClassDescriptor, MutableClosure> CLOSURE = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, ClassDescriptor> CLASS_FOR_FUNCTION = Slices.createSimpleSlice();
    public static final WritableSlice<ScriptDescriptor, ClassDescriptor> CLASS_FOR_SCRIPT = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Type> ASM_TYPE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> ENUM_ENTRY_CLASS_NEED_SUBCLASS = Slices.createSimpleSetSlice();
    public static final WritableSlice<ClassDescriptor, Collection<ClassDescriptor>> INNER_CLASSES = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, SamType> SAM_VALUE = Slices.createSimpleSlice();
    public static final WritableSlice<JetCallExpression, JetExpression> SAM_CONSTRUCTOR_TO_ARGUMENT = Slices.createSimpleSlice();
    public static final WritableSlice<JetWhenExpression, WhenByEnumsMapping> MAPPING_FOR_WHEN_BY_ENUM = Slices.sliceBuilder().build();
    public static final WritableSlice<String, List<WhenByEnumsMapping>> MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE = Slices.sliceBuilder().build();

    private CodegenBinding() {
    }

    public static void initTrace(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "initTrace"));
        }
        CodegenAnnotatingVisitor visitor2 = new CodegenAnnotatingVisitor(state);
        for (JetFile file : CodegenBinding.allFilesInPackages(state.getBindingContext(), state.getFiles())) {
            file.accept(visitor2);
        }
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, JetEnumEntry enumEntry) {
        return CodegenBinding.enumEntryNeedSubclass(bindingContext, bindingContext.get(BindingContext.CLASS, enumEntry));
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, ClassDescriptor classDescriptor) {
        return Boolean.TRUE.equals(bindingContext.get(ENUM_ENTRY_CLASS_NEED_SUBCLASS, classDescriptor));
    }

    @NotNull
    public static Type asmTypeForScriptDescriptor(BindingContext bindingContext, @NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForScriptDescriptor"));
        }
        ClassDescriptor classDescriptor = bindingContext.get(CLASS_FOR_SCRIPT, scriptDescriptor);
        Type type2 = CodegenBinding.getAsmType(bindingContext, classDescriptor);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForScriptDescriptor"));
        }
        return type2;
    }

    @NotNull
    public static Type asmTypeForScriptPsi(BindingContext bindingContext, @NotNull JetScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForScriptPsi"));
        }
        ScriptDescriptor scriptDescriptor = bindingContext.get(BindingContext.SCRIPT, script);
        if (scriptDescriptor == null) {
            throw new IllegalStateException("Script descriptor not found by PSI " + script);
        }
        Type type2 = CodegenBinding.asmTypeForScriptDescriptor(bindingContext, scriptDescriptor);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForScriptPsi"));
        }
        return type2;
    }

    @NotNull
    public static ClassDescriptor anonymousClassForFunction(@NotNull BindingContext bindingContext, @NotNull FunctionDescriptor descriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "anonymousClassForFunction"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "anonymousClassForFunction"));
        }
        ClassDescriptor classDescriptor = bindingContext.get(CLASS_FOR_FUNCTION, descriptor);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "anonymousClassForFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull JetElement expression) {
        ClassDescriptor descriptor;
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (expression instanceof JetObjectLiteralExpression) {
            JetObjectLiteralExpression jetObjectLiteralExpression = (JetObjectLiteralExpression)expression;
            expression = jetObjectLiteralExpression.getObjectDeclaration();
        }
        if ((descriptor = bindingContext.get(BindingContext.CLASS, expression)) == null) {
            SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression);
            assert (functionDescriptor != null);
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(bindingContext, functionDescriptor);
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
            }
            return type2;
        }
        Type type3 = CodegenBinding.getAsmType(bindingContext, descriptor);
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        return type3;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull FunctionDescriptor descriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        Type type2 = CodegenBinding.getAsmType(bindingContext, CodegenBinding.anonymousClassForFunction(bindingContext, descriptor));
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        return type2;
    }

    public static boolean canHaveOuter(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "canHaveOuter"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "canHaveOuter"));
        }
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            return false;
        }
        MutableClosure closure = bindingContext.get(CLOSURE, classDescriptor);
        if (closure == null || closure.getEnclosingClass() == null) {
            return false;
        }
        return classDescriptor.isInner() || !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor);
    }

    static void recordClosure(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @Nullable ClassDescriptor enclosing, @NotNull Type asmType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordClosure"));
        }
        JetElement element = (JetElement)DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor);
        assert (element != null) : "No source element for " + classDescriptor;
        MutableClosure closure = new MutableClosure(classDescriptor, enclosing);
        if (classDescriptor.isInner()) {
            closure.setCaptureThis();
        }
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(classDescriptor, asmType));
        trace.record(ASM_TYPE, classDescriptor, asmType);
        trace.record(CLOSURE, classDescriptor, closure);
        if (enclosing != null && !JvmCodegenUtil.isLambdaWhichWillBeInlined(trace.getBindingContext(), classDescriptor)) {
            CodegenBinding.recordInnerClass(trace, enclosing, classDescriptor);
        }
    }

    private static void recordInnerClass(@NotNull BindingTrace bindingTrace, @NotNull ClassDescriptor outer, @NotNull ClassDescriptor inner) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        Collection<ClassDescriptor> innerClasses = bindingTrace.get(INNER_CLASSES, outer);
        if (innerClasses == null) {
            innerClasses = new ArrayList<ClassDescriptor>(1);
            bindingTrace.record(INNER_CLASSES, outer, innerClasses);
        }
        innerClasses.add(inner);
    }

    public static void registerClassNameForScript(@NotNull BindingTrace trace, @NotNull JetScript script, @NotNull Type asmType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        ScriptDescriptor descriptor = trace.getBindingContext().get(BindingContext.SCRIPT, script);
        if (descriptor == null) {
            throw new IllegalStateException("Script descriptor is not found for PSI: " + JetPsiUtil.getElementTextWithContext(script));
        }
        String simpleName = asmType.getInternalName().substring(asmType.getInternalName().lastIndexOf(47) + 1);
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(descriptor, Name.special("<script-" + simpleName + ">"), Modality.FINAL, Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()), SourcePackage.toSourceElement(script));
        classDescriptor.initialize(JetScope.Empty.INSTANCE$, Collections.<ConstructorDescriptor>emptySet(), null);
        CodegenBinding.recordClosure(trace, classDescriptor, null, asmType);
        trace.record(CLASS_FOR_SCRIPT, descriptor, classDescriptor);
    }

    @NotNull
    private static Collection<JetFile> allFilesInPackages(BindingContext bindingContext, Collection<JetFile> files) {
        HashSet<FqName> names2 = new HashSet<FqName>();
        for (JetFile file : files) {
            if (file.isScript()) continue;
            names2.add(file.getPackageFqName());
        }
        HashSet<JetFile> answer = new HashSet<JetFile>();
        answer.addAll(files);
        for (FqName name : names2) {
            Collection<JetFile> jetFiles = bindingContext.get(BindingContext.PACKAGE_TO_FILES, name);
            if (jetFiles == null) continue;
            answer.addAll(jetFiles);
        }
        ArrayList<JetFile> sortedAnswer = new ArrayList<JetFile>(answer);
        Collections.sort(sortedAnswer, new Comparator<JetFile>(){

            @NotNull
            private String path(JetFile file) {
                VirtualFile virtualFile = file.getVirtualFile();
                assert (virtualFile != null) : "VirtualFile is null for JetFile: " + file.getName();
                String string = virtualFile.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding$1", "path"));
                }
                return string;
            }

            @Override
            public int compare(@NotNull JetFile first, @NotNull JetFile second) {
                if (first == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/codegen/binding/CodegenBinding$1", "compare"));
                }
                if (second == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/kotlin/codegen/binding/CodegenBinding$1", "compare"));
                }
                return this.path(first).compareTo(this.path(second));
            }
        });
        ArrayList<JetFile> arrayList = sortedAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "allFilesInPackages"));
        }
        return arrayList;
    }

    @NotNull
    public static Type getAsmType(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor klass) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAsmType"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAsmType"));
        }
        Type type2 = bindingContext.get(ASM_TYPE, klass);
        assert (type2 != null) : "Type is not yet recorded for " + klass;
        Type type3 = type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAsmType"));
        }
        return type3;
    }

    @NotNull
    public static Collection<ClassDescriptor> getAllInnerClasses(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor outermostClass) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAllInnerClasses"));
        }
        if (outermostClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outermostClass", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAllInnerClasses"));
        }
        Collection<ClassDescriptor> innerClasses = bindingContext.get(INNER_CLASSES, outermostClass);
        if (innerClasses == null || innerClasses.isEmpty()) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAllInnerClasses"));
            }
            return set;
        }
        HashSet<ClassDescriptor> allInnerClasses = new HashSet<ClassDescriptor>();
        ArrayDeque<ClassDescriptor> stack = new ArrayDeque<ClassDescriptor>(innerClasses);
        do {
            Collection<ClassDescriptor> nextClasses;
            ClassDescriptor currentClass;
            if (!allInnerClasses.add(currentClass = (ClassDescriptor)stack.pop()) || (nextClasses = bindingContext.get(INNER_CLASSES, currentClass)) == null) continue;
            for (ClassDescriptor nextClass : nextClasses) {
                stack.push(nextClass);
            }
        } while (!stack.isEmpty());
        HashSet<ClassDescriptor> hashSet = allInnerClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenBinding", "getAllInnerClasses"));
        }
        return hashSet;
    }

    static {
        BasicWritableSlice.initSliceDebugNames(CodegenBinding.class);
    }
}

