/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamWrapperClasses;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.codegen.optimization.OptimizationClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.BuilderFactoryForDuplicateSignatureDiagnostics;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.codegen.state.JetTypeMapperWithOutDirectory;
import org.jetbrains.kotlin.codegen.state.Progress;
import org.jetbrains.kotlin.codegen.when.MappingsClassesForWhenByEnum;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.types.reflect.ReflectionTypes;

public class GenerationState {
    private boolean used;
    @NotNull
    private final Progress progress;
    @NotNull
    private final List<JetFile> files;
    @NotNull
    private final ClassBuilderMode classBuilderMode;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ClassFileFactory classFileFactory;
    @NotNull
    private final Project project;
    @NotNull
    private final IntrinsicMethods intrinsics;
    @NotNull
    private final SamWrapperClasses samWrapperClasses;
    @NotNull
    private final MappingsClassesForWhenByEnum mappingsClassesForWhenByEnum;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final JetTypeMapper typeMapper;
    private final boolean disableCallAssertions;
    private final boolean disableParamAssertions;
    private final GenerateClassFilter generateClassFilter;
    private final boolean disableInline;
    @Nullable
    private List<ScriptDescriptor> earlierScriptsForReplInterpreter;
    private final ReflectionTypes reflectionTypes;
    private final JvmRuntimeTypes runtimeTypes;
    @NotNull
    private final ModuleDescriptor module;
    private final DiagnosticSink diagnostics;
    @NotNull
    private final Collection<FqName> packagesWithObsoleteParts;
    @Nullable
    private final String moduleId;
    @Nullable
    private final File outDirectory;

    public GenerationState(@NotNull Project project, @NotNull ClassBuilderFactory builderFactory, @NotNull ModuleDescriptor module, @NotNull BindingContext bindingContext, @NotNull List<JetFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderFactory", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        this(project, builderFactory, Progress.DEAF, module, bindingContext, files, true, true, GenerateClassFilter.GENERATE_ALL, false, false, null, null, DiagnosticSink.DO_NOTHING, null);
    }

    public GenerationState(@NotNull Project project, @NotNull ClassBuilderFactory builderFactory, @NotNull Progress progress, @NotNull ModuleDescriptor module, @NotNull BindingContext bindingContext, @NotNull List<JetFile> files, boolean disableCallAssertions, boolean disableParamAssertions, GenerateClassFilter generateClassFilter, boolean disableInline, boolean disableOptimization, @Nullable Collection<FqName> packagesWithObsoleteParts, @Nullable String moduleId, @NotNull DiagnosticSink diagnostics, @Nullable File outDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderFactory", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/codegen/state/GenerationState", "<init>"));
        }
        this.used = false;
        this.samWrapperClasses = new SamWrapperClasses(this);
        this.mappingsClassesForWhenByEnum = new MappingsClassesForWhenByEnum(this);
        this.project = project;
        this.progress = progress;
        this.module = module;
        this.files = files;
        this.moduleId = moduleId;
        this.packagesWithObsoleteParts = packagesWithObsoleteParts == null ? Collections.emptySet() : packagesWithObsoleteParts;
        this.classBuilderMode = builderFactory.getClassBuilderMode();
        this.disableInline = disableInline;
        this.bindingTrace = new DelegatingBindingTrace(bindingContext, "trace in GenerationState");
        this.bindingContext = this.bindingTrace.getBindingContext();
        this.outDirectory = outDirectory;
        this.typeMapper = new JetTypeMapperWithOutDirectory(this.bindingContext, this.classBuilderMode, outDirectory);
        this.intrinsics = new IntrinsicMethods();
        if (!disableOptimization) {
            builderFactory = new OptimizationClassBuilderFactory(builderFactory);
        }
        this.diagnostics = diagnostics;
        this.classFileFactory = new ClassFileFactory(this, new BuilderFactoryForDuplicateSignatureDiagnostics(builderFactory, this.bindingContext, diagnostics));
        this.disableCallAssertions = disableCallAssertions;
        this.disableParamAssertions = disableParamAssertions;
        this.generateClassFilter = generateClassFilter;
        this.reflectionTypes = new ReflectionTypes(module);
        this.runtimeTypes = new JvmRuntimeTypes(this.reflectionTypes);
    }

    @NotNull
    public ClassFileFactory getFactory() {
        ClassFileFactory classFileFactory = this.classFileFactory;
        if (classFileFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getFactory"));
        }
        return classFileFactory;
    }

    @NotNull
    public Progress getProgress() {
        Progress progress = this.progress;
        if (progress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getProgress"));
        }
        return progress;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public ClassBuilderMode getClassBuilderMode() {
        ClassBuilderMode classBuilderMode = this.classBuilderMode;
        if (classBuilderMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getClassBuilderMode"));
        }
        return classBuilderMode;
    }

    @NotNull
    public List<JetFile> getFiles() {
        List<JetFile> list = this.files;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getFiles"));
        }
        return list;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        BindingTrace bindingTrace = this.bindingTrace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getBindingTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public JetTypeMapper getTypeMapper() {
        JetTypeMapper jetTypeMapper = this.typeMapper;
        if (jetTypeMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getTypeMapper"));
        }
        return jetTypeMapper;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getProject"));
        }
        return project;
    }

    @NotNull
    public IntrinsicMethods getIntrinsics() {
        IntrinsicMethods intrinsicMethods = this.intrinsics;
        if (intrinsicMethods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getIntrinsics"));
        }
        return intrinsicMethods;
    }

    @NotNull
    public SamWrapperClasses getSamWrapperClasses() {
        SamWrapperClasses samWrapperClasses = this.samWrapperClasses;
        if (samWrapperClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getSamWrapperClasses"));
        }
        return samWrapperClasses;
    }

    @NotNull
    public MappingsClassesForWhenByEnum getMappingsClassesForWhenByEnum() {
        MappingsClassesForWhenByEnum mappingsClassesForWhenByEnum = this.mappingsClassesForWhenByEnum;
        if (mappingsClassesForWhenByEnum == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getMappingsClassesForWhenByEnum"));
        }
        return mappingsClassesForWhenByEnum;
    }

    public boolean isCallAssertionsEnabled() {
        return !this.disableCallAssertions;
    }

    public boolean isParamAssertionsEnabled() {
        return !this.disableParamAssertions;
    }

    @NotNull
    public GenerateClassFilter getGenerateDeclaredClassFilter() {
        GenerateClassFilter generateClassFilter = this.generateClassFilter;
        if (generateClassFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getGenerateDeclaredClassFilter"));
        }
        return generateClassFilter;
    }

    @NotNull
    public ReflectionTypes getReflectionTypes() {
        ReflectionTypes reflectionTypes = this.reflectionTypes;
        if (reflectionTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getReflectionTypes"));
        }
        return reflectionTypes;
    }

    @NotNull
    public JvmRuntimeTypes getJvmRuntimeTypes() {
        JvmRuntimeTypes jvmRuntimeTypes = this.runtimeTypes;
        if (jvmRuntimeTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getJvmRuntimeTypes"));
        }
        return jvmRuntimeTypes;
    }

    @NotNull
    public DiagnosticSink getDiagnostics() {
        DiagnosticSink diagnosticSink = this.diagnostics;
        if (diagnosticSink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getDiagnostics"));
        }
        return diagnosticSink;
    }

    public boolean isInlineEnabled() {
        return !this.disableInline;
    }

    public void beforeCompile() {
        this.markUsed();
        CodegenBinding.initTrace(this);
    }

    private void markUsed() {
        if (this.used) {
            throw new IllegalStateException(GenerationState.class + " cannot be used more than once");
        }
        this.used = true;
    }

    public void destroy() {
    }

    @Nullable
    public List<ScriptDescriptor> getEarlierScriptsForReplInterpreter() {
        return this.earlierScriptsForReplInterpreter;
    }

    public void setEarlierScriptsForReplInterpreter(@Nullable List<ScriptDescriptor> earlierScriptsForReplInterpreter) {
        this.earlierScriptsForReplInterpreter = earlierScriptsForReplInterpreter;
    }

    @NotNull
    public ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getModule"));
        }
        return moduleDescriptor;
    }

    @NotNull
    public Collection<FqName> getPackagesWithObsoleteParts() {
        Collection<FqName> collection = this.packagesWithObsoleteParts;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/GenerationState", "getPackagesWithObsoleteParts"));
        }
        return collection;
    }

    @Nullable
    public String getModuleId() {
        return this.moduleId;
    }

    @Nullable
    public File getOutDirectory() {
        return this.outDirectory;
    }

    public static interface GenerateClassFilter {
        public static final GenerateClassFilter GENERATE_ALL = new GenerateClassFilter(){

            @Override
            public boolean shouldAnnotateClass(JetClassOrObject classOrObject) {
                return true;
            }

            @Override
            public boolean shouldGenerateClass(JetClassOrObject classOrObject) {
                return true;
            }

            @Override
            public boolean shouldGenerateScript(JetScript script) {
                return true;
            }

            @Override
            public boolean shouldGeneratePackagePart(JetFile jetFile) {
                return true;
            }
        };

        public boolean shouldAnnotateClass(JetClassOrObject var1);

        public boolean shouldGenerateClass(JetClassOrObject var1);

        public boolean shouldGeneratePackagePart(JetFile var1);

        public boolean shouldGenerateScript(JetScript var1);
    }
}

