/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;

public abstract class Config {
    private final boolean inlineEnabled;
    @NotNull
    private final Project project;
    @NotNull
    private final List<JetFile> sourceFilesFromLibraries;
    @NotNull
    private final EcmaVersion target;
    @NotNull
    private final String moduleId;
    private final boolean sourcemap;
    @NotNull
    protected final List<KotlinJavascriptMetadata> metadata;
    @Nullable
    private List<ModuleDescriptorImpl> moduleDescriptors;
    private boolean initialized;

    public Config(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/Config", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/kotlin/js/config/Config", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/kotlin/js/config/Config", "<init>"));
        }
        this.sourceFilesFromLibraries = new SmartList<JetFile>();
        this.metadata = new SmartList<KotlinJavascriptMetadata>();
        this.moduleDescriptors = null;
        this.initialized = false;
        this.project = project;
        this.target = ecmaVersion;
        this.moduleId = moduleId;
        this.sourcemap = sourcemap;
        this.inlineEnabled = inlineEnabled;
    }

    public boolean isSourcemap() {
        return this.sourcemap;
    }

    public boolean isInlineEnabled() {
        return this.inlineEnabled;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "getProject"));
        }
        return project;
    }

    @NotNull
    public EcmaVersion getTarget() {
        EcmaVersion ecmaVersion = this.target;
        if (ecmaVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "getTarget"));
        }
        return ecmaVersion;
    }

    @NotNull
    public String getModuleId() {
        String string = this.moduleId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "getModuleId"));
        }
        return string;
    }

    public abstract boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> var1);

    protected abstract void init(@NotNull List<JetFile> var1, @NotNull List<KotlinJavascriptMetadata> var2);

    @NotNull
    public List<ModuleDescriptorImpl> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            List<ModuleDescriptorImpl> list = this.moduleDescriptors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "getModuleDescriptors"));
            }
            return list;
        }
        this.moduleDescriptors = new SmartList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata metadataEntry : this.metadata) {
            this.moduleDescriptors.add(Config.createModuleDescriptor(metadataEntry));
        }
        List<ModuleDescriptorImpl> list = this.moduleDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "getModuleDescriptors"));
        }
        return list;
    }

    @NotNull
    public List<JetFile> getSourceFilesFromLibraries() {
        this.init();
        List<JetFile> list = this.sourceFilesFromLibraries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "getSourceFilesFromLibraries"));
        }
        return list;
    }

    public boolean isTestConfig() {
        return false;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.init(this.sourceFilesFromLibraries, this.metadata);
        this.initialized = true;
    }

    private static ModuleDescriptorImpl createModuleDescriptor(KotlinJavascriptMetadata metadata) {
        ModuleDescriptorImpl moduleDescriptor = TopDownAnalyzerFacadeForJS.createJsModule("<" + metadata.getModuleName() + ">");
        List<PackageFragmentProvider> providers = KotlinJavascriptSerializationUtil.getPackageFragmentProviders(moduleDescriptor, metadata.getBody());
        CompositePackageFragmentProvider compositePackageFragmentProvider = new CompositePackageFragmentProvider(providers);
        moduleDescriptor.initialize(compositePackageFragmentProvider);
        moduleDescriptor.addDependencyOnModule(moduleDescriptor);
        moduleDescriptor.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        moduleDescriptor.seal();
        return moduleDescriptor;
    }

    @NotNull
    public static Collection<JetFile> withJsLibAdded(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/Config", "withJsLibAdded"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/config/Config", "withJsLibAdded"));
        }
        ArrayList<JetFile> allFiles = Lists.newArrayList();
        allFiles.addAll(files);
        allFiles.addAll(config.getSourceFilesFromLibraries());
        ArrayList<JetFile> arrayList = allFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/Config", "withJsLibAdded"));
        }
        return arrayList;
    }
}

