/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.LibrarySourcesConfig;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.PathUtil;

public class LibrarySourcesConfigWithCaching
extends LibrarySourcesConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    private static List<KotlinJavascriptMetadata> stdlibMetadata = null;
    private final boolean isUnitTestConfig;

    public LibrarySourcesConfigWithCaching(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled, boolean isUnitTestConfig) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/LibrarySourcesConfigWithCaching", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/kotlin/js/config/LibrarySourcesConfigWithCaching", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/kotlin/js/config/LibrarySourcesConfigWithCaching", "<init>"));
        }
        super(project, moduleId, JS_STDLIB, ecmaVersion, sourcemap, inlineEnabled);
        this.isUnitTestConfig = isUnitTestConfig;
    }

    @Override
    protected void init(@NotNull List<JetFile> sourceFilesInLibraries, @NotNull List<KotlinJavascriptMetadata> metadata) {
        if (sourceFilesInLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilesInLibraries", "org/jetbrains/kotlin/js/config/LibrarySourcesConfigWithCaching", "init"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "org/jetbrains/kotlin/js/config/LibrarySourcesConfigWithCaching", "init"));
        }
        if (stdlibMetadata == null) {
            stdlibMetadata = new SmartList<KotlinJavascriptMetadata>();
            super.init(sourceFilesInLibraries, stdlibMetadata);
        }
        metadata.addAll(stdlibMetadata);
    }

    @Override
    public boolean isTestConfig() {
        return this.isUnitTestConfig;
    }
}

