/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsPackage$descriptorUtils$c17fc7be;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\u001b\b)y1)\u0019;dQR\u0013\u0018M\\:mCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\tQ7OC\u0005ue\u0006t7\u000f\\1uK*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b%\u0005\u00137\u000f\u001e:bGR$&/\u00198tY\u0006$xN\u001d\u0006\bO\u0016tWM]1m\u0015\u0019a\u0014N\\5u})91-\u0019;dQ\u0016\u001c(\u0002\u0002'jgRTaBS3u\u0007\u0006$8\r[\"mCV\u001cXMC\u0002qg&TqaY8oi\u0016DHO\u0003\nUe\u0006t7\u000f\\1uS>t7i\u001c8uKb$(\u0002\u00026bm\u0006TA!\u001e;jY*Qq-\u001a;DCR\u001c\u0007.Z:\u000b!)+G\u000fV=qKJ+g-\u001a:f]\u000e,'bC5t)\"\u0014xn^1cY\u0016TqAQ8pY\u0016\fgN\u0003\bhKRL5\u000f\u00165s_^\f'\r\\3\u000b\u000f)\u001b8)\u0019;dQ*\u00191m\\7\u000b\r\u001d|wn\u001a7f\u0015\u0011!\u0017M\u001d;\u000b\u0011\r|W\u000e]5mKJTqAY1dW\u0016tGMC\u0002bgRT!\u0003\u001e:b]Nd\u0017\r^3DCR\u001c\u0007NQ8es*Y1-\u0019;dQ\u000ec\u0017-^:f\u0015\u001dQ5O\u00117pG.T\u0001\u0003\u001e:b]Nd\u0017\r^3DCR\u001c\u0007.Z:\u000b\u0019A\f'/Y7fi\u0016\u0014(+\u001a4\u000b\u0013)\u001bh*Y7f%\u00164'\u0002C%uKJ\fGo\u001c:\u000b\u0017)\u001b8\u000b^1uK6,g\u000e\u001eA\u0003\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0011AA\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0013AY\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001RB\u0003\u0004\t\u0017Aa\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001bB\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0003!AQA\u0001C\b\u0011#)!\u0001\u0002\u0005\t\f\u0015\u0011AQ\u0002E\b\u000b\r!Y\u0001c\u0005\r\u0001\u0015\u0019A\u0011\u0002E\u000b\u0019\u0001)!\u0001b\u0003\t\u0014\u0015\t\u0001\u0002D\u0003\u0003\t-AI\"\u0002\u0002\u0005\u0018!iQA\u0001\u0003\r\u00117)!\u0001\"\u0007\t\u001d\u0015\u0011A!\u0004\u0005\u0003\u000b\t!Y\u0002#\b\u0006\u0007\u0011q\u0001r\u0003\u0007\u0001\u000b\t!a\u0002c\u0006\u0006\u0007\u0011q\u0001\u0002\u0005\u0007\u0001\u000b\t!a\u0002\u0003\t\u0006\u0005\u0011-\u0001BB\u0003\u0004\t9A\u0019\u0003\u0004\u0001\u0006\u0007\u0011%\u0001B\u0005\u0007\u0001\u000b\r!a\u0002#\n\r\u0001\u0015\u0011AA\u0004E\u0013\u000b\t!a\u0002c\t\u0006\u0005\u0011A\u0001B\u0005\u0003\u0001\u0019\rI\"!B\u0001\t\t5\u001aB\u0001\u0019\u0003\u0019\u000b\u00052Q!\u0001\u0005\u0006\u0013\rI!!B\u0001\t\rU\u001b\u0001\"B\u0002\u0005\u000b%\t\u0001\u0012C\u0007\u0004\t%I\u0011\u0001#\u0005.#\u0011\tG!\u0006\u0002\u0006\u0003!M\u0001DC\u0011\u0003\u000b\u0005A!\u0002J\u0011V\u0007\u0019iQ\u0001B\u0006\n\u0003\u0011\u0005Q\"\u0001E\u000b[+!1\u0001'\u0002\"\u0007\u0015\t\u0001R\u0004G\u0001#\u000e\u0019AQA\u0005\u0002\u0011=iK\u0004B\u0001\u0019\u001fu5A\u0001\u0001\u0005\b\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t 5\u0011Q!\u0001\u0005\u0007!\u000e\u0005\u0011EA\u0003\u0002\u0011?\t6a\u0002\u0003\u0010\u0013\u0005A\u0001#D\u0001\t\u00135\t\u0001\u0012EW!\t\u0005A\n#(\u0004\u0005\u0001!\tRBA\u0003\u0002\u0011E\u00016\u0001AO\u000b\t\u0001AQ!\u0004\u0004\u0006\u0003!\r\u0012bA\u0005\u0003\u000b\u0005Aa\u0001UB\u0001C\t)\u0011\u0001\u0003\nR\u0007\u001d!\t#C\u0001\t&5\t\u0001bE\u0007\u0002\u0011O)$%B\u0011\u0005G\u0004AJ!(\u0006\u0005\u0001!)QBB\u0003\u0002\u0011\u0015I1!\u0003\u0002\u0006\u0003!1\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bB\u0007\u0003\u000b\u0005Aq\u0001UB\u0001C\t)\u0011\u0001C\u0002R\u0007\u001d!I!C\u0001\u0005\u00015\t\u0001\u0012C\u0007\u0002\u0011%\u0001"})
public final class CatchTranslator
extends AbstractTranslator {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final List<? extends JetCatchClause> catches;

    static {
        $kotlinClass = Reflection.createKotlinClass(CatchTranslator.class);
    }

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        JetCatchClause firstCatch = KotlinPackage.first(this.catches);
        JetParameter catchParameter = firstCatch.getCatchParameter();
        TranslationContext translationContext = this.context();
        JetParameter jetParameter = catchParameter;
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        JsName parameterName = translationContext.getNameForElement(jetParameter);
        JsNameRef parameterRef = parameterName.makeRef();
        JsScope jsScope = this.context().scope();
        String string = parameterRef.getIdent();
        JsNameRef jsNameRef = parameterRef;
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "parameterRef");
        return new JsCatch(jsScope, string, this.translateCatches(jsNameRef, this.catches.iterator()));
    }

    private final JsStatement translateCatches(@JetValueParameter(name="parameterRef") JsNameRef parameterRef, @JetValueParameter(name="catches") Iterator<? extends JetCatchClause> catches) {
        if (!catches.hasNext()) {
            return new JsThrow(parameterRef);
        }
        JetCatchClause jetCatchClause = catches.next();
        JetParameter jetParameter = jetCatchClause.getCatchParameter();
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        JetParameter param = jetParameter;
        JsName paramName = this.context().getNameForElement(param);
        JetTypeReference jetTypeReference = param.getTypeReference();
        if (jetTypeReference == null) {
            Intrinsics.throwNpe();
        }
        JetTypeReference paramType = jetTypeReference;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsBlock thenBlock = this.translateCatchBody(translationContext, jetCatchClause);
        if (Intrinsics.areEqual(paramName.getIdent(), parameterRef.getIdent()) ^ true) {
            thenBlock.getStatements().add(0, JsAstUtils.newVar(paramName, parameterRef));
        }
        if (this.getIsThrowable(paramType)) {
            return thenBlock;
        }
        PatternTranslator patternTranslator = Translation.patternTranslator(this.context());
        PatternTranslator $receiver = patternTranslator;
        JsExpression typeCheck = $receiver.translateIsCheck(parameterRef, paramType);
        JsStatement elseBlock = this.translateCatches(parameterRef, catches);
        return new JsIf(typeCheck, thenBlock, elseBlock);
    }

    private final JsBlock translateCatchBody(@JetValueParameter(name="context") TranslationContext context2, @JetValueParameter(name="catchClause") JetCatchClause catchClause) {
        JetExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context2) : context2.getEmptyExpression().makeStmt();
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean getIsThrowable(@JetValueParameter(name="$receiver") JetTypeReference $receiver) {
        JetType jetType = (JetType)BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $receiver);
        String jetTypeName = DescriptorUtilsPackage$descriptorUtils$c17fc7be.getJetTypeFqName(jetType, false);
        ClassDescriptor throwable = KotlinBuiltIns.getInstance().getThrowable();
        String throwableClassName = DescriptorUtils.getFqNameSafe(throwable).asString();
        return Intrinsics.areEqual(jetTypeName, throwableClassName);
    }

    @NotNull
    public final List<JetCatchClause> getCatches() {
        return this.catches;
    }

    public CatchTranslator(@JetValueParameter(name="catches") @NotNull List<? extends JetCatchClause> catches, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        Intrinsics.checkParameterIsNotNull(catches, "catches");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        super(context2);
        this.catches = catches;
    }
}

