/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\u0005\u0006)\u0019\"*\u0019<b\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003m_\u0006$'bD\"mCN\u001cH)\u0019;b\r&tG-\u001a:\u000b\u001bM,'/[1mSj\fG/[8o\u0015=!Wm]3sS\u0006d\u0017N_1uS>t'B\u0002\u001fj]&$hHC\tl_Rd\u0017N\\\"mCN\u001ch)\u001b8eKJT\u0011cS8uY&t7\t\\1tg\u001aKg\u000eZ3s\u0015y!Wm]3sS\u0006d\u0017N_3e\t\u0016\u001c8M]5qi>\u0014(+Z:pYZ,'O\u0003\u0010EKN,'/[1mSj,G\rR3tGJL\u0007\u000f^8s%\u0016\u001cx\u000e\u001c<fe*ia-\u001b8e\u00072\f7o\u001d#bi\u0006Tqa\u00197bgNLEMC\u0004DY\u0006\u001c8/\u00133\u000b\t9\fW.\u001a\u0006\n\u00072\f7o\u001d#bi\u00064(B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A\u0019!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0007!\u001dQa\u0001C\u0004\u0011\u000ba\u0001!B\u0002\u0005\u0005!)A\u0002A\u0003\u0004\t\tAa\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\"B\u0003\u0003\t\tAa!\u0002\u0002\u0005\u0003!AQa\u0001C\u0007\u0011\u001fa\u0001!B\u0002\u0005\u0007!EA\u0002A\u0003\u0003\t\rA\t\"\u0002\u0002\u0005\u000e!=Aa\u0001G\u00033\t)\u0011\u0001\u0003\u0003.\u0017\u0011\tG\u0001g\u0003\"\u0005\u0015\t\u0001\"B+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011\u0019i3\u0002B1\u00051\u0013\t#!B\u0001\t\nU\u001bA!B\u0002\u0005\n%\t\u00012B\u0017\u0015\t-Aj!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u001d\u00016\u0001A\u0011\u0004\u000b\u0005Ay\u0001$\u0001R\u0007\u0015!i!C\u0001\t\u00115\t\u0001\u0012C\u001b\u001f\u000bu!1\u001d\u0001\r\u0005;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001\u0012\u0002)\u0004\u0001u5A\u0001\u0001E\u0006\u001b\t)\u0011\u0001C\u0003Q\u0007\u0003\t#!B\u0001\t\u0006E\u001bq\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001E\u0006\u001b\u0005Aa\u0001"})
public final class JavaClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavaClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassData findClassData(@JetValueParameter(name="classId") @NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual(kotlinJvmBinaryClass2.getClassId(), classId);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData(kotlinJvmBinaryClass2, KotlinClassHeader.Kind.CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        return JvmProtoBufUtil.readClassDataFrom(data2);
    }

    public JavaClassDataFinder(@JetValueParameter(name="kotlinClassFinder") @NotNull KotlinClassFinder kotlinClassFinder, @JetValueParameter(name="deserializedDescriptorResolver") @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

