/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRendererBuilder;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;

public interface DescriptorRenderer
extends Renderer<DeclarationDescriptor> {
    public static final DescriptorRenderer COMPACT_WITH_MODIFIERS = new DescriptorRendererBuilder().setWithDefinedIn(false).build();
    public static final DescriptorRenderer COMPACT = new DescriptorRendererBuilder().setWithDefinedIn(false).setModifiers(new Modifier[0]).build();
    public static final DescriptorRenderer COMPACT_WITH_SHORT_TYPES = new DescriptorRendererBuilder().setModifiers(new Modifier[0]).setNameShortness(NameShortness.SHORT).setIncludeSynthesizedParameterNames(false).build();
    public static final DescriptorRenderer STARTS_FROM_NAME = new DescriptorRendererBuilder().setWithDefinedIn(false).setModifiers(new Modifier[0]).setStartFromName(true).build();
    public static final DescriptorRenderer ONLY_NAMES_WITH_SHORT_TYPES = new DescriptorRendererBuilder().setWithDefinedIn(false).setModifiers(new Modifier[0]).setNameShortness(NameShortness.SHORT).setWithoutTypeParameters(true).setWithoutFunctionParameterNames(true).setReceiverAfterName(true).setRenderCompanionObjectName(true).setWithoutSuperTypes(true).setStartFromName(true).build();
    public static final DescriptorRenderer FQ_NAMES_IN_TYPES = new DescriptorRendererBuilder().build();
    public static final DescriptorRenderer SHORT_NAMES_IN_TYPES = new DescriptorRendererBuilder().setNameShortness(NameShortness.SHORT).setIncludeSynthesizedParameterNames(false).build();
    public static final DescriptorRenderer DEBUG_TEXT = new DescriptorRendererBuilder().setDebugMode(true).setNameShortness(NameShortness.FULLY_QUALIFIED).build();
    public static final DescriptorRenderer FLEXIBLE_TYPES_FOR_CODE = new DescriptorRendererBuilder().setFlexibleTypesForCode(true).build();
    public static final DescriptorRenderer HTML_COMPACT_WITH_MODIFIERS = new DescriptorRendererBuilder().setWithDefinedIn(false).setTextFormat(TextFormat.HTML).build();
    public static final DescriptorRenderer HTML_NAMES_WITH_SHORT_TYPES = new DescriptorRendererBuilder().setWithDefinedIn(false).setNameShortness(NameShortness.SHORT).setRenderCompanionObjectName(true).setTextFormat(TextFormat.HTML).build();
    public static final DescriptorRenderer HTML = new DescriptorRendererBuilder().setTextFormat(TextFormat.HTML).build();
    public static final DescriptorRenderer HTML_FOR_UNINFERRED_TYPE_PARAMS = new DescriptorRendererBuilder().setUninferredTypeParameterAsName(true).setModifiers(new Modifier[0]).setNameShortness(NameShortness.SHORT).setTextFormat(TextFormat.HTML).build();

    @NotNull
    public String renderType(@NotNull JetType var1);

    @NotNull
    public String renderTypeArguments(@NotNull List<TypeProjection> var1);

    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor var1);

    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor var1);

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor var1);

    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor var1);

    @NotNull
    public String renderName(@NotNull Name var1);

    @NotNull
    public String renderFqName(@NotNull FqNameBase var1);

    public static class DefaultValueParameterHandler
    implements ValueParametersHandler {
        @Override
        public void appendBeforeValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder stringBuilder) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameters"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameters"));
            }
            stringBuilder.append("(");
        }

        @Override
        public void appendAfterValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder stringBuilder) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameters"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameters"));
            }
            stringBuilder.append(")");
        }

        @Override
        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, @NotNull StringBuilder stringBuilder) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameter"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameter"));
            }
        }

        @Override
        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, @NotNull StringBuilder stringBuilder) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameter"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameter"));
            }
            FunctionDescriptor function = (FunctionDescriptor)parameter.getContainingDeclaration();
            if (parameter.getIndex() != function.getValueParameters().size() - 1) {
                stringBuilder.append(", ");
            }
        }
    }

    public static interface ValueParametersHandler {
        public void appendBeforeValueParameters(@NotNull FunctionDescriptor var1, @NotNull StringBuilder var2);

        public void appendAfterValueParameters(@NotNull FunctionDescriptor var1, @NotNull StringBuilder var2);

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor var1, @NotNull StringBuilder var2);

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor var1, @NotNull StringBuilder var2);
    }

    public static enum Modifier {
        VISIBILITY,
        MODALITY,
        OVERRIDE,
        ANNOTATIONS,
        INNER,
        MEMBER_KIND;

    }

    public static enum OverrideRenderingPolicy {
        RENDER_OVERRIDE,
        RENDER_OPEN,
        RENDER_OPEN_OVERRIDE;

    }

    public static enum TextFormat {
        PLAIN,
        HTML;

    }
}

