/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.extension.InlineAnalyzerExtension;

public class FunctionAnalyzerExtension {
    private BindingTrace trace;

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "setTrace"));
        }
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "process"));
        }
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : bodiesResolveContext.getFunctions().entrySet()) {
            JetNamedFunction function = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            List<AnalyzerExtension> extensions = FunctionAnalyzerExtension.getExtensions(functionDescriptor);
            for (AnalyzerExtension extension : extensions) {
                extension.process(functionDescriptor, function, this.trace);
            }
        }
    }

    @NotNull
    private static List<AnalyzerExtension> getExtensions(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "getExtensions"));
        }
        ArrayList<AnalyzerExtension> list = new ArrayList<AnalyzerExtension>();
        if (functionDescriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)functionDescriptor).getInlineStrategy().isInline()) {
            list.add(InlineAnalyzerExtension.INSTANCE);
        }
        ArrayList<AnalyzerExtension> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "getExtensions"));
        }
        return arrayList;
    }

    public static interface AnalyzerExtension {
        public void process(@NotNull FunctionDescriptor var1, @NotNull JetNamedFunction var2, @NotNull BindingTrace var3);
    }
}

