/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.storage.ExceptionTracker;
import org.jetbrains.kotlin.storage.StorageManager;

public class TopDownAnalysisParameters
extends TypeLazinessToken
implements GlobalContext {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ExceptionTracker exceptionTracker;
    private final boolean analyzingBootstrapLibrary;
    private final boolean declaredLocally;
    private final boolean lazyTopDownAnalysis;

    @NotNull
    public static TopDownAnalysisParameters create(@NotNull StorageManager storageManager, @NotNull ExceptionTracker exceptionTracker, boolean analyzingBootstrapLibrary, boolean declaredLocally) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "create"));
        }
        if (exceptionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionTracker", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "create"));
        }
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(storageManager, exceptionTracker, analyzingBootstrapLibrary, declaredLocally, true);
        if (topDownAnalysisParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "create"));
        }
        return topDownAnalysisParameters;
    }

    @NotNull
    public static TopDownAnalysisParameters createForLocalDeclarations(@NotNull StorageManager storageManager, @NotNull ExceptionTracker exceptionTracker) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "createForLocalDeclarations"));
        }
        if (exceptionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionTracker", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "createForLocalDeclarations"));
        }
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(storageManager, exceptionTracker, false, true, false);
        if (topDownAnalysisParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "createForLocalDeclarations"));
        }
        return topDownAnalysisParameters;
    }

    private TopDownAnalysisParameters(@NotNull StorageManager storageManager, @NotNull ExceptionTracker exceptionTracker, boolean analyzingBootstrapLibrary, boolean declaredLocally, boolean lazyTopDownAnalysis) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "<init>"));
        }
        if (exceptionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionTracker", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "<init>"));
        }
        this.storageManager = storageManager;
        this.exceptionTracker = exceptionTracker;
        this.analyzingBootstrapLibrary = analyzingBootstrapLibrary;
        this.declaredLocally = declaredLocally;
        this.lazyTopDownAnalysis = lazyTopDownAnalysis;
    }

    @Override
    @NotNull
    public StorageManager getStorageManager() {
        StorageManager storageManager = this.storageManager;
        if (storageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "getStorageManager"));
        }
        return storageManager;
    }

    @Override
    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.exceptionTracker;
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisParameters", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    public boolean isAnalyzingBootstrapLibrary() {
        return this.analyzingBootstrapLibrary;
    }

    public boolean isDeclaredLocally() {
        return this.declaredLocally;
    }

    @Override
    @Deprecated
    public boolean isLazy() {
        return this.lazyTopDownAnalysis;
    }
}

