/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetRootPackageExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

public class DataFlowValueFactory {
    private static final IdentifierInfo NO_IDENTIFIER_INFO = new IdentifierInfo(null, false, false){

        public String toString() {
            return "NO_IDENTIFIER_INFO";
        }
    };

    private DataFlowValueFactory() {
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull JetExpression expression, @NotNull JetType type2, @NotNull BindingContext bindingContext) {
        JetConstantExpression constantExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (expression instanceof JetConstantExpression && (constantExpression = (JetConstantExpression)expression).getNode().getElementType() == JetNodeTypes.NULL) {
            DataFlowValue dataFlowValue = DataFlowValue.NULL;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (type2.isError()) {
            DataFlowValue dataFlowValue = DataFlowValue.ERROR;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (((Object)KotlinBuiltIns.getInstance().getNullableNothingType()).equals(type2)) {
            DataFlowValue dataFlowValue = DataFlowValue.NULL;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        IdentifierInfo result2 = DataFlowValueFactory.getIdForStableIdentifier(expression, bindingContext);
        DataFlowValue dataFlowValue = new DataFlowValue(result2 == NO_IDENTIFIER_INFO ? expression : result2.id, type2, result2.isStable, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ThisReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        JetType type2 = receiver.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(receiver, type2, true, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (receiverValue instanceof TransientReceiver || receiverValue instanceof ScriptReceiver) {
            JetType type2 = receiverValue.getType();
            boolean nullable2 = type2.isMarkedNullable() || TypeUtils.hasNullableSuperType(type2);
            DataFlowValue dataFlowValue = new DataFlowValue(receiverValue, type2, nullable2, Nullability.NOT_NULL);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ClassReceiver || receiverValue instanceof ExtensionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue((ThisReceiver)receiverValue);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(((ExpressionReceiver)receiverValue).getExpression(), receiverValue.getType(), bindingContext);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue == ReceiverValue.NO_RECEIVER) {
            throw new IllegalArgumentException("No DataFlowValue exists for ReceiverValue.NO_RECEIVER");
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        JetType type2 = variableDescriptor.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(variableDescriptor, type2, DataFlowValueFactory.isStableVariable(variableDescriptor), DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    private static Nullability getImmanentNullability(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        Nullability nullability = TypeUtils.isNullableType(type2) ? Nullability.UNKNOWN : Nullability.NOT_NULL;
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        return nullability;
    }

    @NotNull
    private static IdentifierInfo createInfo(Object id, boolean isStable) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, isStable, false);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createPackageInfo(Object id) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, true, true);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPackageInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo combineInfo(@Nullable IdentifierInfo receiverInfo, @NotNull IdentifierInfo selectorInfo) {
        if (selectorInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
        }
        if (selectorInfo.id == null) {
            IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        if (receiverInfo == null || receiverInfo == NO_IDENTIFIER_INFO || receiverInfo.isPackage) {
            IdentifierInfo identifierInfo = selectorInfo;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(Pair.create(receiverInfo.id, selectorInfo.id), receiverInfo.isStable && selectorInfo.isStable);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForStableIdentifier(@Nullable JetExpression expression, @NotNull BindingContext bindingContext) {
        JetExpression deparenthesized;
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        if (expression != null && expression != (deparenthesized = JetPsiUtil.deparenthesize(expression))) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForStableIdentifier(deparenthesized, bindingContext);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)expression;
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            JetExpression selectorExpression = qualifiedExpression.getSelectorExpression();
            IdentifierInfo receiverId = DataFlowValueFactory.getIdForStableIdentifier(receiverExpression, bindingContext);
            IdentifierInfo selectorId = DataFlowValueFactory.getIdForStableIdentifier(selectorExpression, bindingContext);
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverId, selectorId);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetSimpleNameExpression) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForSimpleNameExpression((JetSimpleNameExpression)expression, bindingContext);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetThisExpression) {
            JetThisExpression thisExpression = (JetThisExpression)expression;
            DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForThisReceiver(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetRootPackageExpression) {
            // empty if block
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForSimpleNameExpression(@NotNull JetSimpleNameExpression simpleNameExpression, @NotNull BindingContext bindingContext) {
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        if (declarationDescriptor instanceof VariableDescriptor) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(simpleNameExpression, bindingContext);
            IdentifierInfo receiverInfo = resolvedCall != null ? DataFlowValueFactory.getIdForImplicitReceiver(resolvedCall.getDispatchReceiver(), simpleNameExpression) : null;
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverInfo, DataFlowValueFactory.createInfo(variableDescriptor, DataFlowValueFactory.isStableVariable(variableDescriptor)));
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createPackageInfo(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        return identifierInfo;
    }

    @Nullable
    private static IdentifierInfo getIdForImplicitReceiver(@NotNull ReceiverValue receiverValue, @Nullable JetExpression expression) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForImplicitReceiver"));
        }
        if (receiverValue instanceof ThisReceiver) {
            return DataFlowValueFactory.getIdForThisReceiver(((ThisReceiver)receiverValue).getDeclarationDescriptor());
        }
        assert (!(receiverValue instanceof TransientReceiver)) : "Transient receiver is implicit for an explicit expression: " + expression + ". Receiver: " + receiverValue;
        return null;
    }

    @NotNull
    private static IdentifierInfo getIdForThisReceiver(@Nullable DeclarationDescriptor descriptorOfThisReceiver) {
        if (descriptorOfThisReceiver instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
            IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(receiverParameter.getValue(), true);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        if (descriptorOfThisReceiver instanceof ClassDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue(), true);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
        }
        return identifierInfo;
    }

    public static boolean isStableVariable(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isStableVariable"));
        }
        if (variableDescriptor.isVar()) {
            return false;
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (!DataFlowValueFactory.invisibleFromOtherModules(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.isFinal(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.hasDefaultGetter(propertyDescriptor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFinal(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable() && propertyDescriptor.getModality().isOverridable()) {
                return false;
            }
        } else if (propertyDescriptor.getModality().isOverridable()) {
            throw new IllegalStateException("Property outside a class must not be overridable: " + propertyDescriptor.getName());
        }
        return true;
    }

    private static boolean invisibleFromOtherModules(@NotNull DeclarationDescriptorWithVisibility descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "invisibleFromOtherModules"));
        }
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof DeclarationDescriptorWithVisibility)) {
            return false;
        }
        return DataFlowValueFactory.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        return getter == null || getter.isDefault();
    }

    private static class IdentifierInfo {
        public final Object id;
        public final boolean isStable;
        public final boolean isPackage;

        private IdentifierInfo(Object id, boolean isStable, boolean isPackage) {
            this.id = id;
            this.isStable = isStable;
            this.isPackage = isPackage;
        }
    }
}

