/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.JetType;

public class EnumValue
extends CompileTimeConstant<ClassDescriptor> {
    public EnumValue(@NotNull ClassDescriptor value, boolean usesVariableAsConstant) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/constants/EnumValue", "<init>"));
        }
        super(value, true, false, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getType"));
        }
        JetType type2 = ((ClassDescriptor)this.value).getClassObjectType();
        assert (type2 != null) : "Enum entry should have a companion object: " + this.value;
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public ClassDescriptor getValue() {
        ClassDescriptor value = (ClassDescriptor)super.getValue();
        assert (value != null) : "Guaranteed by constructor";
        ClassDescriptor classDescriptor = value;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getValue"));
        }
        return classDescriptor;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitEnumValue(this, data2);
    }

    public String toString() {
        return this.getType(KotlinBuiltIns.getInstance()) + "." + ((ClassDescriptor)this.value).getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((ClassDescriptor)this.value).equals(((EnumValue)o).value);
    }

    public int hashCode() {
        return ((ClassDescriptor)this.value).hashCode();
    }
}

