/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.extension;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.types.JetType;

public class InlineAnalyzerExtension
implements FunctionAnalyzerExtension.AnalyzerExtension {
    public static final InlineAnalyzerExtension INSTANCE = new InlineAnalyzerExtension();

    private InlineAnalyzerExtension() {
    }

    @Override
    public void process(final @NotNull FunctionDescriptor descriptor, @NotNull JetNamedFunction function, final @NotNull BindingTrace trace) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "process"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "process"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "process"));
        }
        assert (descriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline()) : "This method should be invoced on inline function: " + descriptor;
        InlineAnalyzerExtension.checkDefaults(descriptor, function, trace);
        InlineAnalyzerExtension.checkNotVirtual(descriptor, function, trace);
        InlineAnalyzerExtension.checkHasInlinableAndNullability(descriptor, function, trace);
        JetVisitorVoid visitor2 = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension$1", "visitJetElement"));
                }
                super.visitJetElement(element);
                element.acceptChildren(this);
            }

            @Override
            public void visitClass(@NotNull JetClass klass) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension$1", "visitClass"));
                }
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(klass, klass, descriptor));
            }

            @Override
            public void visitNamedFunction(@NotNull JetNamedFunction function) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension$1", "visitNamedFunction"));
                }
                if (function.getParent().getParent() instanceof JetObjectDeclaration) {
                    super.visitNamedFunction(function);
                } else {
                    trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(function, function, descriptor));
                }
            }
        };
        function.acceptChildren(visitor2);
    }

    private static void checkDefaults(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkDefaults"));
        }
        int index2 = 0;
        List<JetParameter> jetParameters = function.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            JetParameter jetParameter;
            if (parameter.hasDefaultValue() && (InlineAnalyzerExtension.checkInlinableParameter(parameter, jetParameter = jetParameters.get(index2), functionDescriptor, null) || !parameter.declaresDefaultValue())) {
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(jetParameter, jetParameter, functionDescriptor));
            }
            ++index2;
        }
    }

    private static void checkNotVirtual(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (Visibilities.isPrivate(functionDescriptor.getVisibility()) || functionDescriptor.getModality() == Modality.FINAL) {
            return;
        }
        if (functionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on(function));
    }

    private static void checkHasInlinableAndNullability(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        boolean hasInlinable = false;
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        int index2 = 0;
        for (ValueParameterDescriptor parameter : parameters2) {
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(parameter, function.getValueParameters().get(index2++), functionDescriptor, trace);
        }
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            JetTypeReference receiver = function.getReceiverTypeReference();
            assert (receiver != null) : "Descriptor has a receiver but psi doesn't " + function.getText();
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(receiverParameter, receiver, functionDescriptor, trace);
        }
        if (!(hasInlinable |= DescriptorUtils.containsReifiedTypeParameters(functionDescriptor))) {
            trace.report(Errors.NOTHING_TO_INLINE.on(function, functionDescriptor));
        }
    }

    public static boolean checkInlinableParameter(@NotNull CallableDescriptor parameter, @NotNull JetElement expression, @NotNull CallableDescriptor functionDescriptor, @Nullable BindingTrace trace) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        JetType type2 = parameter.getReturnType();
        if (type2 != null && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2) && !InlineUtil.hasNoinlineAnnotation(parameter)) {
            if (type2.isMarkedNullable()) {
                if (trace != null) {
                    trace.report(Errors.NULLABLE_INLINE_PARAMETER.on(expression, expression, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

