/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.utils.Printer;

public final class JetScopeUtils {
    private JetScopeUtils() {
    }

    @NotNull
    public static List<ReceiverValue> getImplicitReceiversHierarchyValues(@NotNull JetScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getImplicitReceiversHierarchyValues"));
        }
        List<ReceiverParameterDescriptor> hierarchy = scope2.getImplicitReceiversHierarchy();
        ArrayList<ReceiverValue> arrayList = Lists.newArrayList(Collections2.transform(hierarchy, new Function<ReceiverParameterDescriptor, ReceiverValue>(){

            @Override
            public ReceiverValue apply(ReceiverParameterDescriptor receiverParameterDescriptor) {
                return receiverParameterDescriptor.getValue();
            }
        }));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getImplicitReceiversHierarchyValues"));
        }
        return arrayList;
    }

    public static JetScope makeScopeForPropertyAccessor(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope parentScope, @NotNull BindingTrace trace) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        JetScope propertyDeclarationInnerScope = JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, parentScope, propertyDescriptor.getTypeParameters(), propertyDescriptor.getExtensionReceiverParameter(), trace);
        WritableScopeImpl accessorScope = new WritableScopeImpl(propertyDeclarationInnerScope, parentScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(trace), "Accessor Scope");
        accessorScope.changeLockLevel(WritableScope.LockLevel.READING);
        return accessorScope;
    }

    public static JetScope getPropertyDeclarationInnerScope(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull RedeclarationHandler redeclarationHandler) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationHandler", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        return JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, outerScope, propertyDescriptor.getTypeParameters(), propertyDescriptor.getExtensionReceiverParameter(), redeclarationHandler, true);
    }

    public static JetScope getPropertyDeclarationInnerScope(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, BindingTrace trace) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        return JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, outerScope, typeParameters, receiver, trace, true);
    }

    public static JetScope getPropertyDeclarationInnerScopeForInitializer(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, BindingTrace trace) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScopeForInitializer"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScopeForInitializer"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScopeForInitializer"));
        }
        return JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, outerScope, typeParameters, receiver, trace, false);
    }

    private static JetScope getPropertyDeclarationInnerScope(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, BindingTrace trace, boolean addLabelForProperty) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        TraceBasedRedeclarationHandler redeclarationHandler = new TraceBasedRedeclarationHandler(trace);
        return JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, outerScope, typeParameters, receiver, redeclarationHandler, addLabelForProperty);
    }

    @NotNull
    private static JetScope getPropertyDeclarationInnerScope(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, @NotNull RedeclarationHandler redeclarationHandler, boolean addLabelForProperty) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationHandler", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        WritableScopeImpl result2 = new WritableScopeImpl(outerScope, propertyDescriptor, redeclarationHandler, "Property declaration inner scope");
        if (addLabelForProperty) {
            result2.addLabeledDeclaration(propertyDescriptor);
        }
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            result2.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        if (receiver != null) {
            result2.setImplicitReceiver(receiver);
        }
        result2.changeLockLevel(WritableScope.LockLevel.READING);
        WritableScopeImpl writableScopeImpl = result2;
        if (writableScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        return writableScopeImpl;
    }

    @NotNull
    public static String printStructure(@Nullable JetScope scope2) {
        StringBuilder out = new StringBuilder();
        Printer p = new Printer(out);
        if (scope2 == null) {
            p.println("null");
        } else {
            scope2.printScopeStructure(p);
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/JetScopeUtils", "printStructure"));
        }
        return string;
    }
}

