/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import com.google.protobuf.ExtensionRegistryLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;

public class JvmProtoBufUtil {
    private JvmProtoBufUtil() {
    }

    @NotNull
    public static ExtensionRegistryLite getExtensionRegistry() {
        ExtensionRegistryLite registry = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(registry);
        ExtensionRegistryLite extensionRegistryLite = registry;
        if (extensionRegistryLite == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "getExtensionRegistry"));
        }
        return extensionRegistryLite;
    }

    @NotNull
    public static ClassData readClassDataFrom(@NotNull String[] encodedData) {
        if (encodedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encodedData", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "readClassDataFrom"));
        }
        ClassData classData = ClassData.read(BitEncoding.decodeBytes(encodedData), JvmProtoBufUtil.getExtensionRegistry());
        if (classData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "readClassDataFrom"));
        }
        return classData;
    }

    @NotNull
    public static PackageData readPackageDataFrom(@NotNull String[] encodedData) {
        if (encodedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encodedData", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "readPackageDataFrom"));
        }
        PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(BitEncoding.decodeBytes(encodedData));
        if (packageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "readPackageDataFrom"));
        }
        return packageData;
    }

    @NotNull
    public static PackageData readPackageDataFrom(@NotNull byte[] data2) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "readPackageDataFrom"));
        }
        PackageData packageData = PackageData.read(data2, JvmProtoBufUtil.getExtensionRegistry());
        if (packageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil", "readPackageDataFrom"));
        }
        return packageData;
    }
}

