/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\"\n)i2j\u001c;mS:T\u0015M^1tGJL\u0007\u000f^'fi\u0006$\u0017\r^1Vi&d7OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015)H/\u001b7t\u0015\r\te.\u001f\u0006\f\u0003\nKuLV#S'&{eJC\u0002J]RTaAS*`\u000bb#&BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0011bZ3u\u0015N{V\t\u0017+\u000b;-{E\u000bT%O?*\u000be+Q*D%&\u0003FkX'F)\"{Ei\u0018(B\u001b\u0016S1\u0001T(H\u0015\u0019aunZ4fe*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006eS\u0006<gn\\:uS\u000eTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b!5+E+\u0011#B)\u0006{\u0006+\u0011+U\u000bJs%b\u0002)biR,'O\u001c\u0006\u0005kRLGNC\u0003sK\u001e,\u0007PC\u0006iCNlU\r^1eCR\f'\u0002\u0002;fqRTqAQ8pY\u0016\fgN\u0003\u0007m_\u0006$W*\u001a;bI\u0006$\u0018M\u0003\u0003gS2,'\u0002\u0002$jY\u0016T!![8\u000b\t1K7\u000f\u001e\u0006\u0019\u0017>$H.\u001b8KCZ\f7o\u0019:jaRlU\r^1eCR\f'\u0002\u00029bi\"T\u0011\u0004\\8bI6+G/\u00193bi\u00064%o\\7ESJ,7\r^8ss*\u0019A-\u001b:\u000b\u00195,G/\u00193bi\u0006d\u0015n\u001d;\u000b\u00175+H/\u00192mK2K7\u000f\u001e\u0006\u0005+:LGO\u0003\u000bm_\u0006$W*\u001a;bI\u0006$\u0018M\u0012:p[\u001aKG.\u001a\u0006\u0014Y>\fG-T3uC\u0012\fG/\u0019$s_6T\u0016\u000e\u001d\u0006\u000ea\u0006\u00148/Z'fi\u0006$\u0017\r^1\u000b\u001b]\u0014\u0018\u000e^3NKR\fG-\u0019;b\u0015)iw\u000eZ;mK:\u000bW.\u001a\u0006\bG>tG/\u001a8u\u0015%\u0011\u0015\u0010^3BeJ\f\u0017P\u0003\u0005nKR\fg)\u001b7f%\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0002\t\u00061\u0001Qa\u0001C\u0003\u0011\u000fa\u0001!B\u0002\u0005\u0006!%A\u0002A\u0003\u0002\u0011\u0015)!\u0001\"\u0003\t\f\u0015\u0011A!\u0002E\u0005\u000b\u0005A\u0001\"\u0002\u0002\u0005\r!EQA\u0001C\u0007\u0011%)!\u0001B\u0004\t\u0014\u0015\u0019Aq\u0002E\b\u0019\u0001)!\u0001b\u0004\t\u0010\u0015\u0011A\u0011\u0002E\f\u000b\t!\u0011\u0002\u0003\u0007\u0006\u0007\u0011M\u0001b\u0003\u0007\u0001\u000b\t!\u0019\u0002C\u0006\u0006\u0007\u0011\u0015\u00012\u0004\u0007\u0001\u000b\t!I\u0001c\b\u0006\u0007\u0011]\u0001b\u0004\u0007\u0001\u000b\r!)\u0001\u0003\t\r\u0001\u0015\u0019A1\u0001E\u0011\u0019\u0001)!\u0001B\u0005\t!\u0015\u0011Aq\u0003\u0005\u0010\u000b\r!)\u0001C\n\r\u0001\u0015\u0019AQ\u0001E\u0014\u0019\u0001)1\u0001\"\u0002\t/1\u0001AaY\u0001\r\u0005e\u0011Q!\u0001\u0005\u0004[-!\u0011\r\u0006\r\u0004C\t)\u0011\u0001c\u0002V\u0007\u0011)1\u0001B\u0002\n\u0003\u0011\u0015Qf\u0004\u0003d)a!\u0011EA\u0003\u0002\u0011\u0011)6\u0001C\u0003\u0004\t\u0011I\u0011\u0001c\u0003\u000e\u0007\u00111\u0011\"\u0001E\u0006[-!\u0011\r\u0006M\u0007C\t)\u0011\u0001\u0003\u0003V\u0007\u0011)1\u0001\"\u0004\n\u0003!-Q\u0006\u0005\u0003b\ta9\u0011eB\u0003\u0002\u0011!\u0001\"\"F\u0002\u0006\u0003!AA\u0012A+\u0004\t\u0015\u0019AaB\u0005\u0002\u0011#i3\u0002B1\u00051+\t#!B\u0001\t\u0015U\u001bA!B\u0002\u0005\u0016%\t\u0001RC\u0017\u0014\t\u000fAJ\"(\u0004\u0005\u0001!iQBA\u0003\u0002\u0011\u0011\u00016\u0001A\u0011\u0003\u000b\u0005A1\"U\u0002\u0006\t3I\u0011\u0001\"\u0001\u000e\u0003!-Qf\u0006C\u000419ij\u0001\u0002\u0001\t\u001e5\u0011Q!\u0001\u0005\r!\u000e\u0001\u0011EB\u0003\u0002\u00113I1!\u0003\u0002\u0006\u0003!i\u0011kA\u0003\u0005\u001d%\t\u00012D\u0007\u0002\u00119is\u0003b\u0002\u0019\u001du5A\u0001\u0001\u0005\u0012\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001\tc!B\u0001\t\u001a%\u0019\u0011BA\u0003\u0002\u00115\t6!\u0002\u0003\u000f\u0013\u0005AY\"D\u0001\t\f5\u0006C!\u0001M\u0012;\u001b!\u0001\u0001\u0003\n\u000e\u0005\u0015\t\u0001\u0002\u0004)\u0004\u0001uUA\u0001\u0001E\u0013\u001b\u0019)\u0011\u0001#\b\n\u0007%\u0011Q!\u0001\u0005\u000e!\u000e\u0005\u0011EA\u0003\u0002\u0011=\t6a\u0002C\u0012\u0013\u0005!\u0001!D\u0001\t\u001d5\t\u00012DW!\t\u0005AB#(\u0004\u0005\u0001!uQBA\u0003\u0002\u00111\u00016\u0001AO\u000b\t\u0001A)#\u0004\u0004\u0006\u0003!u\u0011bA\u0005\u0003\u000b\u0005AQ\u0002UB\u0001C\t)\u0011\u0001C\bR\u0007\u001d!A#C\u0001\u0005\u00015\t\u0001BD\u0007\u0002\u00117i\u000b\u0005B\u0001\u0019*u5A\u0001\u0001E\u000f\u001b\t)\u0011\u0001\u0003\u0007Q\u0007\u0001i*\u0002\u0002\u0001\t&51Q!\u0001E\u000f\u0013\rI!!B\u0001\t\u001bA\u001b\t!\t\u0002\u0006\u0003!y\u0011kA\u0004\u0005*%\tA\u0001A\u0007\u0002\u00119i\u0011\u0001c\u0007.U\u0011\t\u0001$FO\u0007\t\u0001AQ\"\u0004\u0002\u0006\u0003!!\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\"E\u0007\u0003\u000b\u0005AA\u0001UB\u0001;+!\u0001\u0001#\n\u000e\r\u0015\t\u0001RD\u0005\u0004\u0013\t)\u0011\u0001C\u0007Q\u0007\u0005\t#!B\u0001\t\u001fE\u001b\u0011\u0002B\u000b\n\u0003\u0011\u0001Q\"\u0001E\u0006\u001b\u0005AY!D\u0001\t\u001c5:Ca\u0001M\u0016;\u001b!\u0001\u0001\u0003\f\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001u5A\u0001\u0001E\u0017\u001b\t)\u0011\u0001c\bQ\u0007\u0003ij\u0001\u0002\u0001\t05\u0011Q!\u0001\u0005\r!\u000e\t\u0011EA\u0003\u0002\u0011=\t6A\u0003C\u0016\u0013\u0005!\u0001!D\u0001\t\f5\u0011A1\u0001G\u0001\u001b\u0005Aa\"\u000e\u0001"})
public final class KotlinJavascriptMetadataUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final String JS_EXT = ".js";
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    private static final Pattern METADATA_PATTERN;
    private static final int ABI_VERSION = 1;
    public static final KotlinJavascriptMetadataUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavascriptMetadataUtils.class);
        new KotlinJavascriptMetadataUtils();
    }

    @NotNull
    public final String getJS_EXT() {
        return JS_EXT;
    }

    @platformStatic
    public static final boolean hasMetadata(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return METADATA_PATTERN.matcher(text).find();
    }

    public final void writeMetadata(@JetValueParameter(name="moduleName") @NotNull String moduleName, @JetValueParameter(name="content") @NotNull byte[] content, @JetValueParameter(name="metaFile") @NotNull File metaFile) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(content, "content");
        Intrinsics.checkParameterIsNotNull(metaFile, "metaFile");
        String text = "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + "(" + ABI_VERSION + ", " + "\"" + moduleName + "\"" + ", " + "\"" + DatatypeConverter.printBase64Binary((byte[])content) + "\"" + ");" + "\n";
        FileUtil.writeToFile(metaFile, text);
    }

    @platformStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@JetValueParameter(name="file") @NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        boolean bl = file.exists();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "Library " + file + " not found";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List result2 = KotlinPackage.arrayListOf(new KotlinJavascriptMetadata[0]);
        if (file.isDirectory()) {
            INSTANCE$.loadMetadataFromDirectory(file, result2);
        } else if (KotlinPackage.endsWith(file.getName(), JS_EXT)) {
            INSTANCE$.loadMetadataFromFile(file, result2);
        } else {
            INSTANCE$.loadMetadataFromZip(file, result2);
        }
        return result2;
    }

    @platformStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@JetValueParameter(name="path") @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    private final void parseMetadata(@JetValueParameter(name="text") String text, @JetValueParameter(name="path") String path, @JetValueParameter(name="metadataList") List<KotlinJavascriptMetadata> metadataList) {
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            int abiVersion = Integer.parseInt(matcher.group(1));
            if (abiVersion != ABI_VERSION) {
                LOG.error("Unsupported abi version in " + path + ", expected " + ABI_VERSION + ", but " + abiVersion);
            }
            String moduleName = matcher.group(3);
            String data2 = matcher.group(5);
            String string = moduleName;
            Intrinsics.checkExpressionValueIsNotNull(string, "moduleName");
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)data2);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "parseBase64Binary(data)");
            metadataList.add(new KotlinJavascriptMetadata(string, byArray));
        }
    }

    private final void loadMetadataFromFile(@JetValueParameter(name="file") File file, @JetValueParameter(name="metadataList") List<KotlinJavascriptMetadata> metadataList) {
        try {
            String content;
            String string = content = FileUtil.loadFile(file);
            Intrinsics.checkExpressionValueIsNotNull(string, "content");
            String string2 = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string2, "file.getPath()");
            this.parseMetadata(string, string2, metadataList);
        }
        catch (IOException ex) {
            LOG.error("Could not read " + file.getAbsolutePath() + ": " + ex.getMessage());
        }
    }

    private final void loadMetadataFromDirectory(@JetValueParameter(name="dir") File dir, @JetValueParameter(name="metadataList") List<KotlinJavascriptMetadata> metadataList) {
        LibraryUtils.INSTANCE$.traverseDirectory(dir, (Function2<? super File, ? super String, ? extends Unit>)new Function2<File, String, Unit>(metadataList){
            final /* synthetic */ List $metadataList;

            public final void invoke(@JetValueParameter(name="file") @NotNull File file, @JetValueParameter(name="relativePath") @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                String string = FileUtil.loadFile(file);
                Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.loadFile(file)");
                String string2 = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull(string2, "file.getPath()");
                KotlinJavascriptMetadataUtils.access$parseMetadata$0(KotlinJavascriptMetadataUtils.INSTANCE$, string, string2, this.$metadataList);
            }
            {
                this.$metadataList = list;
            }
        });
    }

    private final void loadMetadataFromZip(@JetValueParameter(name="file") File file, @JetValueParameter(name="metadataList") List<KotlinJavascriptMetadata> metadataList) {
        LibraryUtils.INSTANCE$.traverseArchive(file, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(file, metadataList){
            final /* synthetic */ File $file;
            final /* synthetic */ List $metadataList;

            public final void invoke(@JetValueParameter(name="content") @NotNull String content, @JetValueParameter(name="relativePath") @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                KotlinJavascriptMetadataUtils.access$parseMetadata$0(KotlinJavascriptMetadataUtils.INSTANCE$, content, this.$file.getPath() + "/" + relativePath, this.$metadataList);
            }
            {
                this.$file = file;
                this.$metadataList = list;
            }
        });
    }

    KotlinJavascriptMetadataUtils() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(KotlinJavascriptMetadataUtils.class);
        JS_EXT = JS_EXT;
        KOTLIN_JAVASCRIPT_METHOD_NAME = KOTLIN_JAVASCRIPT_METHOD_NAME;
        METADATA_PATTERN = KotlinPackage.toRegex$default("(?m)" + "\\" + "w+" + "\\" + "." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\" + "((" + "\\" + "d+)," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "2," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "4" + "\\" + ")", 0, 1);
        ABI_VERSION = 1;
    }

    public static final /* synthetic */ void access$parseMetadata$0(@JetValueParameter(name="$this", type="?") KotlinJavascriptMetadataUtils $this, @JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="metadataList") @NotNull List<KotlinJavascriptMetadata> metadataList) {
        $this.parseMetadata(text, path, metadataList);
    }
}

