/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"'\u0012)aA*\u001b2sCJLX\u000b^5mg*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0003vi&d7OC\u0002B]fTqdS(U\u0019&suLS*`\u001b>#U\u000bT#`\u0003R#&+\u0013\"V)\u0016{f*Q'F\u0015\u0011q\u0015-\\3\u000b\u0015\u0005#HO]5ckR,7O\u0003\u0003kCZ\f'\u0002B;uS2T1A[1s\u0015=\tE\u000f\u001e:jEV$Xm\u001d\u0013OC6,'\"F&P)2Kej\u0018&T?6{E)\u0016'F?:\u000bU*\u0012\u0006\u0007'R\u0014\u0018N\\4\u000b\t1\fgn\u001a\u0006\u0019O\u0016$8j\u0014+M\u0013:{&jU0N\u001f\u0012+F*R0O\u00036+%b\u0001'P\u000f*1Aj\\4hKJT1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u000bI&\fwM\\8ti&\u001c'bF6pi2LgN\f6w[:\u0002F.\u0019;g_JlG+\u001f9f\u00155i\u0015IT%G\u000bN#v\fU!U\u0011*9Q*\u0012+B\u0013:3%\"E'F)\u0006KeJR0S\u000bN{UKU\"F'*YB+\u0013+M\u000b~[u\n\u0016'J\u001d~S\u0015IV!T\u0007JK\u0005\u000bV0M\u0013\nSa\u0004V%U\u0019\u0016{6j\u0014+M\u0013:{&*\u0011,B'\u000e\u0013\u0016\n\u0015+`'R#E*\u0013\"\u000b'\rDWmY6BiR\u0014\u0018NY;uKZ\u000bG.^3\u000b\u000f1L'M]1ss*!a)\u001b7f\u0015\tIwN\u0003\u0005fqB,7\r^3e\u00155\tG\u000f\u001e:jEV$XMT1nK*9!i\\8mK\u0006t'\u0002G2pafT5OR5mKN4%o\\7ESJ,7\r^8ss*\u0019A-\u001b:\u000b'=,H\u000f];u\u0019&\u0014'/\u0019:z\u0015N\u0004\u0016\r\u001e5\u000b\tUs\u0017\u000e\u001e\u0006\u0019G>\u0004\u0018PS:GS2,7O\u0012:p[2K'M]1sS\u0016\u001c(\"\u00037jEJ\f'/[3t\u0015\u0011a\u0015n\u001d;\u000b%\r|\u0007/\u001f&t\r&dWm\u001d$s_6T\u0016\u000e\u001d\u0006\u0005M&dWM\u0003\u0006hKRT\u0015M\u001d$jY\u0016TAb\u00197bgN,7OU8piNT1BV5siV\fGNR5mK*\u0019aOZ:\u000b\u000f)\f'OT1nK*)r-\u001a;L_Rd\u0017N\u001c&t\u001b>$W\u000f\\3OC6,'\u0002G4fi6\u000bg.\u001b4fgR4%o\\7ESJ,7\r^8ss*AQ*\u00198jM\u0016\u001cHO\u0003\nhKRl\u0015M\\5gKN$hI]8n\u0015\u0006\u0014(\"H4fi6\u000bg.\u001b4fgR4%o\\7KCJ|%\u000fR5sK\u000e$xN]=\u000bW\u001d,G/T1oS\u001a,7\u000f^'bS:\fE\u000f\u001e:jEV$Xm\u001d$s_6T\u0015M](s\t&\u0014Xm\u0019;pefT\u0001cZ3u'V<w-Z:uK\u0012\u0004\u0016\r\u001e5\u000b\tA\fG\u000f\u001b\u0006\u001aSN\\u\u000e\u001e7j]*\u000bg/Y:de&\u0004H\u000fT5ce\u0006\u0014\u0018PC\u0013jg.{G\u000f\\5o\u0015\u00064\u0018m]2sSB$H*\u001b2sCJLx+\u001b;i\u001b\u0016$\u0018\rZ1uC*a\u0012n]&pi2LgNS1wCN\u001c'/\u001b9u'R$G*\u001b2sCJL(\u0002H5t\u001f2$7j\u001c;mS:T\u0015M^1tGJL\u0007\u000f\u001e'jEJ\f'/\u001f\u0006\u0011aJ|7-Z:t\t&\u0014Xm\u0019;pefTa!Y2uS>t'\"\u0003$v]\u000e$\u0018n\u001c83\u0015-\u0011X-\u00193Kg\u001aKG.Z:\u000b\u001fQ\u0014\u0018M^3sg\u0016\f%o\u00195jm\u0016T\u0011\u0003\u001e:bm\u0016\u00148/\u001a#je\u0016\u001cGo\u001c:z\u0015)\u0001&o\u001c9feRLWm\u001d\u0006\u0012O\u0016$\bK]8qKJ$\u0018p\u0014:GC&d'\u0002\u00039s_Bt\u0015-\\3\u007f\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019AQ\u0001E\u0003\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011\u001d\u0001\"B\u0003\u0003\t\u0011AY!B\u0002\u0005\n!!A\u0002A\u0003\u0004\t\u0015A9\u0001\u0004\u0001\u0006\u0005\u0011%\u0001BB\u0003\u0004\t\u000bAq\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001rB\u0003\u0003\t\u001dAq!B\u0001\t\u0014\u0015\u0011A\u0001\u0003\u0005\u000b\u000b\t!\t\u0002#\u0006\u0006\u0005\u0011I\u0001bC\u0003\u0004\t'A\u0011\u0002\u0004\u0001\u0006\u0005\u0011M\u0001\"C\u0003\u0003\t\u000fA\u0001#B\u0002\u0005\u0017!}A\u0002A\u0003\u0004\t\u000bA\u0019\u0003\u0004\u0001\u0006\u0005\u0011Y\u0001rD\u0003\u0004\t\u000bA9\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001\"\u0006\u0007\u0001\u000b\t!A\u0001C\u000b\u0006\u0005\u0011I\u0001\u0002G\u0003\u0004\t;Ay\u0003\u0004\u0001\u0006\u0005\u0011u\u0001rF\u0003\u0004\t\u0013A!\u0004\u0004\u0001\u0006\u0005\u0011%\u0001BG\u0003\u0003\t\u0013AA!B\u0002\u0005\u0006!\u0001C\u0002A\u0003\u0003\t\u000bA\u0001%B\u0002\u0005\t!\u0011C\u0002A\u0003\u0003\t\u0011A!\u0005B2\u0002\u0019\tI\"!B\u0001\t\u00075ZA!\u0019\u0003\u0019\u0007\u0005\u0012Q!\u0001E\u0006+\u000e!Qa\u0001\u0003\u0004\u0013\u0005Aa!L\b\u0005GRAj!\t\u0002\u0006\u0003!5Qk\u0001\u0005\u0006\u0007\u00115\u0011\"\u0001E\b\u001b\r!\u0001\"C\u0001\t\u00105\u0002B!\u0019\u0003\u0019\u0012\u0005:Q!\u0001\u0005\u000b!/)2!B\u0001\t\u00151\u0005Qk\u0001\u0003\u0006\u0007\u0011E\u0011\"\u0001E\u000b[-!\u0011\r\u0006\r\rC\t)\u0011\u0001#\u0004V\u0007\u0011)1\u0001\u0002\u0007\n\u0003!=Qf\u0003\u0003b)ae\u0011EA\u0003\u0002\u0011\u001b)6\u0001B\u0003\u0004\t3I\u0011\u0001c\u0004.\u0017\u0011\tG\u0003G\u0007\"\u0005\u0015\t\u0001RB+\u0004\t\u0015\u0019A!D\u0005\u0002\u0011\u001fi3\u0002Ba\r17\t#!B\u0001\t\u000eU\u001bA!B\u0002\u0005\u001c%\t\u0001rB\u0017\f\t\u0005g\u0001DD\u0011\u0003\u000b\u0005Ai!V\u0002\u0005\u000b\r!a\"C\u0001\t\u001052C!\u0001M\u000f;\u001b!\u0001\u0001C\b\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001u5A\u0001\u0001E\u0011\u001b\t)\u0011\u0001#\u0004Q\u0007\u0003ij\u0001\u0002\u0001\t#5\u0011Q!\u0001E\u0006!\u000e\t\u0011EA\u0003\u0002\u00111\t6!\u0003C\u000f\u0013\u0005!\t!D\u0001\t\u001a5\t\u0001rB\u0007\u0002\u0011\u0019iK\u0004B\u0001\u0019%u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\u0007!\u000e\u0005\u0011EA\u0003\u0002\u00115\t6a\u0002\u0003\u0013\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001rBW!\t\u000fAB#(\u0006\u0005\u0001!%RBB\u0003\u0002\u00117I1!\u0003\u0002\u0006\u0003!5\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bE\u0007\u0003\u000b\u0005Ai\u0001UB\u0001C\t)\u0011\u0001C\u0007R\u0007\u001d!A#C\u0001\u0005\u00015\t\u0001BD\u0007\u0002\u0011\u001fiK\u0004B\u0001\u0019,u5A\u0001\u0001\u0005\u0017\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\u0007!\u000e\u0005\u0011EA\u0003\u0002\u00115\t6a\u0002C\u0016\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001rBW\"\t\u000fAj#(\u0006\u0005\u0001!9RBB\u0003\u0002\u00117I1!\u0003\u0002\u0006\u0003!y\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012G\u0007\u0003\u000b\u0005Ai\u0001UB\u0001C\r)\u0011\u0001C\b\r\u0002E\u001bq\u0001\"\f\n\u0003!}Q\"\u0001\u0005\u000f\u001b\u0005Ay!\f\u000b\u0005\baIRT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!5A\u0012A)\u0004\u000b\u0011I\u0012\"\u0001E\b\u001b\u0005AI\"\f\u000b\u0005\u0003aMRT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0001B\u0012A)\u0004\u000b\u0011M\u0012\"\u0001E\u0011\u001b\u0005AI\"\f\u000b\u0005\u0003aURT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0001B\u0012A)\u0004\u000b\u0011U\u0012\"\u0001E\u0011\u001b\u0005AI\"\f\u000b\u0005\u0003aYRT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0001B\u0012A)\u0004\u000b\u0011Y\u0012\"\u0001E\u0011\u001b\u0005AI\"\f\u000b\u0005\u0003a]RT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!)A\u0012A)\u0004\u000b\u0011]\u0012\"\u0001\u0005\u0012\u001b\u0005AI\"\f\u000b\u0005\u0003aaRT\u0002\u0003\u0001\u0011si!!B\u0001\t\u000eA\u001b\u0001!I\u0002\u0006\u0003!5A\u0012A)\u0004\u000b\u0011a\u0012\"\u0001E\b\u001b\u0005Ay!L\n\u0005\baiRT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0018A\u001b\u0001!\t\u0002\u0006\u0003!a\u0011kA\u0003\u0005;%\tA\u0011A\u0007\u0002\u00113i3\u0003b\u0002\u0019<u5A\u0001\u0001\u0005\u0010\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001\t#!B\u0001\t\u0019E\u001bQ\u0001b\u000f\n\u0003\u0011\u0005Q\"\u0001E\r[M!9\u0001\u0007\u0010\u001e\u000e\u0011\u0001\u0001bD\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0001C\t)\u0011\u0001\u0003\u0007R\u0007\u0015!a$C\u0001\u0005\u00025\t\u0001\u0012D\u0017\u0014\t\u000fAj$(\u0004\u0005\u0001!yQBA\u0003\u0002\u0011/\u00016\u0001A\u0011\u0003\u000b\u0005AA\"U\u0002\u0006\t{I\u0011\u0001\"\u0001\u000e\u0003!eQ\u0016\u000b\u0003\u00021}ij\u0001\u0002\u0001\t&5\u0011Q!\u0001E\f!\u000e\u0001QT\u0005\u0003\u0001\u0011\u007fia\"B\u0001\t$%\u0019\u0011BA\u0003\u0002\u0011/I1!\u0003\u0002\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005AQ\u0002UB\u0001C\t)\u0011\u0001C\u0007R\u0007\u001d!q$C\u0001\u0005\u00015\t\u0001\u0012D\u0007\u0002\u0011Ii3\u0004b\u0002\u0019BuUA\u0001\u0001E\u0015\u001b\u0019)\u0011\u0001c\u0007\n\u0007%\u0011Q!\u0001E\u0007!\u000e\u0001\u0011EB\u0003\u0002\u00117I1!\u0003\u0002\u0006\u0003!5\u0011kA\u0003\u0005B%\t\u0001BD\u0007\u0002\u00119i\u000b\u0006\u0002\u0001\u0019Cu5A\u0001\u0001\u0005\u0017\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001i*\u0003\u0002\u0001\t@5qQ!\u0001E\u0012\u0013\rI!!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!i\u0001k!\u0001\"\u0005\u0015\t\u0001\"D)\u0004\u000f\u0011\t\u0013\"\u0001\u0003\u0001\u001b\u0005AI\"D\u0001\t%5FC\u0001\u0001M\";\u001b!\u0001\u0001#\n\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001u\u0015B\u0001\u0001E \u001b9)\u0011\u0001c\t\n\u0007%\u0011Q!\u0001E\f\u0013\rI!!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u00115\u00016\u0011A\u0011\u0003\u000b\u0005AQ\"U\u0002\b\t\u0007J\u0011\u0001\u0002\u0001\u000e\u0003!eQ\"\u0001\u0005\u0013[a!\u0011!\u0006\u0002\u0006\u0003!\u0015\u0002TIO\u0007\t\u0001A1%\u0004\u0002\u0006\u0003!5\u0001k!\u0001\"\u0005\u0015\t\u0001RB)\u0004\u000f\u0011\u0015\u0013\"\u0001E\b\u001b\u0005A1#D\u0001\t\u0010U\u0002\u0001"})
public final class LibraryUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final String KOTLIN_JS_MODULE_NAME = "Kotlin-JS-Module-Name";
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    private static String TITLE_KOTLIN_JAVASCRIPT_LIB;
    private static final String METAINF = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String METAINF_RESOURCES = "META-INF/resources/";
    private static final Attributes.Name KOTLIN_JS_MODULE_ATTRIBUTE_NAME;
    public static final LibraryUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(LibraryUtils.class);
        new LibraryUtils();
    }

    @NotNull
    public final String getKOTLIN_JS_MODULE_NAME() {
        return KOTLIN_JS_MODULE_NAME;
    }

    @platformStatic
    @Nullable
    public static final VirtualFile getJarFile(@JetValueParameter(name="classesRoots") @NotNull List<? extends VirtualFile> classesRoots, @JetValueParameter(name="jarName") @NotNull String jarName) {
        Intrinsics.checkParameterIsNotNull(classesRoots, "classesRoots");
        Intrinsics.checkParameterIsNotNull(jarName, "jarName");
        for (VirtualFile virtualFile : classesRoots) {
            if (!Intrinsics.areEqual(virtualFile.getName(), jarName)) continue;
            return virtualFile;
        }
        return null;
    }

    @platformStatic
    @Nullable
    public static final String getKotlinJsModuleName(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes attributes = INSTANCE$.getManifestMainAttributesFromJarOrDirectory(library);
        return attributes != null ? attributes.getValue(KOTLIN_JS_MODULE_ATTRIBUTE_NAME) : null;
    }

    @platformStatic
    public static final boolean isOldKotlinJavascriptLibrary(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.SPECIFICATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.SPECIFICATION_TITLE");
        return INSTANCE$.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_LIB, name) ? LibraryUtils.getKotlinJsModuleName(library) != null : false;
    }

    @platformStatic
    public static final boolean isKotlinJavascriptLibraryWithMetadata(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        return KotlinPackage.isNotEmpty((Collection)KotlinJavascriptMetadataUtils.loadMetadata(library));
    }

    @platformStatic
    public static final boolean isKotlinJavascriptLibrary(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        return !LibraryUtils.isOldKotlinJavascriptLibrary(library) ? LibraryUtils.isKotlinJavascriptLibraryWithMetadata(library) : true;
    }

    @platformStatic
    public static final boolean isKotlinJavascriptStdLibrary(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.IMPLEMENTATION_TITLE");
        return INSTANCE$.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    @platformStatic
    public static final void copyJsFilesFromLibraries(@JetValueParameter(name="libraries") @NotNull List<? extends String> libraries, @JetValueParameter(name="outputLibraryJsPath") @NotNull String outputLibraryJsPath) {
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String string : libraries) {
            File file = new File(string);
            boolean bl = file.exists();
            if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
                String string2 = "Library " + string + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (file.isDirectory()) {
                INSTANCE$.copyJsFilesFromDirectory(file, outputLibraryJsPath);
                continue;
            }
            INSTANCE$.copyJsFilesFromZip(file, outputLibraryJsPath);
        }
    }

    @platformStatic
    @NotNull
    public static final List<String> readJsFiles(@JetValueParameter(name="libraries") @NotNull List<? extends String> libraries) {
        File it;
        Object t;
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        ArrayList<String> files = KotlinPackage.arrayListOf(new String[0]);
        Iterable iterable = libraries;
        Object object = iterable;
        Collection collection = new ArrayList();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            t = iterator2.next();
            String string = (String)t;
            Collection collection2 = collection;
            File file = new File((String)((Object)it));
            collection2.add(file);
        }
        iterable = (ArrayList)collection;
        object = iterable;
        collection = new ArrayList();
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            t = iterator2.next();
            it = (File)t;
            if (!it.exists()) continue;
            collection.add(t);
        }
        List libs = (ArrayList)collection;
        for (File lib : libs) {
            if (lib.isDirectory()) {
                INSTANCE$.traverseDirectory(lib, (Function2<? super File, ? super String, ? extends Unit>)new Function2<File, String, Unit>(files){
                    final /* synthetic */ ArrayList $files;

                    public final void invoke(@JetValueParameter(name="file") @NotNull File file, @JetValueParameter(name="path") @NotNull String path) {
                        Intrinsics.checkParameterIsNotNull(file, "file");
                        Intrinsics.checkParameterIsNotNull(path, "path");
                        this.$files.add(FileUtil.loadFile(file));
                    }
                    {
                        this.$files = arrayList;
                    }
                });
                continue;
            }
            if (FileUtil.isJarOrZip(lib)) {
                INSTANCE$.traverseArchive(lib, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(files){
                    final /* synthetic */ ArrayList $files;

                    public final void invoke(@JetValueParameter(name="content") @NotNull String content, @JetValueParameter(name="path") @NotNull String path) {
                        Intrinsics.checkParameterIsNotNull(content, "content");
                        Intrinsics.checkParameterIsNotNull(path, "path");
                        this.$files.add(content);
                    }
                    {
                        this.$files = arrayList;
                    }
                });
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Unknown library format (directory or zip expected): " + lib);
        }
        return files;
    }

    private final void copyJsFilesFromDirectory(@JetValueParameter(name="dir") File dir, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) {
        this.traverseDirectory(dir, (Function2<? super File, ? super String, ? extends Unit>)new Function2<File, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@JetValueParameter(name="file") @NotNull File file, @JetValueParameter(name="relativePath") @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                FileUtil.copy(file, new File(this.$outputLibraryJsPath, relativePath));
            }
            {
                this.$outputLibraryJsPath = string;
            }
        });
    }

    private final void processDirectory(@JetValueParameter(name="dir") File dir, @JetValueParameter(name="action") Function2<? super File, ? super String, ? extends Unit> action) {
        FileUtil.processFilesRecursively(dir, new Processor<File>(dir, action){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ File $dir;
            final /* synthetic */ Function2 $action;

            static {
                $kotlinClass = Reflection.createKotlinClass(processDirectory.1.class);
            }

            public boolean process(@JetValueParameter(name="file") @NotNull File file) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                String string = FileUtil.getRelativePath(this.$dir, file);
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + " " + file);
                }
                String relativePath = string;
                if (file.isFile() ? KotlinPackage.endsWith(relativePath, KotlinJavascriptMetadataUtils.INSTANCE$.getJS_EXT()) : false) {
                    String suggestedRelativePath = LibraryUtils.access$getSuggestedPath$0(LibraryUtils.INSTANCE$, relativePath);
                    if (suggestedRelativePath == null) {
                        return true;
                    }
                    this.$action.invoke(file, suggestedRelativePath);
                }
                return true;
            }
            {
                this.$dir = $captured_local_variable$0;
                this.$action = $captured_local_variable$1;
            }
        });
    }

    public final void traverseDirectory(@JetValueParameter(name="dir") @NotNull File dir, @JetValueParameter(name="action") @NotNull Function2<? super File, ? super String, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull(dir, "dir");
        Intrinsics.checkParameterIsNotNull(action, "action");
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(@JetValueParameter(name="file") File file, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) {
        this.traverseArchive(file, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@JetValueParameter(name="content") @NotNull String content, @JetValueParameter(name="relativePath") @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                FileUtil.writeToFile(new File(this.$outputLibraryJsPath, relativePath), content);
            }
            {
                this.$outputLibraryJsPath = string;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverseArchive(@JetValueParameter(name="file") @NotNull File file, @JetValueParameter(name="action") @NotNull Function2<? super String, ? super String, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(action, "action");
        ZipFile zipFile = new ZipFile(file.getPath());
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String content;
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (!(!entry.isDirectory() ? KotlinPackage.endsWith(entryName, KotlinJavascriptMetadataUtils.INSTANCE$.getJS_EXT()) : false)) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                String relativePath = this.getSuggestedPath(string);
                if (relativePath == null) continue;
                InputStream stream2 = zipFile.getInputStream(entry);
                String string2 = content = FileUtil.loadTextAndClose(stream2);
                Intrinsics.checkExpressionValueIsNotNull(string2, "content");
                action.invoke(string2, relativePath);
            }
        }
        catch (IOException ex) {
            LOG.error("Could not extract files from archive " + file.getName() + ": " + ex.getMessage());
        }
        finally {
            zipFile.close();
        }
    }

    private final String getSuggestedPath(@JetValueParameter(name="path") String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName(path);
        if (KotlinPackage.startsWith(systemIndependentPath, METAINF)) {
            if (KotlinPackage.startsWith(systemIndependentPath, METAINF_RESOURCES)) {
                return KotlinPackage.substring(path, METAINF_RESOURCES.length());
            }
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(@JetValueParameter(name="library") File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(library);
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(@JetValueParameter(name="library") File library) {
        boolean bl = !(!library.canRead()) ? !library.isDirectory() : true;
        if (bl) {
            return null;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (!manifestFile.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                Manifest manifest = new Manifest(inputStream);
                return manifest;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(@JetValueParameter(name="library") File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(@JetValueParameter(name="library") File library) {
        Manifest manifest = this.getManifestFromJarOrDirectory(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(@JetValueParameter(name="library") File library, @JetValueParameter(name="expected") String expected, @JetValueParameter(name="attributeName") Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value != null ? Intrinsics.areEqual(value, expected) : false;
    }

    private final String getPropertyOrFail(@JetValueParameter(name="$receiver") Properties $receiver, @JetValueParameter(name="propName") String propName) {
        String value = $receiver.getProperty(propName);
        if (value == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $receiver.list(new PrintStream(bytes));
            LOG.error(propName + " not found." + "\n" + " " + bytes);
        }
        String string = value;
        Intrinsics.checkExpressionValueIsNotNull(string, "value");
        return string;
    }

    LibraryUtils() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        KOTLIN_JS_MODULE_NAME = KOTLIN_JS_MODULE_NAME;
        METAINF = METAINF;
        MANIFEST_PATH = METAINF + "MANIFEST.MF";
        METAINF_RESOURCES = METAINF + "resources/";
        KOTLIN_JS_MODULE_ATTRIBUTE_NAME = new Attributes.Name(KOTLIN_JS_MODULE_NAME);
        String jsStdLib = "";
        String jsLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                jsStdLib = this.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
                jsLib = this.getPropertyOrFail(properties2, "manifest.spec.title.kotlin.javascript.lib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
        TITLE_KOTLIN_JAVASCRIPT_LIB = jsLib;
    }

    @Nullable
    public static final /* synthetic */ String access$getSuggestedPath$0(@JetValueParameter(name="$this", type="?") LibraryUtils $this, @JetValueParameter(name="path") @NotNull String path) {
        return $this.getSuggestedPath(path);
    }
}

