/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeBackedLighterAST
extends LighterAST {
    private final FileASTNode myRoot;

    public TreeBackedLighterAST(@NotNull FileASTNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/TreeBackedLighterAST", "<init>"));
        }
        super(root.getCharTable());
        this.myRoot = root;
    }

    @Override
    @NotNull
    public LighterASTNode getRoot() {
        LighterASTNode lighterASTNode = TreeBackedLighterAST.wrap(this.myRoot);
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TreeBackedLighterAST", "getRoot"));
        }
        return lighterASTNode;
    }

    @Override
    public LighterASTNode getParent(@NotNull LighterASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TreeBackedLighterAST", "getParent"));
        }
        return TreeBackedLighterAST.wrap(((NodeWrapper)node).myNode.getTreeParent());
    }

    @Override
    @NotNull
    public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/TreeBackedLighterAST", "getChildren"));
        }
        ASTNode[] children = ((NodeWrapper)parent).myNode.getChildren(null);
        if (children == null || children.length == 0) {
            List<LighterASTNode> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TreeBackedLighterAST", "getChildren"));
            }
            return list;
        }
        ArrayList<LighterASTNode> result2 = new ArrayList<LighterASTNode>(children.length);
        for (ASTNode child : children) {
            result2.add(TreeBackedLighterAST.wrap(child));
        }
        ArrayList<LighterASTNode> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TreeBackedLighterAST", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    private static LighterASTNode wrap(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TreeBackedLighterAST", "wrap"));
        }
        NodeWrapper nodeWrapper = node.getFirstChildNode() == null && node.getTextLength() > 0 ? new TokenNodeWrapper(node) : new NodeWrapper(node);
        if (nodeWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TreeBackedLighterAST", "wrap"));
        }
        return nodeWrapper;
    }

    @NotNull
    public ASTNode unwrap(@NotNull LighterASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TreeBackedLighterAST", "unwrap"));
        }
        ASTNode aSTNode = ((NodeWrapper)node).myNode;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TreeBackedLighterAST", "unwrap"));
        }
        return aSTNode;
    }

    private static class TokenNodeWrapper
    extends NodeWrapper
    implements LighterASTTokenNode {
        public TokenNodeWrapper(ASTNode node) {
            super(node);
        }

        @Override
        public CharSequence getText() {
            return this.myNode.getText();
        }

        @Override
        public String toString() {
            return "token wrapper[" + this.myNode + "]";
        }
    }

    private static class NodeWrapper
    implements LighterASTNode {
        protected final ASTNode myNode;

        public NodeWrapper(ASTNode node) {
            this.myNode = node;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = this.myNode.getElementType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TreeBackedLighterAST$NodeWrapper", "getTokenType"));
            }
            return iElementType;
        }

        @Override
        public int getStartOffset() {
            return this.myNode.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myNode.getStartOffset() + this.myNode.getTextLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeWrapper)) {
                return false;
            }
            NodeWrapper that = (NodeWrapper)o;
            return !(this.myNode != null ? !this.myNode.equals(that.myNode) : that.myNode != null);
        }

        public int hashCode() {
            return this.myNode.hashCode();
        }

        public String toString() {
            return "node wrapper[" + this.myNode + "]";
        }
    }
}

