/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create("HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final ConcurrentMap<VirtualFile, PsiDirectory> myVFileToPsiDirMap = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = ContainerUtil.createConcurrentWeakValueMap();
    private boolean myInitialized = false;
    private boolean myDisposed = false;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange = false;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.updateAllViewProviders();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.updateAllViewProviders();
            }
        });
        Disposer.register(manager.getProject(), this);
        LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                FileManagerImpl.this.processQueue();
            }
        }, this);
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.remove(NULL);
    }

    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap<VirtualFile, FileViewProvider> concurrentMap = this.myVFileToViewProviderMap;
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getVFileToViewProviderMap"));
        }
        return concurrentMap;
    }

    private void updateAllViewProviders() {
        this.handleFileTypesChange(new FileTypesChanged(){

            @Override
            protected void updateMaps() {
                for (FileViewProvider provider : FileManagerImpl.this.myVFileToViewProviderMap.values()) {
                    if (!provider.getVirtualFile().isValid()) continue;
                    for (Language language : provider.getLanguages()) {
                        PsiFile psi = provider.getPsi(language);
                        if (!(psi instanceof PsiFileImpl)) continue;
                        ((PsiFileImpl)psi).clearCaches();
                    }
                }
                FileManagerImpl.this.removeInvalidFilesAndDirs(false);
                FileManagerImpl.this.checkLanguageChange();
            }
        });
    }

    private void checkLanguageChange() {
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            Language language = this.getLanguage(vFile);
            if (language == null || language == ((FileViewProvider)fileToPsiFileMap.get(vFile)).getBaseLanguage()) continue;
            iterator2.remove();
        }
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        PsiDirectory parentDir;
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "forceReload"));
        }
        if (this.findCachedViewProvider(vFile) == null) {
            return;
        }
        this.setViewProvider(vFile, null);
        VirtualFile dir = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = dir == null ? null : this.getCachedDirectory(dir);
        if (parentDir != null) {
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent(parentDir);
            this.myManager.childrenChanged(treeEvent);
        }
    }

    @Override
    public void dispose() {
        if (this.myInitialized) {
            this.myConnection.disconnect();
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myDisposed = true;
    }

    @Override
    public void cleanupForNextTest() {
        this.myVFileToViewProviderMap.clear();
        this.myVFileToPsiDirMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
        }
        assert (!file.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
            }
            return fileViewProvider;
        }
        viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        if (viewProvider == null) {
            viewProvider = ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, file, this.createFileViewProvider(file, true));
        }
        FileViewProvider fileViewProvider = viewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findCachedViewProvider"));
        }
        FileViewProvider viewProvider = this.getFromInjected(file);
        if (viewProvider == null) {
            viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        }
        if (viewProvider == null) {
            viewProvider = file.getUserData(this.myPsiHardRefKey);
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getFromInjected(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getFromInjected"));
        }
        if (file instanceof VirtualFileWindow) {
            DocumentWindow document = ((VirtualFileWindow)((Object)file)).getDocumentWindow();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myManager.getProject()).getCachedPsiFile(document);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getViewProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, @Nullable FileViewProvider fileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "setViewProvider"));
        }
        FileViewProvider prev = this.findCachedViewProvider(virtualFile);
        if (prev != null) {
            DebugUtil.startPsiModification(null);
            try {
                DebugUtil.onInvalidated(prev);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (fileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
                Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
                if (document != null) {
                    PsiDocumentManagerBase.cachePsi(document, null);
                }
                virtualFile.putUserData(this.myPsiHardRefKey, null);
            } else if (virtualFile instanceof LightVirtualFile) {
                virtualFile.putUserData(this.myPsiHardRefKey, fileViewProvider);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile, fileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        Language language = this.getLanguage(file);
        FileViewProvider fileViewProvider = this.createFileViewProvider(file, eventSystemEnabled, language);
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        return fileViewProvider;
    }

    @NotNull
    private FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean eventSystemEnabled, Language language) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(file.getFileType()) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory == null ? null : factory.createFileViewProvider(file, language, this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider(this.myManager, file, eventSystemEnabled) : viewProvider;
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }

    @Nullable
    private Language getLanguage(@NotNull VirtualFile file) {
        ContentBasedFileSubstitutor[] processors;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getLanguage"));
        }
        FileType fileType = file.getFileType();
        Project project = this.myManager.getProject();
        if (fileType instanceof LanguageFileType) {
            return LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, project);
        }
        for (ContentBasedFileSubstitutor processor : processors = Extensions.getExtensions(ContentBasedFileSubstitutor.EP_NAME)) {
            Language language = processor.obtainLanguageForFile(file);
            if (language == null) continue;
            return language;
        }
        return null;
    }

    public void markInitialized() {
        LOG.assertTrue(!this.myInitialized);
        this.myDisposed = false;
        this.myInitialized = true;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileTypesChange(@NotNull FileTypesChanged runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/file/impl/FileManagerImpl", "handleFileTypesChange"));
        }
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
        finally {
            this.myProcessingFileTypesChange = false;
        }
    }

    void dispatchPendingEvents() {
        if (!this.myInitialized) {
            LOG.error("Project is not yet initialized: " + this.myManager.getProject());
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        for (VirtualFile vFile : fileToViewProvider.keySet()) {
            FileViewProvider fileViewProvider = fileToViewProvider.get(vFile);
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        this.myVFileToPsiDirMap.clear();
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.myVFileToPsiDirMap.containsKey(parent));
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findFile"));
        }
        if (vFile.isDirectory()) {
            return null;
        }
        Project project = this.myManager.getProject();
        if (project.isDefault()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedPsiFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), "Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        if (!this.myInitialized) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findDirectory"));
        }
        LOG.assertTrue(this.myInitialized, "Access to psi files should be performed only after startup activity");
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findDirectoryImpl"));
        }
        PsiDirectory psiDir = (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
        if (psiDir != null) {
            return psiDir;
        }
        if (Registry.is("ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, vFile, psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedDirectory"));
        }
        return (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedPsiFileInner"));
        }
        FileViewProvider fileViewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        if (fileViewProvider == null) {
            fileViewProvider = file.getUserData(this.myPsiHardRefKey);
        }
        return fileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            if (!(provider instanceof SingleRootFileViewProvider)) continue;
            ContainerUtil.addIfNotNull(files, ((SingleRootFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        ArrayList<PsiFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getAllCachedFiles"));
        }
        return arrayList;
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        THashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new THashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        if (useFind) {
            this.myVFileToPsiDirMap.clear();
        }
        Iterator iterator2 = fileToPsiDirMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator2.remove();
        }
        this.myVFileToPsiDirMap.clear();
        this.myVFileToPsiDirMap.putAll(fileToPsiDirMap);
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        if (useFind) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator iterator3 = fileToPsiFileMap.keySet().iterator();
        while (iterator3.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator3.next();
            if (!vFile.isValid()) {
                iterator3.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator3.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator3.remove();
                continue;
            }
            PsiFile psi = view.getPsi(view.getBaseLanguage());
            if (psi == null || !psiFile1.getClass().equals(psi.getClass()) || psiFile1.getViewProvider().getBaseLanguage() != view.getBaseLanguage()) {
                iterator3.remove();
                continue;
            }
            if (!(psi instanceof PsiFileImpl)) continue;
            ((PsiFileImpl)psi).clearCaches();
        }
        this.myVFileToViewProviderMap.clear();
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "reloadFromDisk"));
        }
        this.reloadFromDisk(file, false);
    }

    void reloadFromDisk(@NotNull PsiFile file, boolean ignoreDocument) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "reloadFromDisk"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        if (file instanceof PsiBinaryFile) {
            return;
        }
        FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
        Document document = fileDocumentManager.getCachedDocument(vFile);
        if (document != null && !ignoreDocument) {
            fileDocumentManager.reloadFromDisk(document);
        } else {
            FileViewProvider latestProvider = this.createFileViewProvider(vFile, false);
            if (latestProvider.getPsi(latestProvider.getBaseLanguage()) instanceof PsiBinaryFile) {
                this.forceReload(vFile);
                return;
            }
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
            event.setParent(file);
            event.setFile(file);
            if (file instanceof PsiFileImpl && ((PsiFileImpl)file).isContentsLoaded()) {
                event.setOffset(0);
                event.setOldLength(file.getTextLength());
            }
            this.myManager.beforeChildrenChange(event);
            if (file instanceof PsiFileEx) {
                ((PsiFileEx)file).onContentReload();
            }
            this.myManager.childrenChanged(event);
        }
    }

    private abstract class FileTypesChanged
    implements Runnable {
        private FileTypesChanged() {
        }

        protected abstract void updateMaps();

        @Override
        public void run() {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.beforePropertyChange(event);
            this.updateMaps();
            FileManagerImpl.this.myManager.propertyChanged(event);
        }
    }
}

