/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LeafPsiElement
extends LeafElement
implements NavigationItem,
PsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LeafPsiElement");

    public LeafPsiElement(@NotNull IElementType type2, CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LeafPsiElement", "<init>"));
        }
        super(type2, text);
    }

    @Deprecated
    public LeafPsiElement(@NotNull IElementType type2, CharSequence buffer, int startOffset, int endOffset, CharTable table) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LeafPsiElement", "<init>"));
        }
        super(type2, table.intern(buffer, startOffset, endOffset));
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getFirstChild() {
        return null;
    }

    @Override
    public PsiElement getLastChild() {
        return null;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/LeafPsiElement", "acceptChildren"));
        }
    }

    @Override
    public PsiElement getParent() {
        return SharedImplUtil.getParent(this);
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null || !file.isValid()) {
            this.invalid();
        }
        return file;
    }

    private void invalid() {
        ProgressIndicatorProvider.checkCanceled();
        StringBuilder builder = new StringBuilder();
        for (TreeElement element = this; element != null; element = element.getTreeParent()) {
            if (element != this) {
                builder.append(" / ");
            }
            builder.append(element.getClass().getName()).append(':').append(element.getElementType());
        }
        throw new PsiInvalidElementAccessException((PsiElement)this, builder.toString());
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    @Override
    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    @Override
    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "add"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/LeafPsiElement", "checkAdd"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/tree/LeafPsiElement", "addRangeBefore"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/tree/LeafPsiElement", "replace"));
        }
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/LeafPsiElement", "accept"));
        }
        visitor2.visitElement(this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/LeafPsiElement", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/LeafPsiElement", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/LeafPsiElement", "processDeclarations"));
        }
        return true;
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            this.invalid();
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafPsiElement", "getLanguage"));
        }
        return language;
    }

    @Override
    public ASTNode getNode() {
        return this;
    }

    @Override
    public PsiElement getPsi() {
        return this;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = PsiNavigationSupport.getInstance().getDescriptor(this);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

