/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent = "";
    private Language myLanguage;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls String name) {
        this(name, "");
    }

    public LightVirtualFile(@NonNls String name, CharSequence content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text) {
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, long modificationStamp) {
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, Charset charset, long modificationStamp) {
        super(name, fileType, modificationStamp);
        this.setContent(text);
        this.setCharset(charset);
    }

    public LightVirtualFile(String name, Language language, CharSequence text) {
        super(name, null, LocalTimeCounter.currentTime());
        this.setContent(text);
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(Language language) {
        this.myLanguage = language;
        FileType type2 = language.getAssociatedFileType();
        if (type2 == null) {
            type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName());
        }
        this.setFileType(type2);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    String content = this.toString(LightVirtualFile.this.getCharset().name());
                    LightVirtualFile.this.setContent(content);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getOutputStream"));
        }
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = ((Object)this.getContent()).toString();
        byte[] byArray = s.getBytes(charset.name());
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    private void setContent(CharSequence content) {
        this.myContent = content;
    }

    public CharSequence getContent() {
        return this.myContent;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }
}

