/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilPackage;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;

public class EnumValue
extends CompileTimeConstant<ClassDescriptor> {
    public EnumValue(@NotNull ClassDescriptor value, boolean usesVariableAsConstant) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "kotlin/reflect/jvm/internal/impl/resolve/constants/EnumValue", "<init>"));
        }
        super(value, true, false, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "kotlin/reflect/jvm/internal/impl/resolve/constants/EnumValue", "getType"));
        }
        JetType jetType = this.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @NotNull
    private JetType getType() {
        JetType type2 = DescriptorUtilPackage.getClassObjectType((ClassDescriptor)this.value);
        assert (type2 != null) : "Enum entry must have a class object type: " + this.value;
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public ClassDescriptor getValue() {
        ClassDescriptor value = (ClassDescriptor)super.getValue();
        assert (value != null) : "Guaranteed by constructor";
        ClassDescriptor classDescriptor = value;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/EnumValue", "getValue"));
        }
        return classDescriptor;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitEnumValue(this, data2);
    }

    public String toString() {
        return this.getType() + "." + ((ClassDescriptor)this.value).getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((ClassDescriptor)this.value).equals(((EnumValue)o).value);
    }

    public int hashCode() {
        return ((ClassDescriptor)this.value).hashCode();
    }
}

