/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPackage;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.types.Approximation;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet(AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class));
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put(Visibilities.PRIVATE, 2).put(Visibilities.PRIVATE_TO_THIS, 2).put(Visibilities.PROTECTED, 4).put(JavaVisibilities.PROTECTED_STATIC_VISIBILITY, 4).put(JavaVisibilities.PROTECTED_AND_PACKAGE, 4).put(Visibilities.PUBLIC, 1).put(Visibilities.INTERNAL, 1).put(Visibilities.LOCAL, 0).put(JavaVisibilities.PACKAGE_VISIBILITY, 0).build();
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "boxType"));
        }
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        Type type3 = jvmPrimitiveType != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "boxType"));
        }
        return type3;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        if (boxedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxedType", "org/jetbrains/kotlin/codegen/AsmUtil", "unboxType"));
        }
        Type primitiveType = primitiveTypeByBoxedType.get(boxedType);
        if (primitiveType == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type2 = primitiveType;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "unboxType"));
        }
        return type2;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isNumberPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.FLOAT_TYPE || type2 == Type.DOUBLE_TYPE || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    public static Type correctElementType(Type type2) {
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        return Type.getType(internalName.substring(1));
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name, @NotNull Type returnType2, Type ... parameterTypes) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AsmUtil", "method"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/AsmUtil", "method"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/kotlin/codegen/AsmUtil", "method"));
        }
        Method method = new Method(name, Type.getMethodDescriptor(returnType2, parameterTypes));
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "method"));
        }
        return method;
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isInterface(functionDescriptor.getContainingDeclaration())) && !AsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return AsmUtil.isStaticKind(kind) || JetTypeMapper.isAccessor(functionDescriptor) || AnnotationsPackage.isPlatformStaticInObjectOrClass(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.TRAIT_IMPL;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        DeclarationDescriptor containingDeclaration;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(functionDescriptor.getOriginal())) continue;
            flags |= flagAnnotation.getJvmFlag();
        }
        if (AnnotationsPackage.isPlatformStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor.getModality() != Modality.FINAL || functionDescriptor instanceof ConstructorDescriptor || (containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, kind)) {
            flags |= 0x400;
        }
        if (JetTypeMapper.isAccessor(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor) {
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor);
        return flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "getVisibilityAccessFlag"));
        }
        Integer specialCase = AsmUtil.specialCaseVisibility(descriptor2);
        if (specialCase != null) {
            return specialCase;
        }
        Integer defaultMapping = visibilityToAccessFlag.get(descriptor2.getVisibility());
        if (defaultMapping == null) {
            throw new IllegalStateException(descriptor2.getVisibility() + " is not a valid visibility in backend: " + descriptor2);
        }
        return defaultMapping;
    }

    public static int getVisibilityAccessFlagForClass(ClassDescriptor descriptor2) {
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2) || descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    public static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "getVisibilityAccessFlagForAnonymous"));
        }
        return InlineUtil.isInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/kotlin/codegen/AsmUtil", "calculateInnerClassAccessFlags"));
        }
        int visibility = innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass);
        return visibility | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/kotlin/codegen/AsmUtil", "innerAccessFlagsForModalityAndKind"));
        }
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        if (innerClass.getModality() == Modality.FINAL) {
            return 16;
        }
        if (innerClass.getModality() == Modality.ABSTRACT) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "getDeprecatedAccessFlag"));
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "specialCaseVisibility"));
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        if (JvmCodegenUtil.isInterface(containingDeclaration)) {
            return 1;
        }
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return 0;
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof ConstructorDescriptor) {
            if (DescriptorUtils.isNonCompanionObject(containingDeclaration) || DescriptorUtils.isEnumEntry(containingDeclaration)) {
                return 0;
            }
            if (DescriptorUtils.isEnumClass(containingDeclaration)) {
                return 4;
            }
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return 1;
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "genThrow"));
        }
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "org/jetbrains/kotlin/codegen/AsmUtil", "genThrow"));
        }
        v.anew(Type.getObjectType(exception));
        v.dup();
        if (message != null) {
            v.aconst(message);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genClosureFields(CalculatedClosure closure, ClassBuilder v, JetTypeMapper typeMapper) {
        JetType captureReceiverType;
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            allFields.add(Pair.create(CAPTURED_THIS_FIELD, typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null) {
            allFields.add(Pair.create(CAPTURED_RECEIVER_FIELD, typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field2 : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field2.first, ((Type)field2.second).getDescriptor(), null, null);
        }
    }

    public static List<FieldInfo> transformCapturedParams(List<Pair<String, Type>> allFields, Type owner) {
        ArrayList<FieldInfo> result2 = new ArrayList<FieldInfo>();
        for (Pair<String, Type> field2 : allFields) {
            result2.add(FieldInfo.createForHiddenField(owner, (Type)field2.second, (String)field2.first));
        }
        return result2;
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        iv.load(0, info.getOwnerType());
        iv.load(index2, fieldType);
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(InstructionAdapter v, Type type2) {
        type2 = AsmUtil.stringBuilderAppendType(type2);
        v.invokevirtual("java/lang/StringBuilder", "append", "(" + type2.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(final StackValue receiver, final Type receiverType) {
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Type type2 = AsmUtil.stringValueOfType(receiverType);
                receiver.put(type2, v);
                v.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
                return null;
            }
        });
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 7) {
            AsmUtil.genLongHashCode(mv, iv);
        } else if (type2.getSort() == 8) {
            iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
            AsmUtil.genLongHashCode(mv, iv);
        } else if (type2.getSort() == 6) {
            iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(final @NotNull IElementType opToken, final @NotNull StackValue left, final @NotNull StackValue right) {
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/AsmUtil", "genEqualsForExpressionsOnStack"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/codegen/AsmUtil", "genEqualsForExpressionsOnStack"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/codegen/AsmUtil", "genEqualsForExpressionsOnStack"));
        }
        final Type leftType = left.type;
        final Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            StackValue stackValue = StackValue.cmp(opToken, leftType, left, right);
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "genEqualsForExpressionsOnStack"));
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                left.put(leftType, v);
                right.put(rightType, v);
                AsmUtil.genAreEqualCall(v);
                if (opToken == JetTokens.EXCLEQ || opToken == JetTokens.EXCLEQEQEQ) {
                    AsmUtil.genInvertBoolean(v);
                }
                return Unit.INSTANCE$;
            }
        });
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "genEqualsForExpressionsOnStack"));
        }
        return stackValue;
    }

    public static void genAreEqualCall(InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    public static void genIncrement(Type expectedType, int myDelta, InstructionAdapter v) {
        if (expectedType == Type.LONG_TYPE) {
            v.lconst(myDelta);
        } else if (expectedType == Type.FLOAT_TYPE) {
            v.fconst(myDelta);
        } else if (expectedType == Type.DOUBLE_TYPE) {
            v.dconst(myDelta);
        } else {
            v.iconst(myDelta);
            v.add(Type.INT_TYPE);
            StackValue.coerce(Type.INT_TYPE, expectedType, v);
            return;
        }
        v.add(expectedType);
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    public static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (frameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (!state.isParamAssertionsEnabled()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, receiverParameter, "$receiver");
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, parameter, parameter.getName().asString());
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v, @NotNull JetTypeMapper typeMapper, @NotNull FrameMap frameMap, @NotNull CallableDescriptor parameter, @NotNull String name) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "genParamAssertion"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/AsmUtil", "genParamAssertion"));
        }
        if (frameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/AsmUtil", "genParamAssertion"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/AsmUtil", "genParamAssertion"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AsmUtil", "genParamAssertion"));
        }
        JetType type2 = parameter.getReturnType();
        if (type2 == null || TypeUtils.isNullableType(type2)) {
            return;
        }
        int index2 = frameMap.getIndex(parameter);
        Type asmType = typeMapper.mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            v.load(index2, asmType);
            v.visitLdcInsn(name);
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkParameterIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    public static void genNotNullAssertionForField(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull PropertyDescriptor descriptor2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionForField"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionForField"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertionForField"));
        }
        AsmUtil.genNotNullAssertion(v, state, descriptor2, "checkFieldIsNotNull");
    }

    private static void genNotNullAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull CallableDescriptor descriptor2, @NotNull String assertMethodToCall) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (assertMethodToCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assertMethodToCall", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (JvmPackage.getPLATFORM_TYPES()) {
            return;
        }
        if (!state.isCallAssertionsEnabled()) {
            return;
        }
        if (!AsmUtil.isDeclaredInJava(descriptor2)) {
            return;
        }
        JetType type2 = descriptor2.getReturnType();
        if (type2 == null || TypeUtils.isNullableType(TypesPackage.lowerIfFlexible(type2))) {
            return;
        }
        Type asmType = state.getTypeMapper().mapReturnType(descriptor2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            v.dup();
            v.visitLdcInsn(descriptor2.getContainingDeclaration().getName().asString());
            v.visitLdcInsn(descriptor2.getName().asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", assertMethodToCall, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(@NotNull GenerationState state, final @NotNull StackValue stackValue, final @Nullable Approximation.Info approximationInfo2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertions"));
        }
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertions"));
        }
        if (!state.isCallAssertionsEnabled()) {
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertions"));
            }
            return stackValue2;
        }
        if (approximationInfo2 == null || !TypesPackage.assertNotNull(approximationInfo2)) {
            StackValue stackValue3 = stackValue;
            if (stackValue3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertions"));
            }
            return stackValue3;
        }
        StackValue stackValue4 = new StackValue(stackValue.type){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil$3", "putSelector"));
                }
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil$3", "putSelector"));
                }
                stackValue.put(type2, v);
                if (type2.getSort() == 10 || type2.getSort() == 9) {
                    v.dup();
                    v.visitLdcInsn(approximationInfo2.getMessage());
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkExpressionValueIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
            }
        };
        if (stackValue4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "genNotNullAssertions"));
        }
        return stackValue4;
    }

    private static boolean isDeclaredInJava(@NotNull CallableDescriptor callableDescriptor) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "isDeclaredInJava"));
        }
        CallableDescriptor descriptor2 = callableDescriptor;
        while (true) {
            if (descriptor2 instanceof JavaCallableMemberDescriptor) {
                return true;
            }
            CallableDescriptor original = descriptor2.getOriginal();
            if (descriptor2 == original) break;
            descriptor2 = original;
        }
        return false;
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "pushDefaultValueOnStack"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "pushDefaultValueOnStack"));
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "pushDefaultPrimitiveValueOnStack"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "pushDefaultPrimitiveValueOnStack"));
        }
        if (type2.getSort() == 6) {
            v.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v.lconst(0L);
        } else {
            v.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "isInstancePropertyWithStaticBackingField"));
        }
        if (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return false;
        }
        return DescriptorUtils.isNonCompanionObject(propertyDescriptor.getContainingDeclaration()) || AsmUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
    }

    public static boolean isPropertyWithBackingFieldInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "isPropertyWithBackingFieldInOuterClass"));
        }
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && AsmUtil.isCompanionObjectWithBackingFieldsInOuter(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForSpecialPropertyBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "getVisibilityForSpecialPropertyBackingField"));
        }
        boolean bl = isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return AsmUtil.areBothAccessorDefault(propertyDescriptor) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "descriptorForVisibility"));
        }
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "isPropertyWithBackingFieldCopyInOuterClass"));
        }
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return !propertyDescriptor.isVar() && !isExtensionProperty && DescriptorUtils.isCompanionObject(propertyContainer) && DescriptorUtils.isTrait(propertyContainer.getContainingDeclaration()) && AsmUtil.areBothAccessorDefault(propertyDescriptor) && AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, false) == 1;
    }

    public static boolean isCompanionObjectWithBackingFieldsInOuter(@NotNull DeclarationDescriptor companionObject) {
        if (companionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "companionObject", "org/jetbrains/kotlin/codegen/AsmUtil", "isCompanionObjectWithBackingFieldsInOuter"));
        }
        DeclarationDescriptor containingClass = companionObject.getContainingDeclaration();
        return DescriptorUtils.isCompanionObject(companionObject) && (DescriptorUtils.isClass(containingClass) || DescriptorUtils.isEnumClass(containingClass));
    }

    private static boolean areBothAccessorDefault(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "areBothAccessorDefault"));
        }
        return AsmUtil.isAccessorWithEmptyBody(propertyDescriptor.getGetter()) && (!propertyDescriptor.isVar() || AsmUtil.isAccessorWithEmptyBody(propertyDescriptor.getSetter()));
    }

    private static boolean isAccessorWithEmptyBody(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || !accessorDescriptor.hasBody();
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/codegen/AsmUtil", "numberFunctionOperandType"));
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            Type type2 = Type.INT_TYPE;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "numberFunctionOperandType"));
            }
            return type2;
        }
        Type type3 = expectedType;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "numberFunctionOperandType"));
        }
        return type3;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "pop"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "pop"));
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "dup"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "dup"));
        }
        int size = type2.getSize();
        if (size == 2) {
            v.dup2();
        } else if (size == 1) {
            v.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void writeKotlinSyntheticClassAnnotation(@NotNull ClassBuilder v, @NotNull JvmAnnotationNames.KotlinSyntheticClass.Kind kind) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "writeKotlinSyntheticClassAnnotation"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/AsmUtil", "writeKotlinSyntheticClassAnnotation"));
        }
        AnnotationVisitor av = v.newAnnotation(Type.getObjectType(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME.getInternalName()).getDescriptor(), true);
        av.visit("abiVersion", 23);
        av.visitEnum("kind", Type.getObjectType(JvmAnnotationNames.KotlinSyntheticClass.KIND_INTERNAL_NAME).getDescriptor(), kind.toString());
        av.visitEnd();
    }

    @NotNull
    public static String asmDescByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/AsmUtil", "asmDescByFqNameWithoutInnerClasses"));
        }
        String string = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2).getDescriptor();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "asmDescByFqNameWithoutInnerClasses"));
        }
        return string;
    }

    @NotNull
    public static String shortNameByAsmType(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "shortNameByAsmType"));
        }
        String internalName = type2.getInternalName();
        int lastSlash = internalName.lastIndexOf(47);
        String string = lastSlash < 0 ? internalName : internalName.substring(lastSlash + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "shortNameByAsmType"));
        }
        return string;
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/AsmUtil", "asmTypeByFqNameWithoutInnerClasses"));
        }
        Type type2 = Type.getObjectType(AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "asmTypeByFqNameWithoutInnerClasses"));
        }
        return type2;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/AsmUtil", "internalNameByFqNameWithoutInnerClasses"));
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AsmUtil", "internalNameByFqNameWithoutInnerClasses"));
        }
        return string;
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "putJavaLangClassInstance"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AsmUtil", "putJavaLangClassInstance"));
        }
        if (AsmUtil.isPrimitive(type2)) {
            v.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst(type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "wrapJavaClassIntoKClass"));
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "foreignKotlinClass", Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AsmUtil", "wrapJavaClassesIntoKClasses"));
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "foreignKotlinClasses", Type.getMethodDescriptor(AsmTypes.K_CLASS_ARRAY_TYPE, AsmTypes.getType(Class[].class)), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context2, @NotNull CallableMemberDescriptor descriptor2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/AsmUtil", "getReceiverIndex"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AsmUtil", "getReceiverIndex"));
        }
        OwnerKind kind = context2.getContextKind();
        return kind != OwnerKind.TRAIT_IMPL && AsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder<Integer, JvmPrimitiveType> typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Type, Type> typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType(primitiveType.getDesc());
            typeBySortBuilder.put(asmType.getSort(), primitiveType);
            typeByWrapperBuilder.put(AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }
}

