/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Sets;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.ScriptNameUtil;
import org.jetbrains.org.objectweb.asm.Type;

public class KotlinCodegenFacade {
    public static void prepareForCompilation(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "prepareForCompilation"));
        }
        for (JetFile file : state.getFiles()) {
            if (!file.isScript()) continue;
            JetScript script = file.getScript();
            assert (script != null);
            FqName name = ScriptNameUtil.classNameForScript(script);
            Type type2 = AsmUtil.asmTypeByFqNameWithoutInnerClasses(name);
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, type2);
        }
        state.beforeCompile();
    }

    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        KotlinCodegenFacade.prepareForCompilation(state);
        MultiMap<FqName, JetFile> packageFqNameToFiles = new MultiMap<FqName, JetFile>();
        for (JetFile file : state.getFiles()) {
            if (file == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            packageFqNameToFiles.putValue(file.getPackageFqName(), file);
        }
        HashSet<FqName> packagesWithObsoleteParts = new HashSet<FqName>(state.getPackagesWithObsoleteParts());
        for (FqName fqName2 : Sets.union(packagesWithObsoleteParts, packageFqNameToFiles.keySet())) {
            KotlinCodegenFacade.generatePackage(state, fqName2, packageFqNameToFiles.get(fqName2), errorHandler);
        }
        state.getFactory().done();
    }

    public static void generatePackage(@NotNull GenerationState state, @NotNull FqName fqName2, @NotNull Collection<JetFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (jetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFiles", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        PackageCodegen codegen = state.getFactory().forPackage(fqName2, jetFiles);
        codegen.generate(errorHandler);
    }

    private KotlinCodegenFacade() {
    }
}

