/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererImpl;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.types.JetType;

public class DescriptorRendererBuilder {
    private NameShortness nameShortness = NameShortness.SOURCE_CODE_QUALIFIED;
    private boolean withDefinedIn = true;
    private Set<DescriptorRenderer.Modifier> modifiers = EnumSet.allOf(DescriptorRenderer.Modifier.class);
    private boolean startFromName = false;
    private boolean debugMode = false;
    private boolean classWithPrimaryConstructor = false;
    private boolean verbose = false;
    private boolean unitReturnType = true;
    private boolean normalizedVisibilities = false;
    private boolean showInternalKeyword = true;
    private boolean prettyFunctionTypes = true;
    private boolean uninferredTypeParameterAsName = false;
    private boolean includePropertyConstant = false;
    private boolean withoutTypeParameters = false;
    private boolean withoutSuperTypes = false;
    private Function1<JetType, JetType> typeNormalizer = new Function1<JetType, JetType>(){

        @Override
        public JetType invoke(JetType type2) {
            return type2;
        }
    };
    private boolean renderDefaultValues = true;
    private boolean flexibleTypesForCode = false;
    private boolean secondaryConstructorsAsPrimary = true;
    private DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy = DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN;
    private DescriptorRenderer.ValueParametersHandler valueParametersHandler = new DescriptorRenderer.DefaultValueParameterHandler();
    private DescriptorRenderer.TextFormat textFormat = DescriptorRenderer.TextFormat.PLAIN;
    private DescriptorRenderer.ParameterNameRenderingPolicy parameterNameRenderingPolicy = DescriptorRenderer.ParameterNameRenderingPolicy.ALL;
    private Collection<FqName> excludedAnnotationClasses = Collections.emptyList();
    private boolean receiverAfterName = false;
    private boolean renderCompanionObjectName = false;
    private boolean renderAccessors = false;
    private Collection<FqName> excludedTypeAnnotationClasses = KotlinPackage.setOf(new FqName("org.jetbrains.annotations.ReadOnly"), new FqName("org.jetbrains.annotations.Mutable"), new FqName("org.jetbrains.annotations.NotNull"), new FqName("org.jetbrains.annotations.Nullable"));

    @NotNull
    public DescriptorRendererBuilder setNameShortness(NameShortness shortness) {
        this.nameShortness = shortness;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setNameShortness"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setWithDefinedIn(boolean withDefinedIn) {
        this.withDefinedIn = withDefinedIn;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setWithDefinedIn"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setModifiers(Set<DescriptorRenderer.Modifier> modifiers) {
        this.modifiers = modifiers;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setModifiers"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setModifiers(DescriptorRenderer.Modifier ... modifiers) {
        DescriptorRendererBuilder descriptorRendererBuilder = this.setModifiers(KotlinPackage.setOf(modifiers));
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setModifiers"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setStartFromName(boolean startFromName) {
        this.startFromName = startFromName;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setStartFromName"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setDebugMode"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setClassWithPrimaryConstructor(boolean classWithPrimaryConstructor) {
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setClassWithPrimaryConstructor"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setVerbose(boolean verbose) {
        this.verbose = verbose;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setVerbose"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setUnitReturnType(boolean unitReturnType) {
        this.unitReturnType = unitReturnType;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setUnitReturnType"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setNormalizedVisibilities(boolean normalizedVisibilities) {
        this.normalizedVisibilities = normalizedVisibilities;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setNormalizedVisibilities"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setShowInternalKeyword(boolean showInternalKeyword) {
        this.showInternalKeyword = showInternalKeyword;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setShowInternalKeyword"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setOverrideRenderingPolicy(@NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy) {
        if (overrideRenderingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideRenderingPolicy", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setOverrideRenderingPolicy"));
        }
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setOverrideRenderingPolicy"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler) {
        if (valueParametersHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParametersHandler", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setValueParametersHandler"));
        }
        this.valueParametersHandler = valueParametersHandler;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setValueParametersHandler"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setTextFormat(@NotNull DescriptorRenderer.TextFormat textFormat) {
        if (textFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFormat", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setTextFormat"));
        }
        this.textFormat = textFormat;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setTextFormat"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setExcludedAnnotationClasses(@NotNull Collection<FqName> excludedAnnotationClasses) {
        if (excludedAnnotationClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedAnnotationClasses", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setExcludedAnnotationClasses"));
        }
        this.excludedAnnotationClasses = excludedAnnotationClasses;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setExcludedAnnotationClasses"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setExcludedTypeAnnotationClasses(@NotNull Collection<FqName> excludedTypeAnnotationClasses) {
        if (excludedTypeAnnotationClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedTypeAnnotationClasses", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setExcludedTypeAnnotationClasses"));
        }
        this.excludedTypeAnnotationClasses = excludedTypeAnnotationClasses;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setExcludedTypeAnnotationClasses"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setPrettyFunctionTypes(boolean prettyFunctionTypes) {
        this.prettyFunctionTypes = prettyFunctionTypes;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setPrettyFunctionTypes"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setUninferredTypeParameterAsName(boolean uninferredTypeParameterAsName) {
        this.uninferredTypeParameterAsName = uninferredTypeParameterAsName;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setUninferredTypeParameterAsName"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setIncludePropertyConstant(boolean includePropertyConstant) {
        this.includePropertyConstant = includePropertyConstant;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setIncludePropertyConstant"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setParameterNameRenderingPolicy(@NotNull DescriptorRenderer.ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        if (parameterNameRenderingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterNameRenderingPolicy", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setParameterNameRenderingPolicy"));
        }
        this.parameterNameRenderingPolicy = parameterNameRenderingPolicy;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setParameterNameRenderingPolicy"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setWithoutTypeParameters(boolean withoutTypeParameters) {
        this.withoutTypeParameters = withoutTypeParameters;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setWithoutTypeParameters"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setReceiverAfterName(boolean receiverAfterName) {
        this.receiverAfterName = receiverAfterName;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setReceiverAfterName"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setRenderCompanionObjectName(boolean renderCompanionObjectName) {
        this.renderCompanionObjectName = renderCompanionObjectName;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setRenderCompanionObjectName"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setWithoutSuperTypes(boolean withoutSuperTypes) {
        this.withoutSuperTypes = withoutSuperTypes;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setWithoutSuperTypes"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setRenderDefaultValues(boolean renderDefaultValues) {
        this.renderDefaultValues = renderDefaultValues;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setRenderDefaultValues"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setTypeNormalizer(@NotNull Function1<JetType, JetType> typeNormalizer) {
        if (typeNormalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNormalizer", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setTypeNormalizer"));
        }
        this.typeNormalizer = typeNormalizer;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setTypeNormalizer"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setFlexibleTypesForCode(boolean flexibleTypesForCode) {
        this.flexibleTypesForCode = flexibleTypesForCode;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setFlexibleTypesForCode"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setSecondaryConstructorsAsPrimary(boolean secondaryConstructorsAsPrimary) {
        this.secondaryConstructorsAsPrimary = secondaryConstructorsAsPrimary;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setSecondaryConstructorsAsPrimary"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setRenderAccessors(boolean renderAccessors) {
        this.renderAccessors = renderAccessors;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "setRenderAccessors"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRenderer build() {
        DescriptorRendererImpl descriptorRendererImpl = new DescriptorRendererImpl(this.nameShortness, this.withDefinedIn, this.modifiers, this.startFromName, this.debugMode, this.classWithPrimaryConstructor, this.verbose, this.unitReturnType, this.normalizedVisibilities, this.showInternalKeyword, this.prettyFunctionTypes, this.uninferredTypeParameterAsName, this.overrideRenderingPolicy, this.valueParametersHandler, this.textFormat, this.excludedAnnotationClasses, this.excludedTypeAnnotationClasses, this.includePropertyConstant, this.parameterNameRenderingPolicy, this.withoutTypeParameters, this.receiverAfterName, this.renderCompanionObjectName, this.withoutSuperTypes, this.typeNormalizer, this.renderDefaultValues, this.flexibleTypesForCode, this.secondaryConstructorsAsPrimary, this.renderAccessors);
        if (descriptorRendererImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererBuilder", "build"));
        }
        return descriptorRendererImpl;
    }
}

