/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class SerializationUtil {
    private SerializationUtil() {
    }

    @NotNull
    public static byte[] serializeClassData(@NotNull ClassData classData) {
        byte[] byArray;
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeClassData"));
        }
        try {
            ByteArrayOutputStream result2 = new ByteArrayOutputStream();
            SerializationUtil.serializeNameResolver(result2, classData.getNameResolver());
            classData.getClassProto().writeTo(result2);
            byArray = result2.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeClassData"));
        }
        return byArray;
    }

    @NotNull
    public static byte[] serializePackageData(@NotNull PackageData packageData) {
        byte[] byArray;
        if (packageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageData", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializePackageData"));
        }
        try {
            ByteArrayOutputStream result2 = new ByteArrayOutputStream();
            SerializationUtil.serializeNameResolver(result2, packageData.getNameResolver());
            packageData.getPackageProto().writeTo(result2);
            byArray = result2.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializePackageData"));
        }
        return byArray;
    }

    private static void serializeNameResolver(@NotNull OutputStream out, @NotNull NameResolver nameResolver) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeNameResolver"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeNameResolver"));
        }
        SerializationUtil.serializeStringTable(out, nameResolver.getStringTable(), nameResolver.getQualifiedNameTable());
    }

    public static void serializeStringTable(@NotNull OutputStream out, @NotNull ProtoBuf.StringTable stringTable, @NotNull ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeStringTable"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeStringTable"));
        }
        if (qualifiedNameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameTable", "org/jetbrains/kotlin/serialization/SerializationUtil", "serializeStringTable"));
        }
        try {
            stringTable.writeDelimitedTo(out);
            qualifiedNameTable.writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }
}

