/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalyzerPackage;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ResolvePackage;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    private StatementFilter statementFilter;

    @Inject
    public void setStatementFilter(@NotNull StatementFilter statementFilter) {
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "setStatementFilter"));
        }
        this.statementFilter = statementFilter;
    }

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "<init>"));
        }
        this.expressionTypingComponents = components;
        this.expressionTypingFacade = ExpressionTypingVisitorDispatcher.create(components);
    }

    @NotNull
    public JetType safeGetType(@NotNull JetScope scope2, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        JetType type2 = this.getType(scope2, expression, expectedType, dataFlowInfo, trace);
        JetType jetType = AnalyzerPackage.safeType(type2, expression);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        return jetType;
    }

    @NotNull
    public JetTypeInfo getTypeInfo(@NotNull JetScope scope2, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(this.expressionTypingComponents.additionalCheckerProvider, trace, scope2, dataFlowInfo, expectedType);
        JetTypeInfo jetTypeInfo = this.expressionTypingFacade.getTypeInfo(expression, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getTypeInfo(@NotNull JetExpression expression, @NotNull ResolutionContext resolutionContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (resolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionContext", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        JetTypeInfo jetTypeInfo = this.expressionTypingFacade.getTypeInfo(expression, ExpressionTypingContext.newContext(resolutionContext));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public JetType getType(@NotNull JetScope scope2, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        return this.getTypeInfo(scope2, expression, expectedType, dataFlowInfo, trace).getType();
    }

    public void checkFunctionReturnType(@NotNull JetScope functionInnerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable JetType expectedReturnType, BindingTrace trace) {
        if (functionInnerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionInnerScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function.hasBlockBody() && !function.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function, ExpressionTypingContext.newContext(this.expressionTypingComponents.additionalCheckerProvider, trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE));
    }

    void checkFunctionReturnType(JetDeclarationWithBody function, ExpressionTypingContext context2) {
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context2;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public JetTypeInfo getBlockReturnedType(JetBlockExpression expression, ExpressionTypingContext context2, boolean isStatement) {
        JetTypeInfo jetTypeInfo = this.getBlockReturnedType(expression, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getBlockReturnedType(@NotNull JetBlockExpression expression, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        if (coercionStrategyForLastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coercionStrategyForLastExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        List<JetElement> block = ResolvePackage.filterStatements(this.statementFilter, expression);
        DeclarationDescriptor containingDescriptor = context2.scope.getContainingDeclaration();
        if (containingDescriptor instanceof ScriptDescriptor && !(expression.getParent() instanceof JetScript)) {
            containingDescriptor = ((ScriptDescriptor)containingDescriptor).getScriptCodeDescriptor();
        }
        WritableScopeImpl scope2 = new WritableScopeImpl(context2.scope, containingDescriptor, new TraceBasedRedeclarationHandler(context2.trace), "getBlockReturnedType");
        scope2.changeLockLevel(WritableScope.LockLevel.BOTH);
        JetTypeInfo r = block.isEmpty() ? TypeInfoFactoryPackage.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context2, expression) : this.getBlockReturnedTypeWithWritableScope(scope2, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context2.replaceStatementFilter(this.statementFilter));
        scope2.changeLockLevel(WritableScope.LockLevel.READING);
        if (containingDescriptor instanceof ScriptDescriptor) {
            context2.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope2);
        }
        JetTypeInfo jetTypeInfo = r;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull JetScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        JetExpression bodyExpression = function.getBodyExpression();
        assert (bodyExpression != null);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace);
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(this.expressionTypingComponents.additionalCheckerProvider, trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        JetTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context2, function.hasBlockBody());
        JetType type2 = typeInfo.getType();
        if (type2 != null) {
            JetType jetType = type2;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
            }
            return jetType;
        }
        JetType jetType = ErrorUtils.createErrorType("Error function type");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        return jetType;
    }

    JetTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull WritableScope scope2, @NotNull List<? extends JetElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (coercionStrategyForLastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coercionStrategyForLastExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (block.isEmpty()) {
            return TypeInfoFactoryPackage.createTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context2);
        }
        ExpressionTypingInternals blockLevelVisitor = ExpressionTypingVisitorDispatcher.createForBlock(this.expressionTypingComponents, scope2);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(scope2)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetTypeInfo result2 = TypeInfoFactoryPackage.noTypeInfo(context2);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        Iterator<? extends JetElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            JetElement statement = iterator2.next();
            if (!(statement instanceof JetExpression)) continue;
            JetExpression statementExpression = (JetExpression)statement;
            result2 = !iterator2.hasNext() ? this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context2.expectedType), coercionStrategyForLastExpression, blockLevelVisitor) : blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            DataFlowInfo newDataFlowInfo = result2.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result2.getJumpFlowInfo();
                jumpOutPossible = result2.getJumpOutPossible();
            }
            if (newDataFlowInfo != context2.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = ExpressionTypingVisitorDispatcher.createForBlock(this.expressionTypingComponents, scope2);
        }
        return result2.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private JetTypeInfo getTypeOfLastExpressionInBlock(@NotNull JetExpression statementExpression, @NotNull ExpressionTypingContext context2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        if (statementExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (coercionStrategyForLastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coercionStrategyForLastExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (blockLevelVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockLevelVisitor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (context2.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            JetType expectedType = context2.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context2.expectedType) ? TypeUtils.UNIT_EXPECTED_TYPE : context2.expectedType;
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)context2.replaceExpectedType(expectedType), true);
        }
        JetTypeInfo result2 = blockLevelVisitor.getTypeInfo(statementExpression, context2, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            JetBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof JetDeclaration) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof JetBinaryExpression && ((operationType = (binaryExpression = (JetBinaryExpression)statementExpression).getOperationToken()) == JetTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result2.getType() == null || KotlinBuiltIns.isUnit(result2.getType()));
                result2 = result2.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result2;
    }
}

