/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.core.JavaCoreBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClsElementImpl
extends PsiElementBase
implements PsiCompiledElement {
    public static final Key<PsiCompiledElement> COMPILED_ELEMENT = Key.create("COMPILED_ELEMENT");
    protected static final String CAN_NOT_MODIFY_MESSAGE = JavaCoreBundle.message("psi.error.attempt.to.edit.class.file", new Object[0]);
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsElementImpl");
    private volatile TreeElement myMirror = null;
    protected static final String NEXT_LINE = "go_to_next_line_and_indent";

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsElementImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public PsiManager getManager() {
        return this.getParent().getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return parent.getContainingFile();
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public boolean isValid() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isValid();
    }

    @Override
    public PsiElement copy() {
        return this;
    }

    @NotNull
    protected PsiElement[] getChildren(PsiElement ... children) {
        if (children == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsElementImpl", "getChildren"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList list = ContainerUtil.newArrayListWithCapacity(children.length);
        for (PsiElement child : children) {
            if (child == null) continue;
            list.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(list);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsElementImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsElementImpl", "checkAdd"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsElementImpl", "add"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsElementImpl", "addBefore"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsElementImpl", "addAfter"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/compiled/ClsElementImpl", "replace"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public abstract void appendMirrorText(int var1, @NotNull StringBuilder var2);

    protected int getIndentSize() {
        return JavaCodeStyleSettingsFacade.getInstance(this.getProject()).getIndentSize();
    }

    public abstract void setMirror(@NotNull TreeElement var1) throws InvalidMirrorException;

    @Override
    public PsiElement getMirror() {
        TreeElement mirror = this.myMirror;
        if (mirror == null) {
            ((ClsFileImpl)this.getContainingFile()).getMirror();
            mirror = this.myMirror;
        }
        return SourceTreeToPsiMap.treeElementToPsi(mirror);
    }

    @Override
    public final TextRange getTextRange() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Override
    public final int getStartOffsetInParent() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getStartOffsetInParent() : -1;
    }

    @Override
    public int getTextLength() {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    @Override
    public PsiElement findElementAt(int offset) {
        PsiElement mirror = this.getMirror();
        if (mirror == null) {
            return null;
        }
        PsiElement mirrorAt = mirror.findElementAt(offset);
        while (mirrorAt != null && !(mirrorAt instanceof PsiFile)) {
            PsiElement elementAt = this.mirrorToElement(mirrorAt);
            if (elementAt != null) {
                return elementAt;
            }
            mirrorAt = mirrorAt.getParent();
        }
        return null;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiElement mirror = this.getMirror();
        if (mirror == null) {
            return null;
        }
        PsiReference mirrorRef = mirror.findReferenceAt(offset);
        if (mirrorRef == null) {
            return null;
        }
        PsiElement mirrorElement = mirrorRef.getElement();
        PsiElement element = this.mirrorToElement(mirrorElement);
        if (element == null) {
            return null;
        }
        return element.getReference();
    }

    @Nullable
    private PsiElement mirrorToElement(PsiElement mirror) {
        PsiElement m = this.getMirror();
        if (m == mirror) {
            return this;
        }
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        for (PsiElement child : children) {
            PsiElement element;
            ClsElementImpl clsChild = (ClsElementImpl)child;
            if (!PsiTreeUtil.isAncestor(clsChild.getMirror(), mirror, false) || (element = clsChild.mirrorToElement(mirror)) == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public final int getTextOffset() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextOffset() : -1;
    }

    @Override
    public String getText() {
        PsiElement mirror = this.getMirror();
        if (mirror != null) {
            return mirror.getText();
        }
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        LOG.warn("Mirror wasn't set for " + this + " in " + this.getContainingFile() + ", expected text '" + buffer + "'");
        return buffer.toString();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        PsiElement mirror = this.getMirror();
        char[] cArray = mirror != null ? mirror.textToCharArray() : ArrayUtil.EMPTY_CHAR_ARRAY;
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsElementImpl", "textToCharArray"));
        }
        return cArray;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/compiled/ClsElementImpl", "textMatches"));
        }
        return this.getText().equals(((Object)text).toString());
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsElementImpl", "textMatches"));
        }
        return this.getText().equals(element.getText());
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    protected static void goNextLine(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsElementImpl", "goNextLine"));
        }
        buffer.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            buffer.append(' ');
        }
    }

    protected static void appendText(@NotNull PsiElement stub, int indentLevel, @NotNull StringBuilder buffer) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/compiled/ClsElementImpl", "appendText"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsElementImpl", "appendText"));
        }
        ((ClsElementImpl)stub).appendMirrorText(indentLevel, buffer);
    }

    protected static void appendText(@Nullable PsiElement stub, int indentLevel, @NotNull StringBuilder buffer, @NotNull String separator) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsElementImpl", "appendText"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/psi/impl/compiled/ClsElementImpl", "appendText"));
        }
        if (stub == null) {
            return;
        }
        int pos = buffer.length();
        ((ClsElementImpl)stub).appendMirrorText(indentLevel, buffer);
        if (buffer.length() != pos) {
            if (separator == NEXT_LINE) {
                ClsElementImpl.goNextLine(indentLevel, buffer);
            } else {
                buffer.append(separator);
            }
        }
    }

    protected void setMirrorCheckingType(@NotNull TreeElement element, @Nullable IElementType type2) throws InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrorCheckingType"));
        }
        if (type2 != null && element.getElementType() != type2) {
            throw new InvalidMirrorException(element.getElementType() + " != " + type2);
        }
        element.getPsi().putUserData(COMPILED_ELEMENT, this);
        this.myMirror = element;
    }

    protected static <T extends PsiElement> void setMirror(@Nullable T stub, @Nullable T mirror) throws InvalidMirrorException {
        if (stub == null || mirror == null) {
            throw new InvalidMirrorException(stub, mirror);
        }
        ((ClsElementImpl)stub).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
    }

    protected static <T extends PsiElement> void setMirrorIfPresent(@Nullable T stub, @Nullable T mirror) throws InvalidMirrorException {
        if (stub == null != (mirror == null)) {
            throw new InvalidMirrorException(stub, mirror);
        }
        if (stub != null) {
            ((ClsElementImpl)stub).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
        }
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull T[] stubs, @NotNull T[] mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubs", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrors"));
        }
        if (mirrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirrors", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrors"));
        }
        ClsElementImpl.setMirrors(Arrays.asList(stubs), Arrays.asList(mirrors));
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull List<T> stubs, @NotNull T[] mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubs", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrors"));
        }
        if (mirrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirrors", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrors"));
        }
        ClsElementImpl.setMirrors(stubs, Arrays.asList(mirrors));
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull List<T> stubs, @NotNull List<T> mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubs", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrors"));
        }
        if (mirrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirrors", "com/intellij/psi/impl/compiled/ClsElementImpl", "setMirrors"));
        }
        if (stubs.size() != mirrors.size()) {
            throw new InvalidMirrorException(stubs, mirrors);
        }
        for (int i = 0; i < stubs.size(); ++i) {
            ClsElementImpl.setMirror((PsiElement)stubs.get(i), (PsiElement)mirrors.get(i));
        }
    }

    protected static class InvalidMirrorException
    extends RuntimeException {
        public InvalidMirrorException(@NotNull @NonNls String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException", "<init>"));
            }
            super(message);
        }

        public InvalidMirrorException(@Nullable PsiElement stubElement, @Nullable PsiElement mirrorElement) {
            this("stub:" + stubElement + "; mirror:" + mirrorElement);
        }

        public InvalidMirrorException(@NotNull PsiElement[] stubElements, @NotNull PsiElement[] mirrorElements) {
            if (stubElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElements", "com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException", "<init>"));
            }
            if (mirrorElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirrorElements", "com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException", "<init>"));
            }
            this("stub:" + Arrays.toString(stubElements) + "; mirror:" + Arrays.toString(mirrorElements));
        }

        public InvalidMirrorException(@NotNull List<? extends PsiElement> stubElements, @NotNull List<? extends PsiElement> mirrorElements) {
            if (stubElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElements", "com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException", "<init>"));
            }
            if (mirrorElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirrorElements", "com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException", "<init>"));
            }
            this("stub:" + stubElements + "; mirror:" + mirrorElements);
        }
    }
}

