/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.ByteIterator;
import kotlin.Charsets;
import kotlin.deprecated;
import kotlin.io.IoPackage$Console$ff1ef61b;
import kotlin.io.IoPackage$IOStreams$d751dbe5;
import kotlin.io.IoPackage$ReadWrite$c8e99b89;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class IoPackage$IOStreams$d751dbe5 {
    @deprecated(value="It's not recommended to iterate through input stream bytes")
    @NotNull
    public static final ByteIterator iterator(@JetValueParameter(name="$receiver") InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteIterator($receiver){
            public static final /* synthetic */ KClass $kotlinClass;
            private int nextByte;
            private boolean nextPrepared;
            private boolean finished;
            final /* synthetic */ InputStream receiver$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(iterator.1.class);
            }

            public final int getNextByte() {
                return this.nextByte;
            }

            public final void setNextByte(@JetValueParameter(name="<set-?>") int n) {
                this.nextByte = n;
            }

            public final boolean getNextPrepared() {
                return this.nextPrepared;
            }

            public final void setNextPrepared(@JetValueParameter(name="<set-?>") boolean bl) {
                this.nextPrepared = bl;
            }

            public final boolean getFinished() {
                return this.finished;
            }

            public final void setFinished(@JetValueParameter(name="<set-?>") boolean bl) {
                this.finished = bl;
            }

            private final void prepareNext() {
                if (!this.nextPrepared && !this.finished) {
                    this.nextByte = this.receiver$0.read();
                    this.nextPrepared = true;
                    this.finished = this.nextByte == -1;
                }
            }

            public boolean hasNext() {
                this.prepareNext();
                return !this.finished;
            }

            public byte nextByte() {
                this.prepareNext();
                if (this.finished) {
                    throw (Throwable)new NoSuchElementException("Input stream is over");
                }
                byte res = (byte)this.nextByte;
                this.nextPrepared = false;
                return res;
            }
            {
                this.receiver$0 = $receiver;
                this.nextByte = -1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    @NotNull
    public static final InputStream buffered(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedInputStream ? (BufferedInputStream)$receiver : new BufferedInputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* synthetic */ InputStream buffered$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = IoPackage$Console$ff1ef61b.defaultBufferSize;
        }
        return IoPackage$IOStreams$d751dbe5.buffered(inputStream, n);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static /* synthetic */ InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$IOStreams$d751dbe5.reader(inputStream, charset);
    }

    @NotNull
    public static final BufferedReader bufferedReader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return IoPackage$ReadWrite$c8e99b89.buffered$default(IoPackage$IOStreams$d751dbe5.reader($receiver, charset), 0, 1);
    }

    @NotNull
    public static /* synthetic */ BufferedReader bufferedReader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$IOStreams$d751dbe5.bufferedReader(inputStream, charset);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static final BufferedReader bufferedReader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return IoPackage$ReadWrite$c8e99b89.buffered$default(IoPackage$IOStreams$d751dbe5.reader($receiver, charset), 0, 1);
    }

    @NotNull
    public static final BufferedOutputStream buffered(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* synthetic */ BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = IoPackage$Console$ff1ef61b.defaultBufferSize;
        }
        return IoPackage$IOStreams$d751dbe5.buffered(outputStream, n);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static /* synthetic */ OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$IOStreams$d751dbe5.writer(outputStream, charset);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return IoPackage$ReadWrite$c8e99b89.buffered$default(IoPackage$IOStreams$d751dbe5.writer($receiver, charset), 0, 1);
    }

    @NotNull
    public static /* synthetic */ BufferedWriter bufferedWriter$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$IOStreams$d751dbe5.bufferedWriter(outputStream, charset);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return IoPackage$ReadWrite$c8e99b89.buffered$default(IoPackage$IOStreams$d751dbe5.writer($receiver, charset), 0, 1);
    }

    public static final long copyTo(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="out") @NotNull OutputStream out, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = IoPackage$Console$ff1ef61b.defaultBufferSize;
        }
        return IoPackage$IOStreams$d751dbe5.copyTo(inputStream, outputStream, n);
    }

    @NotNull
    public static final byte[] readBytes(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="estimatedSize") int estimatedSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        IoPackage$IOStreams$d751dbe5.copyTo$default($receiver, buffer, 0, 2);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "buffer.toByteArray()");
        return byArray;
    }

    @NotNull
    public static /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = IoPackage$Console$ff1ef61b.defaultBufferSize;
        }
        return IoPackage$IOStreams$d751dbe5.readBytes(inputStream, n);
    }
}

