/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.platform;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.PlatformToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaToKotlinClassMap
implements PlatformToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqName, ClassDescriptor> javaToKotlin = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqNameUnsafe, ClassId> kotlinToJava = new HashMap<FqNameUnsafe, ClassId>();
    private final Map<ClassDescriptor, ClassDescriptor> mutableToReadOnly = new HashMap<ClassDescriptor, ClassDescriptor>();
    private final Map<ClassDescriptor, ClassDescriptor> readOnlyToMutable = new HashMap<ClassDescriptor, ClassDescriptor>();

    private JavaToKotlinClassMap() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        this.add(Object.class, builtIns.getAny());
        this.add(String.class, builtIns.getString());
        this.add(CharSequence.class, builtIns.getCharSequence());
        this.add(Throwable.class, builtIns.getThrowable());
        this.add(Cloneable.class, builtIns.getCloneable());
        this.add(Number.class, builtIns.getNumber());
        this.add(Comparable.class, builtIns.getComparable());
        this.add(Enum.class, builtIns.getEnum());
        this.add(Annotation.class, builtIns.getAnnotation());
        this.add(Iterable.class, builtIns.getIterable(), builtIns.getMutableIterable());
        this.add(Iterator.class, builtIns.getIterator(), builtIns.getMutableIterator());
        this.add(Collection.class, builtIns.getCollection(), builtIns.getMutableCollection());
        this.add(List.class, builtIns.getList(), builtIns.getMutableList());
        this.add(Set.class, builtIns.getSet(), builtIns.getMutableSet());
        this.add(Map.class, builtIns.getMap(), builtIns.getMutableMap());
        this.add(Map.Entry.class, builtIns.getMapEntry(), builtIns.getMutableMapEntry());
        this.add(ListIterator.class, builtIns.getListIterator(), builtIns.getMutableListIterator());
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            this.add(ClassId.topLevel(jvmType.getWrapperFqName()), builtIns.getPrimitiveClassDescriptor(jvmType.getPrimitiveType()));
        }
        for (ClassDescriptor descriptor2 : CompanionObjectMapping.allClassesWithIntrinsicCompanions()) {
            ClassDescriptor companion = descriptor2.getCompanionObjectDescriptor();
            assert (companion != null) : "No companion object found for " + descriptor2;
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.internal." + descriptor2.getName().asString() + "CompanionObject")), companion);
        }
        for (int i = 0; i < 23; ++i) {
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i)), builtIns.getFunction(i));
            for (FunctionClassDescriptor.Kind kind : FunctionClassDescriptor.Kinds.KFunctions) {
                String kFun = kind.getPackageFqName() + "." + kind.getClassNamePrefix();
                this.addKotlinToJava(new FqNameUnsafe(kFun + i), ClassId.topLevel(new FqName(kFun)));
            }
        }
        this.addJavaToKotlin(JavaToKotlinClassMap.classId(Deprecated.class), builtIns.getDeprecatedAnnotation());
        this.addKotlinToJava(builtIns.getNothing(), JavaToKotlinClassMap.classId(Void.class));
    }

    @Nullable
    public ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapJavaToKotlin"));
        }
        return this.javaToKotlin.get(fqName2);
    }

    @Nullable
    public ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapKotlinToJava"));
        }
        return this.kotlinToJava.get(kotlinFqName);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        ClassId javaClassId = JavaToKotlinClassMap.classId(javaClass);
        this.add(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(kotlinMutableDescriptor, javaClassId);
        this.mutableToReadOnly.put(kotlinMutableDescriptor, kotlinDescriptor);
        this.readOnlyToMutable.put(kotlinDescriptor, kotlinMutableDescriptor);
    }

    private void add(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        this.addJavaToKotlin(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(kotlinDescriptor, javaClassId);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        this.add(JavaToKotlinClassMap.classId(javaClass), kotlinDescriptor);
    }

    private void addJavaToKotlin(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addJavaToKotlin"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addJavaToKotlin"));
        }
        this.javaToKotlin.put(javaClassId.asSingleFqName(), kotlinDescriptor);
    }

    private void addKotlinToJava(@NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassId javaClassId) {
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        this.addKotlinToJava(DescriptorUtils.getFqName(kotlinDescriptor), javaClassId);
    }

    private void addKotlinToJava(@NotNull FqNameUnsafe kotlinFqName, @NotNull ClassId javaClassId) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        this.kotlinToJava.put(kotlinFqName, javaClassId);
    }

    @NotNull
    private static ClassId classId(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "classId"));
        }
        assert (!clazz.isPrimitive() && !clazz.isArray()) : "Invalid class: " + clazz;
        Class<?> outer = clazz.getDeclaringClass();
        ClassId classId = outer == null ? ClassId.topLevel(new FqName(clazz.getCanonicalName())) : JavaToKotlinClassMap.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "classId"));
        }
        return classId;
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        ClassDescriptor kotlinAnalog = this.mapJavaToKotlin(fqName2);
        if (kotlinAnalog == null) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return set;
        }
        ClassDescriptor kotlinMutableAnalog = this.readOnlyToMutable.get(kotlinAnalog);
        if (kotlinMutableAnalog == null) {
            Set<ClassDescriptor> set = Collections.singleton(kotlinAnalog);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return set;
        }
        List<ClassDescriptor> list = Arrays.asList(kotlinAnalog, kotlinMutableAnalog);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        Collection<ClassDescriptor> collection = className.isSafe() ? this.mapPlatformClass(className.toSafe()) : Collections.emptySet();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return collection;
    }

    public boolean isMutableCollection(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isMutableCollection"));
        }
        return this.mutableToReadOnly.containsKey(mutable);
    }

    public boolean isReadOnlyCollection(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isReadOnlyCollection"));
        }
        return this.readOnlyToMutable.containsKey(readOnly);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertMutableToReadOnly"));
        }
        ClassDescriptor readOnly = this.mutableToReadOnly.get(mutable);
        if (readOnly == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a mutable collection");
        }
        ClassDescriptor classDescriptor = readOnly;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertMutableToReadOnly"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertReadOnlyToMutable"));
        }
        ClassDescriptor mutable = this.readOnlyToMutable.get(readOnly);
        if (mutable == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a read-only collection");
        }
        ClassDescriptor classDescriptor = mutable;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertReadOnlyToMutable"));
        }
        return classDescriptor;
    }

    @NotNull
    public List<ClassDescriptor> allKotlinClasses() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>();
        result2.addAll(this.javaToKotlin.values());
        result2.addAll(this.readOnlyToMutable.values());
        for (PrimitiveType type2 : PrimitiveType.values()) {
            result2.add(builtIns.getPrimitiveArrayClassDescriptor(type2));
        }
        result2.add(builtIns.getUnit());
        result2.add(builtIns.getNothing());
        ArrayList<ClassDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "allKotlinClasses"));
        }
        return arrayList;
    }
}

